/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl.function;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.counter.impl.entries.CounterKey;
import org.infinispan.counter.impl.entries.CounterValue;
import org.infinispan.counter.impl.externalizers.ExternalizerIds;
import org.infinispan.counter.impl.function.BaseFunction;
import org.infinispan.counter.impl.function.FunctionHelper;
import org.infinispan.counter.logging.Log;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.impl.CounterConfigurationMetaParam;

public class CompareAndSwapFunction<K extends CounterKey>
extends BaseFunction<K, Object> {
    public static final AdvancedExternalizer<CompareAndSwapFunction> EXTERNALIZER = new Externalizer();
    private static final Log log = (Log)LogFactory.getLog(CompareAndSwapFunction.class, Log.class);
    private final long expect;
    private final long value;

    public CompareAndSwapFunction(long expect, long value) {
        this.expect = expect;
        this.value = value;
    }

    @Override
    Object apply(EntryView.ReadWriteEntryView<K, CounterValue> entryView, CounterConfigurationMetaParam metadata) {
        return FunctionHelper.compareAndSwap(entryView, (CounterValue)entryView.get(), metadata, this.expect, this.value);
    }

    @Override
    protected Log getLog() {
        return log;
    }

    private static class Externalizer
    implements AdvancedExternalizer<CompareAndSwapFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends CompareAndSwapFunction>> getTypeClasses() {
            return Collections.singleton(CompareAndSwapFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.CAS_FUNCTION;
        }

        public void writeObject(ObjectOutput output, CompareAndSwapFunction object) throws IOException {
            output.writeLong(object.expect);
            output.writeLong(object.value);
        }

        public CompareAndSwapFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new CompareAndSwapFunction(input.readLong(), input.readLong());
        }
    }
}

