/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.LinkedHashMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.util.SecurityActions;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.commons.util.Util;
import org.wildfly.openssl.OpenSSLProvider;
import org.wildfly.openssl.SSL;

public class SslContextFactory {
    private static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    private static final String DEFAULT_SSL_PROTOCOL = "TLSv1.2";
    private static final String CLASSPATH_RESOURCE = "classpath:";
    private static final String SSL_PROVIDER;
    private static final ConcurrentHashMap<ClassLoader, Provider[]> PER_CLASSLOADER_PROVIDERS;
    private String keyStoreFileName;
    private char[] keyStorePassword;
    private char[] keyStoreCertificatePassword;
    private String keyStoreType = "JKS";
    private String keyAlias;
    private String trustStoreFileName;
    private char[] trustStorePassword;
    private String trustStoreType = "JKS";
    private String sslProtocol = "TLSv1.2";
    private boolean useNativeIfAvailable = true;
    private ClassLoader classLoader;
    private String provider;

    public SslContextFactory keyStoreFileName(String keyStoreFileName) {
        this.keyStoreFileName = keyStoreFileName;
        return this;
    }

    public SslContextFactory keyStorePassword(char[] keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public SslContextFactory keyStoreCertificatePassword(char[] keyStoreCertificatePassword) {
        this.keyStoreCertificatePassword = keyStoreCertificatePassword;
        return this;
    }

    public SslContextFactory keyStoreType(String keyStoreType) {
        if (keyStoreType != null) {
            this.keyStoreType = keyStoreType;
        }
        return this;
    }

    public SslContextFactory keyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
        return this;
    }

    public SslContextFactory trustStoreFileName(String trustStoreFileName) {
        this.trustStoreFileName = trustStoreFileName;
        return this;
    }

    public SslContextFactory trustStorePassword(char[] trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    public SslContextFactory trustStoreType(String trustStoreType) {
        if (trustStoreType != null) {
            this.trustStoreType = trustStoreType;
        }
        return this;
    }

    public SslContextFactory sslProtocol(String sslProtocol) {
        if (sslProtocol != null) {
            this.sslProtocol = sslProtocol;
        }
        return this;
    }

    public SslContextFactory provider(String provider) {
        if (provider != null) {
            this.provider = provider;
        }
        return this;
    }

    public SslContextFactory useNativeIfAvailable(boolean useNativeIfAvailable) {
        this.useNativeIfAvailable = useNativeIfAvailable;
        return this;
    }

    public SslContextFactory classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public SSLContext getContext() {
        try {
            KeyManager[] keyManagers = null;
            if (this.keyStoreFileName != null) {
                KeyManagerFactory kmf = this.getKeyManagerFactory();
                keyManagers = kmf.getKeyManagers();
            }
            TrustManager[] trustManagers = null;
            if (this.trustStoreFileName != null) {
                TrustManagerFactory tmf = this.getTrustManagerFactory();
                trustManagers = tmf.getTrustManagers();
            }
            Provider provider = null;
            if (this.provider != null) {
                provider = SslContextFactory.findProvider(this.provider, SSLContext.class.getSimpleName(), this.sslProtocol);
            }
            if (provider == null && this.useNativeIfAvailable && SSL_PROVIDER != null) {
                provider = SslContextFactory.findProvider(SSL_PROVIDER, SSLContext.class.getSimpleName(), this.sslProtocol);
            }
            SSLContext sslContext = provider != null ? SSLContext.getInstance(this.sslProtocol, provider) : SSLContext.getInstance(this.sslProtocol);
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext;
        }
        catch (Exception e) {
            throw Log.SECURITY.sslInitializationException(e);
        }
    }

    public KeyManagerFactory getKeyManagerFactory() throws IOException, GeneralSecurityException {
        char[] keyPassword;
        String type = this.keyStoreType != null ? this.keyStoreType : DEFAULT_KEYSTORE_TYPE;
        Provider provider = SslContextFactory.findProvider(this.provider, KeyManagerFactory.class.getSimpleName(), type);
        KeyStore ks = provider != null ? KeyStore.getInstance(type, provider) : KeyStore.getInstance(type);
        SslContextFactory.loadKeyStore(ks, this.keyStoreFileName, this.keyStorePassword, this.classLoader);
        char[] cArray = keyPassword = this.keyStoreCertificatePassword == null ? this.keyStorePassword : this.keyStoreCertificatePassword;
        if (this.keyAlias != null) {
            if (ks.containsAlias(this.keyAlias) && ks.isKeyEntry(this.keyAlias)) {
                KeyStore.PasswordProtection passParam = new KeyStore.PasswordProtection(keyPassword);
                KeyStore.Entry entry = ks.getEntry(this.keyAlias, passParam);
                ks = provider != null ? KeyStore.getInstance(type, provider) : KeyStore.getInstance(type);
                ks.load(null, null);
                ks.setEntry(this.keyAlias, entry, passParam);
            } else {
                throw Log.SECURITY.noSuchAliasInKeyStore(this.keyAlias, this.keyStoreFileName);
            }
        }
        String algorithm = KeyManagerFactory.getDefaultAlgorithm();
        provider = SslContextFactory.findProvider(this.provider, KeyManagerFactory.class.getSimpleName(), algorithm);
        KeyManagerFactory kmf = provider != null ? KeyManagerFactory.getInstance(algorithm, provider) : KeyManagerFactory.getInstance(algorithm);
        kmf.init(ks, keyPassword);
        return kmf;
    }

    public TrustManagerFactory getTrustManagerFactory() throws IOException, GeneralSecurityException {
        String type = this.trustStoreType != null ? this.trustStoreType : DEFAULT_KEYSTORE_TYPE;
        Provider provider = SslContextFactory.findProvider(this.provider, KeyStore.class.getSimpleName(), this.trustStoreType);
        KeyStore ks = provider != null ? KeyStore.getInstance(type, provider) : KeyStore.getInstance(type);
        SslContextFactory.loadKeyStore(ks, this.trustStoreFileName, this.trustStorePassword, this.classLoader);
        String algorithm = KeyManagerFactory.getDefaultAlgorithm();
        provider = SslContextFactory.findProvider(this.provider, TrustManagerFactory.class.getSimpleName(), algorithm);
        TrustManagerFactory tmf = provider != null ? TrustManagerFactory.getInstance(algorithm, provider) : TrustManagerFactory.getInstance(algorithm);
        tmf.init(ks);
        return tmf;
    }

    public static String getSslProvider() {
        return SSL_PROVIDER;
    }

    public static SSLEngine getEngine(SSLContext sslContext, boolean useClientMode, boolean needClientAuth) {
        SSLEngine sslEngine = sslContext.createSSLEngine();
        sslEngine.setUseClientMode(useClientMode);
        sslEngine.setNeedClientAuth(needClientAuth);
        return sslEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadKeyStore(KeyStore ks, String keyStoreFileName, char[] keyStorePassword, ClassLoader classLoader) throws IOException, GeneralSecurityException {
        InputStream is = null;
        try {
            if (keyStoreFileName.startsWith(CLASSPATH_RESOURCE)) {
                String fileName = keyStoreFileName.substring(keyStoreFileName.indexOf(":") + 1);
                is = Util.getResourceAsStream(fileName, classLoader);
                if (is == null) {
                    throw Log.SECURITY.cannotFindResource(keyStoreFileName);
                }
            } else {
                is = new BufferedInputStream(new FileInputStream(keyStoreFileName));
            }
            ks.load(is, keyStorePassword);
        }
        catch (Throwable throwable) {
            Util.close(is);
            throw throwable;
        }
        Util.close((AutoCloseable)is);
    }

    public static Provider findProvider(String providerName, String serviceType, String algorithm) {
        Provider[] providers;
        for (Provider provider : providers = SslContextFactory.discoverSecurityProviders(Thread.currentThread().getContextClassLoader())) {
            Provider.Service providerService;
            if (providerName != null && !providerName.equals(provider.getName()) || (providerService = provider.getService(serviceType, algorithm)) == null) continue;
            return provider;
        }
        return null;
    }

    public static Provider[] discoverSecurityProviders(ClassLoader classLoader) {
        return PER_CLASSLOADER_PROVIDERS.computeIfAbsent(classLoader, cl -> {
            LinkedHashMap providers = new LinkedHashMap();
            for (Provider provider : Security.getProviders()) {
                providers.put(provider.getClass(), provider);
            }
            for (Provider provider : ServiceFinder.load(Provider.class, classLoader)) {
                providers.putIfAbsent(provider.getClass(), provider);
            }
            return providers.values().toArray(new Provider[0]);
        });
    }

    static {
        PER_CLASSLOADER_PROVIDERS = new ConcurrentHashMap(2);
        String sslProvider = null;
        if (Boolean.parseBoolean(SecurityActions.getProperty("org.infinispan.openssl", "true"))) {
            try {
                OpenSSLProvider.register();
                SSL.getInstance();
                sslProvider = "openssl";
                Log.SECURITY.openSSLAvailable();
            }
            catch (Throwable e) {
                Log.SECURITY.openSSLNotAvailable();
            }
        }
        SSL_PROVIDER = sslProvider;
    }
}

