/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.test.skip;

import java.util.Arrays;
import org.infinispan.commons.test.skip.OS;
import org.testng.SkipException;

public class SkipTestNG {
    public static void skipIf(boolean skip, String message) {
        if (skip) {
            throw new SkipException(message);
        }
    }

    public static void skipOnOS(OS ... oses) {
        OS currentOs = OS.getCurrentOs();
        if (Arrays.asList(oses).contains((Object)currentOs)) {
            throw new SkipException("Skipping test on " + (Object)((Object)currentOs));
        }
    }

    public static void onlyOnOS(OS ... oses) {
        OS currentOs = OS.getCurrentOs();
        if (!Arrays.asList(oses).contains((Object)currentOs)) {
            throw new SkipException("Skipping test on " + (Object)((Object)currentOs));
        }
    }

    public static void skipSinceJDK(int major) {
        int version = SkipTestNG.getJDKVersion();
        if (version >= major) {
            throw new SkipException("Skipping test on JDK " + version);
        }
    }

    public static void skipBeforeJDK(int major) {
        int version = SkipTestNG.getJDKVersion();
        if (version < major) {
            throw new SkipException("Skipping test on JDK " + version);
        }
    }

    private static int getJDKVersion() {
        String[] parts = System.getProperty("java.version").replaceAll("[^0-9\\.]", "").split("\\.");
        int version = Integer.parseInt(parts[0]);
        if (version == 1) {
            version = Integer.parseInt(parts[1]);
        }
        return version;
    }
}

