/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.infinispan.commons.dataconversion.JavaMediaTypeCodec;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.MediaTypeCodec;
import org.infinispan.commons.dataconversion.RFC4648Codec;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.dataconversion.UrlFormCodec;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.util.Util;

public abstract class AbstractTranscoder
implements Transcoder {
    private static final List<MediaTypeCodec> CODECS = new ArrayList<MediaTypeCodec>();

    protected Object decodeContent(Object content, MediaType contentType) throws UnsupportedEncodingException {
        if (content == null) {
            return null;
        }
        Objects.requireNonNull(contentType, "contentType cannot be null!");
        for (MediaTypeCodec coded : CODECS) {
            content = coded.decodeContent(content, contentType);
        }
        return content;
    }

    protected Object encodeContent(Object content, MediaType destinationType) throws UnsupportedEncodingException {
        if (content == null) {
            return null;
        }
        for (MediaTypeCodec codec : CODECS) {
            content = codec.encodeContent(content, destinationType);
        }
        return content;
    }

    @Override
    public Object transcode(Object content, MediaType contentType, MediaType destinationType) {
        try {
            Object decoded = this.decodeContent(content, contentType);
            Object result = this.doTranscode(decoded, contentType, destinationType);
            return this.encodeContent(result, destinationType);
        }
        catch (UnsupportedEncodingException e) {
            throw Log.CONTAINER.errorTranscoding(Util.toStr(content), contentType, destinationType, e);
        }
    }

    protected abstract Object doTranscode(Object var1, MediaType var2, MediaType var3);

    static {
        CODECS.add(new JavaMediaTypeCodec());
        CODECS.add(new UrlFormCodec());
        CODECS.add(new RFC4648Codec());
    }
}

