/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Collection;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.IntFunction;

public class FlattenSpliterator<E>
implements Spliterator<E> {
    private final IntFunction<Collection<E>> toCollection;
    private final int length;
    private int index;
    private final int fence;
    private final int characteristics;
    private Spliterator<E> currentSpliterator;

    public FlattenSpliterator(IntFunction<Collection<E>> toCollection, int length, int additionalCharacteristics) {
        this(toCollection, length, 0, length, additionalCharacteristics);
    }

    private FlattenSpliterator(IntFunction<Collection<E>> toCollection, int length, int index, int fence, int characteristics) {
        this.toCollection = toCollection;
        this.length = length;
        if (index < 0) {
            throw new IllegalArgumentException("Index " + index + " was less than 0!");
        }
        this.index = index;
        this.fence = fence;
        this.characteristics = characteristics;
    }

    @Override
    public boolean tryAdvance(Consumer<? super E> action) {
        boolean advanced = false;
        while (!(this.currentSpliterator != null && (advanced = this.currentSpliterator.tryAdvance(action)) || this.index >= this.fence)) {
            this.currentSpliterator = this.toCollection.apply(this.index++).spliterator();
        }
        return advanced;
    }

    @Override
    public void forEachRemaining(Consumer<? super E> action) {
        while (this.index < this.fence) {
            this.toCollection.apply(this.index).spliterator().forEachRemaining(action);
            ++this.index;
        }
    }

    @Override
    public Spliterator<E> trySplit() {
        FlattenSpliterator<E> flattenSpliterator;
        int lo = this.index;
        int mid = lo + this.fence >>> 1;
        if (lo >= mid) {
            flattenSpliterator = null;
        } else {
            this.index = mid;
            FlattenSpliterator<E> flattenSpliterator2 = new FlattenSpliterator<E>(this.toCollection, this.length, lo, this.index, this.characteristics);
            flattenSpliterator = flattenSpliterator2;
        }
        return flattenSpliterator;
    }

    @Override
    public long estimateSize() {
        long estimate = 0L;
        if (this.currentSpliterator != null) {
            estimate += this.currentSpliterator.estimateSize();
        }
        if (estimate == Long.MAX_VALUE) {
            return estimate;
        }
        for (int i = this.index; i < this.fence; ++i) {
            if ((estimate += (long)this.toCollection.apply(i).size()) >= 0L) continue;
            return Long.MAX_VALUE;
        }
        return estimate;
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }
}

