package org.infinispan.commons.logging;

import java.util.Locale;
import java.lang.Enum;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.CacheException;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.commons.CacheConfigurationException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.RuntimeException;
import java.lang.Number;
import org.infinispan.counter.exception.CounterOutOfBoundsException;
import org.jboss.logging.BasicLogger;
import org.infinispan.commons.dataconversion.MediaType;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;
import javax.annotation.processing.Generated;
import java.util.EnumSet;
import java.time.Instant;
import java.lang.SecurityException;
import java.io.IOException;
import java.lang.Exception;
import java.lang.Throwable;
import java.lang.Object;
import java.lang.Class;
import org.infinispan.counter.exception.CounterException;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2025-08-14T18:05:17+0000")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void propertyCouldNotBeReplaced(final String line) {
        super.log.logf(FQCN, WARN, null, propertyCouldNotBeReplaced$str(), line);
    }
    protected String propertyCouldNotBeReplaced$str() {
        return "ISPN000901: Property %s could not be replaced as intended!";
    }
    @Override
    public final void ignoringException(final String methodName, final String exceptionName, final Throwable t) {
        super.log.logf(FQCN, WARN, t, ignoringException$str(), methodName, exceptionName);
    }
    protected String ignoringException$str() {
        return "ISPN000902: Invocation of %s threw an exception %s. Exception is ignored.";
    }
    protected String sslInitializationException$str() {
        return "ISPN000904: Error while initializing SSL context";
    }
    @Override
    public final CacheConfigurationException sslInitializationException(final Throwable e) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), sslInitializationException$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void unableToLoadClass(final String classname, final String classloaders, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, unableToLoadClass$str(), classname, classloaders);
    }
    protected String unableToLoadClass$str() {
        return "ISPN000905: Unable to load %s from any of the following classloaders: %s";
    }
    @Override
    public final void unableToConvertStringPropertyToInt(final String value, final int defaultValue) {
        super.log.logf(FQCN, WARN, null, unableToConvertStringPropertyToInt$str(), value, defaultValue);
    }
    protected String unableToConvertStringPropertyToInt$str() {
        return "ISPN000906: Unable to convert string property [%s] to an int! Using default value of %d";
    }
    @Override
    public final void unableToConvertStringPropertyToLong(final String value, final long defaultValue) {
        super.log.logf(FQCN, WARN, null, unableToConvertStringPropertyToLong$str(), value, defaultValue);
    }
    protected String unableToConvertStringPropertyToLong$str() {
        return "ISPN000907: Unable to convert string property [%s] to a long! Using default value of %d";
    }
    @Override
    public final void unableToConvertStringPropertyToBoolean(final String value, final boolean defaultValue) {
        super.log.logf(FQCN, WARN, null, unableToConvertStringPropertyToBoolean$str(), value, defaultValue);
    }
    protected String unableToConvertStringPropertyToBoolean$str() {
        return "ISPN000908: Unable to convert string property [%s] to a boolean! Using default value of %b";
    }
    protected String unableToUnwrap$str() {
        return "ISPN000909: Unwrapping %s to a type of %s is not a supported";
    }
    @Override
    public final IllegalArgumentException unableToUnwrap(final Object o, final Class<?> clazz) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unableToUnwrap$str(), o, clazz));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalValueThreadPoolParameter$str() {
        return "ISPN000910: Illegal value for thread pool parameter(s) %s, it should be: %s";
    }
    @Override
    public final CacheConfigurationException illegalValueThreadPoolParameter(final String parameter, final String requirement) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), illegalValueThreadPoolParameter$str(), parameter, requirement));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToUnwrapAny$str() {
        return "ISPN000911: Unwrapping of any instances in %s to a type of %s is not a supported";
    }
    @Override
    public final IllegalArgumentException unableToUnwrapAny(final String objs, final Class<?> clazz) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unableToUnwrapAny$str(), objs, clazz));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unprotectedAttributeSet$str() {
        return "ISPN000912: Expecting a protected configuration for %s";
    }
    @Override
    public final IllegalStateException unprotectedAttributeSet(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unprotectedAttributeSet$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String protectedAttributeSet$str() {
        return "ISPN000913: Expecting an unprotected configuration for %s";
    }
    @Override
    public final IllegalStateException protectedAttributeSet(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), protectedAttributeSet$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String attributeSetDuplicateAttribute$str() {
        return "ISPN000914: Duplicate attribute '%s' in attribute set '%s'";
    }
    @Override
    public final IllegalArgumentException attributeSetDuplicateAttribute(final String name, final String setName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), attributeSetDuplicateAttribute$str(), name, setName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noSuchAttribute$str() {
        return "ISPN000915: No such attribute '%s' in attribute set '%s'";
    }
    @Override
    public final IllegalArgumentException noSuchAttribute(final String name, final String setName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noSuchAttribute$str(), name, setName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noAttributeCopierForType$str() {
        return "ISPN000916: No attribute copier for type '%s'";
    }
    @Override
    public final IllegalArgumentException noAttributeCopierForType(final Class<?> klass) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noAttributeCopierForType$str(), klass));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotFindResource$str() {
        return "ISPN000918: Cannot find resource '%s'";
    }
    @Override
    public final IOException cannotFindResource(final String fileName) {
        final IOException result = new IOException(String.format(getLoggingLocale(), cannotFindResource$str(), fileName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleConfigurationValidationErrors$str() {
        return "ISPN000919: Multiple errors encountered while validating configuration";
    }
    @Override
    public final CacheConfigurationException multipleConfigurationValidationErrors() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), multipleConfigurationValidationErrors$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToLoadFileUsingScheme$str() {
        return "ISPN000920: Unable to load file using scheme %s";
    }
    @Override
    public final UnsupportedOperationException unableToLoadFileUsingScheme(final String scheme) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), unableToLoadFileUsingScheme$str(), scheme));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noSuchAliasInKeyStore$str() {
        return "ISPN000921: The alias '%s' does not exist in the key store '%s'";
    }
    @Override
    public final SecurityException noSuchAliasInKeyStore(final String keyAlias, final String keyStoreFileName) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), noSuchAliasInKeyStore$str(), keyAlias, keyStoreFileName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void errorRollingBack(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, errorRollingBack$str());
    }
    protected String errorRollingBack$str() {
        return "ISPN000922: Exception during rollback";
    }
    @Override
    public final void errorEnlistingResource(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, errorEnlistingResource$str());
    }
    protected String errorEnlistingResource$str() {
        return "ISPN000923: Error enlisting resource";
    }
    @Override
    public final void beforeCompletionFailed(final String synchronization, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, beforeCompletionFailed$str(), synchronization);
    }
    protected String beforeCompletionFailed$str() {
        return "ISPN000924: beforeCompletion() failed for %s";
    }
    @Override
    public final void unexpectedErrorFromResourceManager(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unexpectedErrorFromResourceManager$str());
    }
    protected String unexpectedErrorFromResourceManager$str() {
        return "ISPN000925: Unexpected error from resource manager!";
    }
    @Override
    public final void afterCompletionFailed(final String synchronization, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, afterCompletionFailed$str(), synchronization);
    }
    protected String afterCompletionFailed$str() {
        return "ISPN000926: afterCompletion() failed for %s";
    }
    @Override
    public final void errorCommittingTx(final Throwable e) {
        super.log.logf(FQCN, WARN, e, errorCommittingTx$str());
    }
    protected String errorCommittingTx$str() {
        return "ISPN000927: exception while committing";
    }
    @Override
    public final void xaResourceEndFailed(final String xaResource, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, xaResourceEndFailed$str(), xaResource);
    }
    protected String xaResourceEndFailed$str() {
        return "ISPN000928: end() failed for %s";
    }
    protected String missingMediaType$str() {
        return "ISPN000929: Media type cannot be empty or null!";
    }
    @Override
    public final EncodingException missingMediaType() {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), missingMediaType$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidMediaTypeSubtype$str() {
        return "ISPN000930: Invalid media type '%s': must contain a type and a subtype separated by '/'";
    }
    @Override
    public final EncodingException invalidMediaTypeSubtype(final String mediaType) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), invalidMediaTypeSubtype$str(), mediaType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidMediaTypeParam$str() {
        return "ISPN000931: Invalid media type '%s': invalid param '%s'";
    }
    @Override
    public final EncodingException invalidMediaTypeParam(final String mediaType, final String param) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), invalidMediaTypeParam$str(), mediaType, param));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidMediaTypeListCommaAtEnd$str() {
        return "ISPN000933: Invalid media type list '%s': type expected after comma";
    }
    @Override
    public final EncodingException invalidMediaTypeListCommaAtEnd(final String mediaType) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), invalidMediaTypeListCommaAtEnd$str(), mediaType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorTranscoding$str() {
        return "ISPN000934: Errors converting '%s' from '%s' to '%s'";
    }
    @Override
    public final EncodingException errorTranscoding(final String content, final MediaType contentType, final MediaType requestType, final Throwable t) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), errorTranscoding$str(), content, contentType, requestType), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidWeight$str() {
        return "ISPN000935: Invalid Weight '%s'. Supported values are between 0 and 1.0";
    }
    @Override
    public final EncodingException invalidWeight(final Object weight) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), invalidWeight$str(), weight));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String classNotInAllowList$str() {
        return "ISPN000936: Class '%s' blocked by deserialization allow list. Adjust the configuration serialization allow list regular expression to include this class.";
    }
    @Override
    public final CacheException classNotInAllowList(final String className) {
        final CacheException result = new CacheException(String.format(getLoggingLocale(), classNotInAllowList$str(), className));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidMediaType$str() {
        return "ISPN000937: Invalid media type. Expected '%s' but got '%s'";
    }
    @Override
    public final EncodingException invalidMediaType(final String expected, final String actual) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), invalidMediaType$str(), expected, actual));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidTextContent$str() {
        return "ISPN000938: Invalid text content '%s'";
    }
    @Override
    public final EncodingException invalidTextContent(final Object content) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), invalidTextContent$str(), content));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String conversionNotSupported$str() {
        return "ISPN000939: Conversion of content '%s' from '%s' to '%s' not supported";
    }
    @Override
    public final EncodingException conversionNotSupported(final Object content, final String fromMediaType, final String toMediaType) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), conversionNotSupported$str(), content, fromMediaType, toMediaType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotDecodeFormURLContent$str() {
        return "ISPN000940: Invalid application/x-www-form-urlencoded content: '%s'";
    }
    @Override
    public final EncodingException cannotDecodeFormURLContent(final Object content) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), cannotDecodeFormURLContent$str(), content));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorEncoding$str() {
        return "ISPN000941: Error encoding content '%s' to '%s'";
    }
    @Override
    public final EncodingException errorEncoding(final Object content, final MediaType mediaType) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), errorEncoding$str(), content, mediaType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void unableToConvertStringPropertyToEnum(final String value, final String defaultValue) {
        super.log.logf(FQCN, WARN, null, unableToConvertStringPropertyToEnum$str(), value, defaultValue);
    }
    protected String unableToConvertStringPropertyToEnum$str() {
        return "ISPN000942: Unable to convert property [%s] to an enum! Using default value of %d";
    }
    protected String featureDisabled$str() {
        return "ISPN000944: Feature %s is disabled!";
    }
    @Override
    public final CacheConfigurationException featureDisabled(final String feature) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), featureDisabled$str(), feature));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedConversion3$str() {
        return "ISPN000948: Unsupported conversion of '%s' from '%s' to '%s'";
    }
    @Override
    public final EncodingException unsupportedConversion(final String content, final MediaType contentType, final MediaType requestType) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), unsupportedConversion3$str(), content, contentType, requestType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedConversion2$str() {
        return "ISPN000949: Unsupported conversion of '%s' to '%s'";
    }
    @Override
    public final EncodingException unsupportedConversion(final String content, final MediaType requestType) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), unsupportedConversion2$str(), content, requestType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String encodingNotSupported$str() {
        return "ISPN000950: Encoding '%s' is not supported";
    }
    @Override
    public final EncodingException encodingNotSupported(final String enc) {
        final EncodingException result = new EncodingException(String.format(getLoggingLocale(), encodingNotSupported$str(), enc));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String attributeMustBeGreaterThanZero$str() {
        return "ISPN000951: Invalid value %s for attribute %s: must be a number greater than zero";
    }
    @Override
    public final CacheConfigurationException attributeMustBeGreaterThanZero(final Number value, final Enum<?> attribute) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), attributeMustBeGreaterThanZero$str(), value, attribute));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void telemetryLoaded(final Object telemetry) {
        super.log.logf(FQCN, INFO, null, telemetryLoaded$str(), telemetry);
    }
    protected String telemetryLoaded$str() {
        return "ISPN000952: OpenTelemetry tracing instance loaded: %s";
    }
    @Override
    public final void errorOnLoadingTelemetry(final Throwable t) {
        super.log.logf(FQCN, WARN, t, errorOnLoadingTelemetry$str());
    }
    protected String errorOnLoadingTelemetry$str() {
        return "ISPN000954: OpenTelemetry tracing cannot be configured.";
    }
    protected String illegalBooleanValue$str() {
        return "ISPN000955: '%s' is not a valid boolean value (true|false|yes|no|y|n|on|off)";
    }
    @Override
    public final IllegalArgumentException illegalBooleanValue(final String value) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalBooleanValue$str(), value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalEnumValue$str() {
        return "ISPN000956: '%s' is not one of %s";
    }
    @Override
    public final IllegalArgumentException illegalEnumValue(final String value, final EnumSet<?> set) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalEnumValue$str(), value, set));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void cannotLoadMimeTypes(final String mimeTypes) {
        super.log.logf(FQCN, ERROR, null, cannotLoadMimeTypes$str(), mimeTypes);
    }
    protected String cannotLoadMimeTypes$str() {
        return "ISPN000957: Cannot load %s";
    }
    protected String cannotParseQuantity$str() {
        return "ISPN000958: Cannot parse bytes quantity %s";
    }
    @Override
    public final IllegalArgumentException cannotParseQuantity(final String str) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotParseQuantity$str(), str));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void deprecatedProperty(final String oldName, final String newName) {
        super.log.logf(FQCN, WARN, null, deprecatedProperty$str(), oldName, newName);
    }
    protected String deprecatedProperty$str() {
        return "ISPN000959: Property '%s' has been deprecated. Please use '%s' instead.";
    }
    protected String noAttribute$str() {
        return "ISPN000960: No attribute '%s' in '%s'";
    }
    @Override
    public final IllegalArgumentException noAttribute(final String name, final String element) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noAttribute$str(), name, element));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String incompatibleAttribute$str() {
        return "ISPN000961: Incompatible attribute '%s.%s' existing value='%s', new value='%s'";
    }
    @Override
    public final IllegalArgumentException incompatibleAttribute(final String parentName, final String name, final String v1, final String v2) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), incompatibleAttribute$str(), parentName, name, v1, v2));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String protectedAttribute$str() {
        return "ISPN000962: Cannot modify protected attribute '%s'";
    }
    @Override
    public final IllegalStateException protectedAttribute(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), protectedAttribute$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidConfiguration$str() {
        return "ISPN000963: Invalid configuration in '%s'";
    }
    @Override
    public final IllegalArgumentException invalidConfiguration(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidConfiguration$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String respCacheKeyMediaTypeSupplied$str() {
        return "ISPN000964: RESP cache '%s' key media type must be configured as application/octet-stream but was %s";
    }
    @Override
    public final IllegalArgumentException respCacheKeyMediaTypeSupplied(final String cacheName, final MediaType mediaType) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), respCacheKeyMediaTypeSupplied$str(), cacheName, mediaType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String respCacheSegmentSizePow2$str() {
        return "ISPN000965: Relation between segment and slots only for power 2, received: %s";
    }
    @Override
    public final IllegalArgumentException respCacheSegmentSizePow2(final int configured) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), respCacheSegmentSizePow2$str(), configured));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String respCacheUseDefineConsistentHash$str() {
        return "ISPN000966: RESP cache '%s' should use RESPHashFunctionPartitioner but is using %s";
    }
    @Override
    public final IllegalArgumentException respCacheUseDefineConsistentHash(final String cacheName, final String configured) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), respCacheUseDefineConsistentHash$str(), cacheName, configured));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorOnParsingPrometheusURLForTracing$str() {
        return "ISPN000967: Cannot parse Prometheus URL for tracing.'";
    }
    @Override
    public final CacheConfigurationException errorOnParsingPrometheusURLForTracing(final Throwable t) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), errorOnParsingPrometheusURLForTracing$str()), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void failedToCreateInitialCtx(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, failedToCreateInitialCtx$str());
    }
    protected String failedToCreateInitialCtx$str() {
        return "ISPN000968: Failed creating initial JNDI context";
    }
    protected String certificateReloadError$str() {
        return "ISPN000970: Error while reloading certificate";
    }
    @Override
    public final RuntimeException certificateReloadError(final Exception ex) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), certificateReloadError$str()), ex);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String counterOurOfBounds$str() {
        return "ISPN029501: %s reached.";
    }
    @Override
    public final CounterOutOfBoundsException counterOurOfBounds(final String bound) {
        final CounterOutOfBoundsException result = new CounterOutOfBoundsException(String.format(getLoggingLocale(), counterOurOfBounds$str(), bound));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidCounterType$str() {
        return "ISPN029514: Invalid counter type. Expected=%s but got %s";
    }
    @Override
    public final CounterException invalidCounterType(final String expected, final String actual) {
        final CounterException result = new CounterException(String.format(getLoggingLocale(), invalidCounterType$str(), expected, actual));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String undefinedCounter$str() {
        return "ISPN029516: Counter '%s' is not defined.";
    }
    @Override
    public final CounterException undefinedCounter(final String name) {
        final CounterException result = new CounterException(String.format(getLoggingLocale(), undefinedCounter$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidCounterTypeEncoded$str() {
        return "ISPN029522: WEAK and BOUNDED encoded flag isn't supported!";
    }
    @Override
    public final CounterException invalidCounterTypeEncoded() {
        final CounterException result = new CounterException(String.format(getLoggingLocale(), invalidCounterTypeEncoded$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void taskProgression(final String name, final long pending, final long lastCheck, final String status) {
        super.log.logf(FQCN, INFO, null, taskProgression$str(), name, pending, lastCheck, status);
    }
    protected String taskProgression$str() {
        return "ISPN000972: Task '%s', pending (%d), last check had (%d) pending, status is %s";
    }
    @Override
    public final void taskDone(final String name, final Instant started, final Instant completed) {
        super.log.logf(FQCN, INFO, null, taskDone$str(), name, started, completed);
    }
    protected String taskDone$str() {
        return "ISPN000973: Task '%s' started at %s and done %s";
    }
    protected String cannotInstantiateClass$str() {
        return "ISPN029523: Cannot instantiate class '%s'";
    }
    @Override
    public final CacheConfigurationException cannotInstantiateClass(final String classname, final Throwable t) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), cannotInstantiateClass$str(), classname));
        _copyStackTraceMinusOne(result);
        result.addSuppressed(t);
        return result;
    }
}
