/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.infinispan.commons.logging.Log;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.Storage;

public final class CounterEncodeUtil {
    private static final byte WEAK_COUNTER = 1;
    private static final byte BOUNDED_COUNTER = 2;
    private static final byte UNBOUNDED_COUNTER = 0;

    private CounterEncodeUtil() {
    }

    public static Storage decodeStorage(byte flags) {
        return (flags & 4) == 0 ? Storage.VOLATILE : Storage.PERSISTENT;
    }

    public static CounterType decodeType(byte flags) {
        switch (flags & 3) {
            case 1: {
                return CounterType.WEAK;
            }
            case 2: {
                return CounterType.BOUNDED_STRONG;
            }
            case 0: {
                return CounterType.UNBOUNDED_STRONG;
            }
        }
        throw Log.CONTAINER.invalidCounterTypeEncoded();
    }

    private static byte encodeStorage(Storage storage) {
        switch (storage) {
            case VOLATILE: {
                return 0;
            }
            case PERSISTENT: {
                return 4;
            }
        }
        throw new IllegalStateException("Unknown storage mode: " + String.valueOf((Object)storage));
    }

    private static byte encodeType(CounterType type) {
        switch (type) {
            case UNBOUNDED_STRONG: {
                return 0;
            }
            case BOUNDED_STRONG: {
                return 2;
            }
            case WEAK: {
                return 1;
            }
        }
        throw new IllegalStateException();
    }

    public static byte encodeTypeAndStorage(CounterConfiguration configuration) {
        return (byte)(CounterEncodeUtil.encodeType(configuration.type()) | CounterEncodeUtil.encodeStorage(configuration.storage()));
    }

    public static void encodeConfiguration(CounterConfiguration configuration, Consumer<Byte> byteConsumer, LongConsumer longConsumer, IntConsumer intConsumer) {
        byteConsumer.accept(CounterEncodeUtil.encodeTypeAndStorage(configuration));
        switch (configuration.type()) {
            case WEAK: {
                intConsumer.accept(configuration.concurrencyLevel());
                break;
            }
            case BOUNDED_STRONG: {
                longConsumer.accept(configuration.lowerBound());
                longConsumer.accept(configuration.upperBound());
                break;
            }
            case UNBOUNDED_STRONG: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        longConsumer.accept(configuration.initialValue());
    }

    public static CounterConfiguration decodeConfiguration(Supplier<Byte> byteSupplier, LongSupplier longSupplier, IntSupplier intSupplier) {
        byte flags = byteSupplier.get();
        CounterType type = CounterEncodeUtil.decodeType(flags);
        CounterConfiguration.Builder builder = CounterConfiguration.builder(type);
        builder.storage(CounterEncodeUtil.decodeStorage(flags));
        switch (type) {
            case WEAK: {
                builder.concurrencyLevel(intSupplier.getAsInt());
                break;
            }
            case BOUNDED_STRONG: {
                builder.lowerBound(longSupplier.getAsLong());
                builder.upperBound(longSupplier.getAsLong());
                break;
            }
        }
        builder.initialValue(longSupplier.getAsLong());
        return builder.build();
    }
}

