/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.api.query.impl;

import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.api.query.Query;
import org.infinispan.commons.api.query.QueryResult;
import org.infinispan.commons.reactive.AbstractAsyncPublisherHandler;

public class QuerySubscription<E>
extends AbstractAsyncPublisherHandler<Query<E>, E, QueryResult<E>, QueryResult<E>> {
    private final long initialOffset;
    private final int maxResults;
    private long currentOffset;

    protected QuerySubscription(int maxBatchSize, Query<E> query) {
        super(maxBatchSize, () -> null, query);
        this.initialOffset = query.getStartOffset();
        this.currentOffset = query.getStartOffset();
        this.maxResults = query.getMaxResults();
    }

    @Override
    protected void sendCancel(Query<E> es) {
    }

    @Override
    protected CompletionStage<QueryResult<E>> sendInitialCommand(Query<E> es, int batchSize) {
        return es.maxResults(this.maxResults > 0 ? Math.min(batchSize, this.maxResults) : batchSize).executeAsync();
    }

    @Override
    protected CompletionStage<QueryResult<E>> sendNextCommand(Query<E> es, int batchSize) {
        int remaining;
        if (this.maxResults > 0 && (remaining = this.maxResults - (int)(this.currentOffset - this.initialOffset)) < batchSize) {
            es = es.maxResults(remaining);
        }
        return es.startOffset(this.currentOffset).executeAsync();
    }

    @Override
    protected long handleInitialResponse(QueryResult<E> eQueryResult, Query<E> es) {
        List<E> batchResult = eQueryResult.list();
        int resultSize = batchResult.size();
        if ((this.currentOffset += (long)resultSize) - this.initialOffset == (long)this.maxResults || resultSize < this.batchSize) {
            es.startOffset(this.initialOffset);
            es.maxResults(this.maxResults);
            this.targetComplete();
        }
        for (E result : batchResult) {
            if (!this.onNext(result)) break;
        }
        return resultSize;
    }

    @Override
    protected long handleNextResponse(QueryResult<E> eQueryResult, Query<E> es) {
        return this.handleInitialResponse(eQueryResult, es);
    }
}

