/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.jdkspecific;

import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.infinispan.commons.spi.OffHeapMemory;

class UnsafeMemoryAddressOffHeapMemory
implements OffHeapMemory {
    private static final Logger log = Logger.getLogger(MethodHandles.lookup().lookupClass().getName());
    private final ConcurrentMap<Long, Long> allocatedBlocks = UnsafeMemoryAddressOffHeapMemory.isFinerEnabled() ? new ConcurrentHashMap() : null;
    static final UnsafeMemoryAddressOffHeapMemory INSTANCE = new UnsafeMemoryAddressOffHeapMemory();
    static final MemorySegment memorySegment = MemorySegment.ofAddress(0L).reinterpret(Long.MAX_VALUE);
    static final MethodHandle allocator;
    static final MethodHandle deallocator;

    public static OffHeapMemory getInstance() {
        return INSTANCE;
    }

    private UnsafeMemoryAddressOffHeapMemory() {
    }

    private static boolean isFinerEnabled() {
        return log.isLoggable(Level.FINER);
    }

    @Override
    public byte getByte(long srcAddress, long offset) {
        this.checkAddress(srcAddress, offset + 1L);
        byte value = memorySegment.get(ValueLayout.JAVA_BYTE, srcAddress + offset);
        if (UnsafeMemoryAddressOffHeapMemory.isFinerEnabled()) {
            log.finer("Read byte value 0x%02x from address 0x%016x+%d".formatted(value, srcAddress, offset));
        }
        return value;
    }

    @Override
    public void putByte(long destAddress, long offset, byte value) {
        this.checkAddress(destAddress, offset + 1L);
        if (UnsafeMemoryAddressOffHeapMemory.isFinerEnabled()) {
            log.finer("Wrote byte value 0x%02x to address 0x%016x+%d".formatted(value, destAddress, offset));
        }
        memorySegment.set(ValueLayout.JAVA_BYTE, destAddress + offset, value);
    }

    @Override
    public int getInt(long srcAddress, long offset) {
        this.checkAddress(srcAddress, offset + 4L);
        int value = memorySegment.get(ValueLayout.JAVA_INT_UNALIGNED, srcAddress + offset);
        if (UnsafeMemoryAddressOffHeapMemory.isFinerEnabled()) {
            log.finer("Read int value 0x%08x from address 0x%016x+%d".formatted(value, srcAddress, offset));
        }
        return value;
    }

    @Override
    public void putInt(long destAddress, long offset, int value) {
        this.checkAddress(destAddress, offset + 4L);
        if (UnsafeMemoryAddressOffHeapMemory.isFinerEnabled()) {
            log.finer("Wrote int value 0x%08x to address 0x%016x+%d".formatted(value, destAddress, offset));
        }
        memorySegment.set(ValueLayout.JAVA_INT_UNALIGNED, destAddress + offset, value);
    }

    @Override
    public long getLong(long srcAddress, long offset) {
        return this.getLong(srcAddress, offset, true);
    }

    @Override
    public long getAndSetLong(long destAddress, long offset, long value) {
        this.checkAddress(destAddress, offset + 8L);
        if (UnsafeMemoryAddressOffHeapMemory.isFinerEnabled()) {
            log.finer("Get and setting long value 0x%016x to address 0x%016x+%d".formatted(value, destAddress, offset));
        }
        return ValueLayout.JAVA_LONG.varHandle().getAndSet(memorySegment, destAddress + offset, value);
    }

    @Override
    public long getAndSetLongNoTraceIfAbsent(long destAddress, long offset, long value) {
        this.checkAddress(destAddress, offset + 8L);
        long previous = ValueLayout.JAVA_LONG.varHandle().getAndSet(memorySegment, destAddress + offset, value);
        if (previous != 0L && UnsafeMemoryAddressOffHeapMemory.isFinerEnabled()) {
            log.finer("Get and set long value 0x%016x to address 0x%016x+%d was 0x%016x".formatted(value, destAddress, offset, previous));
        }
        return previous;
    }

    @Override
    public long getLongNoTraceIfAbsent(long srcAddress, long offset) {
        return this.getLong(srcAddress, offset, false);
    }

    private long getLong(long srcAddress, long offset, boolean alwaysTrace) {
        this.checkAddress(srcAddress, offset + 8L);
        long value = memorySegment.get(ValueLayout.JAVA_LONG_UNALIGNED, srcAddress + offset);
        if (UnsafeMemoryAddressOffHeapMemory.isFinerEnabled() && (alwaysTrace || value != 0L)) {
            log.finer("Read long value 0x%016x from address 0x%016x+%d".formatted(value, srcAddress, offset));
        }
        return value;
    }

    @Override
    public void putLong(long destAddress, long offset, long value) {
        this.checkAddress(destAddress, offset + 8L);
        if (UnsafeMemoryAddressOffHeapMemory.isFinerEnabled()) {
            log.finer("Wrote long value 0x%016x to address 0x%016x+%d".formatted(value, destAddress, offset));
        }
        memorySegment.set(ValueLayout.JAVA_LONG_UNALIGNED, destAddress + offset, value);
    }

    @Override
    public void getBytes(long srcAddress, long srcOffset, byte[] destArray, long destOffset, long length) {
        this.checkAddress(srcAddress, srcOffset + length);
        if (UnsafeMemoryAddressOffHeapMemory.isFinerEnabled()) {
            log.finer("Read %d bytes from address 0x%016x+%d into array %s+%d".formatted(length, srcAddress, srcOffset, destArray, destOffset));
        }
        MemorySegment.copy(memorySegment, srcAddress + srcOffset, MemorySegment.ofArray(destArray), destOffset, length);
    }

    @Override
    public void putBytes(byte[] srcArray, long srcOffset, long destAddress, long destOffset, long length) {
        this.checkAddress(destAddress, destOffset + length);
        if (UnsafeMemoryAddressOffHeapMemory.isFinerEnabled()) {
            log.finer("Wrote %d bytes from array %s+%d to address 0x%016x+%d".formatted(length, srcArray, srcOffset, destAddress, destOffset));
        }
        MemorySegment.copy(MemorySegment.ofArray(srcArray), srcOffset, memorySegment, destAddress + destOffset, length);
    }

    @Override
    public void copy(long srcAddress, long srcOffset, long destAddress, long destOffset, long length) {
        this.checkAddress(srcAddress, srcOffset + length);
        this.checkAddress(destAddress, destOffset + length);
        if (UnsafeMemoryAddressOffHeapMemory.isFinerEnabled()) {
            log.finer("Copying %d bytes from address 0x%016x+%d to address 0x%016x+%d".formatted(length, srcAddress, srcOffset, destAddress, destOffset));
        }
        MemorySegment.copy(memorySegment, srcAddress + srcOffset, memorySegment, destAddress + destOffset, length);
    }

    private void checkAddress(long address, long offset) {
        if (!UnsafeMemoryAddressOffHeapMemory.isFinerEnabled()) {
            return;
        }
        Long blockSize = (Long)this.allocatedBlocks.get(address);
        if (blockSize == null || blockSize < offset) {
            throw new IllegalArgumentException(String.format("Trying to access address 0x%016x+%d, but blockSize was %d", address, offset, blockSize));
        }
    }

    @Override
    public long allocate(long size) {
        Long prev;
        long address;
        try {
            address = allocator.invokeExact(size);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        if (UnsafeMemoryAddressOffHeapMemory.isFinerEnabled() && (prev = this.allocatedBlocks.put(address, size)) != null) {
            throw new IllegalArgumentException();
        }
        return address;
    }

    @Override
    public void free(long address) {
        Long prev;
        if (UnsafeMemoryAddressOffHeapMemory.isFinerEnabled() && (prev = (Long)this.allocatedBlocks.remove(address)) == null) {
            throw new IllegalArgumentException();
        }
        try {
            deallocator.invokeExact(address);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setMemory(long address, long bytes, byte value) {
        MemorySegment.ofAddress(address).reinterpret(bytes).fill(value);
    }

    static {
        Linker linker = Linker.nativeLinker();
        String allocatorName = System.getProperty("infinispan.off_heap.allocator", "malloc");
        MemorySegment malloc_addr = linker.defaultLookup().find(allocatorName).orElseThrow();
        allocator = linker.downcallHandle(malloc_addr, FunctionDescriptor.of(ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG), new Linker.Option[0]);
        String deallocatorName = System.getProperty("infinispan.off_heap.deallocator", "free");
        MemorySegment free_addr = linker.defaultLookup().find(deallocatorName).orElseThrow();
        deallocator = linker.downcallHandle(free_addr, FunctionDescriptor.ofVoid(ValueLayout.JAVA_LONG), new Linker.Option[0]);
    }
}

