/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.commons.util.TimeQuantity;

public class TypedProperties
extends Properties {
    private static final long serialVersionUID = 3799321248100686287L;
    private static final Log log = LogFactory.getLog(TypedProperties.class);

    public TypedProperties(Map<?, ?> p) {
        if (p != null && !p.isEmpty()) {
            super.putAll(p);
        }
    }

    public TypedProperties() {
    }

    public static TypedProperties toTypedProperties(Map<?, ?> p) {
        if (p instanceof TypedProperties) {
            return (TypedProperties)p;
        }
        return new TypedProperties(p);
    }

    public int getIntProperty(String key, int defaultValue) {
        return this.getIntProperty(key, defaultValue, false);
    }

    public int getIntProperty(String key, int defaultValue, boolean doStringReplace) {
        Object value = this.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return this.getPropertyFn(value, defaultValue, doStringReplace, valueStr -> {
            try {
                return Integer.parseInt(valueStr);
            }
            catch (NumberFormatException nfe) {
                log.unableToConvertStringPropertyToInt((String)valueStr, defaultValue);
                return defaultValue;
            }
        });
    }

    public long getLongProperty(String key, long defaultValue) {
        return this.getLongProperty(key, defaultValue, false);
    }

    public long getLongProperty(String key, long defaultValue, boolean doStringReplace) {
        Object value = this.get(key);
        if (value instanceof Long) {
            return (Long)value;
        }
        return this.getPropertyFn(value, defaultValue, doStringReplace, valueStr -> {
            try {
                return Long.parseLong(valueStr);
            }
            catch (NumberFormatException nfe) {
                log.unableToConvertStringPropertyToLong((String)valueStr, defaultValue);
                return defaultValue;
            }
        });
    }

    public long getDurationProperty(String key, long defaultValue) {
        return this.getDurationProperty(key, defaultValue, false);
    }

    public long getDurationProperty(String key, long defaultValue, boolean doStringReplace) {
        Object value = this.get(key);
        if (value instanceof Long) {
            return (Long)value;
        }
        return this.getPropertyFn(value, defaultValue, doStringReplace, valueStr -> {
            try {
                return TimeQuantity.valueOf(valueStr).longValue();
            }
            catch (NumberFormatException nfe) {
                log.unableToConvertStringPropertyToLong((String)valueStr, defaultValue);
                return defaultValue;
            }
        });
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        return this.getBooleanProperty(key, defaultValue, false);
    }

    public boolean getBooleanProperty(String key, boolean defaultValue, boolean doStringReplace) {
        Object value = this.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return this.getPropertyFn(value, defaultValue, doStringReplace, valueStr -> {
            try {
                return Boolean.parseBoolean(valueStr);
            }
            catch (Exception e) {
                log.unableToConvertStringPropertyToBoolean((String)valueStr, defaultValue);
                return defaultValue;
            }
        });
    }

    public <T extends Enum<T>> T getEnumProperty(String key, Class<T> enumClass, T defaultValue) {
        return this.getEnumProperty(key, enumClass, defaultValue, false);
    }

    public <T extends Enum<T>> T getEnumProperty(String key, Class<T> enumClass, T defaultValue, boolean doStringReplace) {
        Object value = this.get(key);
        if (value instanceof Enum && enumClass.isInstance(value)) {
            return (T)((Enum)value);
        }
        return (T)this.getPropertyFn(value, defaultValue, doStringReplace, valueStr -> {
            try {
                return Enum.valueOf(enumClass, valueStr);
            }
            catch (IllegalArgumentException e) {
                log.unableToConvertStringPropertyToEnum((String)valueStr, defaultValue.name());
                return defaultValue;
            }
        });
    }

    public synchronized String getProperty(String key, String defaultValue, boolean doStringReplace) {
        if (doStringReplace) {
            return StringPropertyReplacer.replaceProperties(this.getProperty(key, defaultValue));
        }
        return this.getProperty(key, defaultValue);
    }

    public synchronized String getProperty(String key, boolean doStringReplace) {
        if (doStringReplace) {
            return StringPropertyReplacer.replaceProperties(this.getProperty(key));
        }
        return this.getProperty(key);
    }

    @Override
    public synchronized TypedProperties putIfAbsent(String key, String value) {
        if (this.getProperty(key) == null) {
            this.put(key, value);
        }
        return this;
    }

    @Override
    public synchronized TypedProperties setProperty(String key, String value) {
        super.setProperty(key, value);
        return this;
    }

    public synchronized TypedProperties setProperty(String key, int value) {
        super.setProperty(key, Integer.toString(value));
        return this;
    }

    public synchronized TypedProperties setProperty(String key, long value) {
        super.setProperty(key, Long.toString(value));
        return this;
    }

    public synchronized TypedProperties setProperty(String key, boolean value) {
        super.setProperty(key, Boolean.toString(value));
        return this;
    }

    private <V> V getPropertyFn(Object value, V defaultValue, boolean doStringReplace, Function<String, V> action) {
        String valueStr = null;
        if (value instanceof String) {
            valueStr = (String)value;
        }
        if (valueStr == null) {
            return defaultValue;
        }
        if ((valueStr = valueStr.trim()).isEmpty()) {
            return defaultValue;
        }
        if (doStringReplace) {
            valueStr = StringPropertyReplacer.replaceProperties(valueStr);
        }
        return action.apply(valueStr);
    }
}

