/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util.concurrent;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.infinispan.commons.util.concurrent.CompositeNotifyingFuture;
import org.infinispan.commons.util.concurrent.FutureListener;
import org.infinispan.commons.util.concurrent.NoOpFuture;
import org.infinispan.commons.util.concurrent.NotifyingFuture;
import org.infinispan.commons.util.concurrent.NotifyingFutureImpl;

public final class Futures {
    private Futures() {
    }

    public static <T> NotifyingFuture<List<T>> combine(List<NotifyingFuture<T>> futures) {
        if (futures == null || futures.isEmpty()) {
            return new NoOpFuture<Object>(null);
        }
        return new CompositeNotifyingFuture<T>(futures);
    }

    public static <T> NotifyingFuture<Void> andThen(NotifyingFuture<T> future, Runnable after) {
        return Futures.andThen(future, after, Executors.newSingleThreadExecutor());
    }

    public static <T> NotifyingFuture<Void> andThen(final NotifyingFuture<T> future, final Runnable after, ExecutorService executorService) {
        final NotifyingFutureImpl<Void> result = new NotifyingFutureImpl<Void>();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        Future<?> afterFuture = executorService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    countDownLatch.await();
                    future.get();
                    after.run();
                    result.notifyDone(null);
                }
                catch (InterruptedException e) {
                    future.cancel(true);
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    result.notifyException(e);
                }
            }
        });
        result.setFuture(afterFuture);
        FutureListener listener = new FutureListener<T>(){

            @Override
            public void futureDone(Future<T> future) {
                countDownLatch.countDown();
            }
        };
        future.attachListener(listener);
        return result;
    }
}

