/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.counter.impl;

import java.util.Objects;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.SyncWeakCounter;
import org.infinispan.counter.api.WeakCounter;
import org.infinispan.counter.impl.Util;

public class SyncWeakCounterAdapter
implements SyncWeakCounter {
    private final WeakCounter counter;

    public SyncWeakCounterAdapter(WeakCounter counter) {
        this.counter = Objects.requireNonNull(counter);
    }

    @Override
    public String getName() {
        return this.counter.getName();
    }

    @Override
    public long getValue() {
        return this.counter.getValue();
    }

    @Override
    public void add(long delta) {
        Util.awaitCounterOperation(this.counter.add(delta));
    }

    @Override
    public void reset() {
        Util.awaitCounterOperation(this.counter.reset());
    }

    @Override
    public CounterConfiguration getConfiguration() {
        return this.counter.getConfiguration();
    }

    @Override
    public void remove() {
        Util.awaitCounterOperation(this.counter.remove());
    }

    public String toString() {
        return "SyncWeakCounter{counter=" + this.counter + '}';
    }
}

