/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.distribution.L1NonTxInterceptor;

public class L1TxInterceptor
extends L1NonTxInterceptor {
    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.performCommandWithL1WriteIfAble(ctx, command, false, true, true);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.performCommandWithL1WriteIfAble(ctx, command, false, true, true);
    }

    @Override
    public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) throws Throwable {
        return this.performCommandWithL1WriteIfAble(ctx, command, false, true, false);
    }

    @Override
    public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) throws Throwable {
        return this.performCommandWithL1WriteIfAble(ctx, command, false, true, false);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.performCommandWithL1WriteIfAble(ctx, command, false, true, false);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (command.isOnePhaseCommit() && this.shouldFlushL1(ctx)) {
            return this.flushL1CachesAndInvokeNext(ctx, command);
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (this.shouldFlushL1(ctx)) {
            return this.flushL1CachesAndInvokeNext(ctx, command);
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    protected boolean skipL1Lookup(FlagAffectedCommand command, Object key) {
        return super.skipL1Lookup(command, key);
    }

    private boolean shouldFlushL1(TxInvocationContext ctx) {
        return !ctx.getAffectedKeys().isEmpty();
    }

    private Object flushL1CachesAndInvokeNext(TxInvocationContext ctx, VisitableCommand command) {
        CompletableFuture<?> f = this.l1Manager.flushCache(ctx.getAffectedKeys(), ctx.getOrigin(), true);
        if (f != null && !f.isDone()) {
            return this.asyncInvokeNext((InvocationContext)ctx, command, f.exceptionally(throwable -> {
                this.getLog().failedInvalidatingRemoteCache((Throwable)throwable);
                throw CompletableFutures.asCompletionException((Throwable)throwable);
            }));
        }
        return this.invokeNext(ctx, command);
    }
}

