/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.AbstractIndexingConfigurationChildBuilder;
import org.infinispan.configuration.cache.IndexMergeConfigurationBuilder;
import org.infinispan.configuration.cache.IndexWriterConfiguration;
import org.infinispan.configuration.cache.IndexingConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;

public class IndexWriterConfigurationBuilder
extends AbstractIndexingConfigurationChildBuilder
implements Builder<IndexWriterConfiguration>,
ConfigurationBuilderInfo {
    private static final String BACKEND_PREFIX = "hibernate.search.backend.";
    private static final String QUEUE_COUNT_KEY = "hibernate.search.backend.indexing.queue_count";
    private static final String QUEUE_SIZE_KEY = "hibernate.search.backend.indexing.queue_size";
    private static final String THREAD_POOL_KEY = "hibernate.search.backend.thread_pool.size";
    private static final String IO_PREFIX = "hibernate.search.backend.io.";
    private static final String COMMIT_INTERVAL_KEY = "hibernate.search.backend.io.commit_interval";
    private static final String RAM_BUFFER_KEY = "hibernate.search.backend.io.writer.ram_buffer_size";
    private static final String MAX_BUFFER_DOCS_KEY = "hibernate.search.backend.io.writer.max_buffered_docs";
    private static final String LOW_LEVEL_TRACE_KEY = "hibernate.search.backend.io.writer.infostream";
    private final AttributeSet attributes = IndexWriterConfiguration.attributeDefinitionSet();
    private final IndexMergeConfigurationBuilder indexMergeConfigurationBuilder;
    private final Attribute<Integer> commitInterval;
    private final Attribute<Integer> threadPoolSize = this.attributes.attribute(IndexWriterConfiguration.INDEX_THREAD_POOL_SIZE);
    private final Attribute<Integer> queueCount = this.attributes.attribute(IndexWriterConfiguration.INDEX_QUEUE_COUNT);
    private final Attribute<Integer> queueSize = this.attributes.attribute(IndexWriterConfiguration.INDEX_QUEUE_SIZE);
    private final Attribute<Integer> ramBufferSize;
    private final Attribute<Integer> maxBufferedDocs;
    private final Attribute<Boolean> lowLevelTrace;
    private final List<ConfigurationBuilderInfo> subElements;

    IndexWriterConfigurationBuilder(IndexingConfigurationBuilder builder) {
        super(builder);
        this.commitInterval = this.attributes.attribute(IndexWriterConfiguration.INDEX_COMMIT_INTERVAL);
        this.ramBufferSize = this.attributes.attribute(IndexWriterConfiguration.INDEX_RAM_BUFFER_SIZE);
        this.maxBufferedDocs = this.attributes.attribute(IndexWriterConfiguration.INDEX_MAX_BUFFERED_DOCS);
        this.lowLevelTrace = this.attributes.attribute(IndexWriterConfiguration.INDEX_LOW_LEVEL_TRACE);
        this.indexMergeConfigurationBuilder = new IndexMergeConfigurationBuilder(builder);
        this.subElements = Collections.singletonList(this.indexMergeConfigurationBuilder);
    }

    public Collection<ConfigurationBuilderInfo> getChildrenInfo() {
        return this.subElements;
    }

    Map<String, Object> asInternalProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (!this.commitInterval.isNull()) {
            props.put(COMMIT_INTERVAL_KEY, this.commitInterval());
        }
        if (!this.threadPoolSize.isNull()) {
            props.put(THREAD_POOL_KEY, this.threadPoolSize());
        }
        if (!this.queueCount.isNull()) {
            props.put(QUEUE_COUNT_KEY, this.queueCount());
        }
        if (!this.queueSize.isNull()) {
            props.put(QUEUE_SIZE_KEY, this.queueSize());
        }
        if (!this.ramBufferSize.isNull()) {
            props.put(RAM_BUFFER_KEY, this.ramBufferSize());
        }
        if (!this.maxBufferedDocs.isNull()) {
            props.put(MAX_BUFFER_DOCS_KEY, this.maxBufferedDocs());
        }
        if (this.lowLevelTrace.isModified()) {
            props.put(LOW_LEVEL_TRACE_KEY, this.isLowLevelTrace());
        }
        props.putAll(this.indexMergeConfigurationBuilder.asInternalProperties());
        return props;
    }

    public IndexMergeConfigurationBuilder merge() {
        return this.indexMergeConfigurationBuilder;
    }

    public int threadPoolSize() {
        return (Integer)this.threadPoolSize.get();
    }

    public IndexWriterConfigurationBuilder threadPoolSize(int value) {
        this.threadPoolSize.set((Object)value);
        return this;
    }

    public int queueCount() {
        return (Integer)this.queueCount.get();
    }

    public IndexWriterConfigurationBuilder queueCount(int value) {
        this.queueCount.set((Object)value);
        return this;
    }

    public int queueSize() {
        return (Integer)this.queueSize.get();
    }

    public IndexWriterConfigurationBuilder queueSize(int value) {
        this.queueSize.set((Object)value);
        return this;
    }

    public int commitInterval() {
        return (Integer)this.commitInterval.get();
    }

    public IndexWriterConfigurationBuilder commitInterval(int value) {
        this.commitInterval.set((Object)value);
        return this;
    }

    public int ramBufferSize() {
        return (Integer)this.ramBufferSize.get();
    }

    public IndexWriterConfigurationBuilder ramBufferSize(int value) {
        this.ramBufferSize.set((Object)value);
        return this;
    }

    public int maxBufferedDocs() {
        return (Integer)this.maxBufferedDocs.get();
    }

    public IndexWriterConfigurationBuilder maxBufferedDocs(int value) {
        this.maxBufferedDocs.set((Object)value);
        return this;
    }

    public boolean isLowLevelTrace() {
        return (Boolean)this.lowLevelTrace.get();
    }

    public IndexWriterConfigurationBuilder setLowLevelTrace(boolean value) {
        this.lowLevelTrace.set((Object)value);
        return this;
    }

    public ElementDefinition<IndexWriterConfiguration> getElementDefinition() {
        return IndexWriterConfiguration.ELEMENT_DEFINITION;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public IndexWriterConfiguration create() {
        return new IndexWriterConfiguration(this.attributes.protect(), this.indexMergeConfigurationBuilder.create());
    }

    public IndexWriterConfigurationBuilder read(IndexWriterConfiguration template) {
        this.attributes.read(template.attributes());
        this.indexMergeConfigurationBuilder.read(template.merge());
        return this;
    }

    public String toString() {
        return "IndexWriterConfigurationBuilder{attributes=" + this.attributes + ", indexMergeConfigurationBuilder=" + this.indexMergeConfigurationBuilder + '}';
    }

    public void validate() {
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }
}

