/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.NamespaceMappingParser;
import org.infinispan.configuration.parsing.ParserContext;
import org.infinispan.configuration.parsing.Schema;
import org.infinispan.configuration.parsing.SecurityActions;
import org.infinispan.configuration.parsing.URLXMLResourceResolver;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.configuration.parsing.XMLExtendedStreamReaderImpl;
import org.infinispan.configuration.parsing.XMLResourceResolver;
import org.infinispan.configuration.serializing.ConfigurationHolder;
import org.infinispan.configuration.serializing.Serializer;
import org.infinispan.configuration.serializing.XMLExtendedStreamWriter;
import org.infinispan.configuration.serializing.XMLExtendedStreamWriterImpl;
import org.infinispan.util.logging.Log;

public class ParserRegistry
implements NamespaceMappingParser {
    private final WeakReference<ClassLoader> cl;
    private final ConcurrentMap<QName, NamespaceParserPair> parserMappings = new ConcurrentHashMap<QName, NamespaceParserPair>();
    private final Properties properties;

    public ParserRegistry() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ParserRegistry(ClassLoader classLoader) {
        this(classLoader, false, SecurityActions.getSystemProperties());
    }

    public ParserRegistry(ClassLoader classLoader, boolean defaultOnly, Properties properties) {
        this.cl = new WeakReference<ClassLoader>(classLoader);
        this.properties = properties;
        Collection parsers = ServiceFinder.load(ConfigurationParser.class, (ClassLoader[])new ClassLoader[]{(ClassLoader)this.cl.get(), ParserRegistry.class.getClassLoader()});
        for (ConfigurationParser parser : parsers) {
            Namespace[] namespaces = parser.getNamespaces();
            if (namespaces == null) {
                throw Log.CONFIG.parserDoesNotDeclareNamespaces(parser.getClass().getName());
            }
            boolean skipParser = defaultOnly;
            if (skipParser) {
                for (Namespace ns : namespaces) {
                    if (!"".equals(ns.uri())) continue;
                    skipParser = false;
                }
            }
            if (skipParser) continue;
            for (Namespace ns : namespaces) {
                QName qName = new QName(ns.uri(), ns.root());
                NamespaceParserPair existing = this.parserMappings.putIfAbsent(qName, new NamespaceParserPair(ns, parser));
                if (existing == null || parser.getClass().equals(existing.parser.getClass())) continue;
                Log.CONFIG.parserRootElementAlreadyRegistered(qName, parser.getClass().getName(), existing.parser.getClass().getName());
            }
        }
    }

    public ConfigurationBuilderHolder parse(URL url) throws IOException {
        try (InputStream is = url.openStream();){
            ConfigurationBuilderHolder configurationBuilderHolder = this.parse(is, new URLXMLResourceResolver(url));
            return configurationBuilderHolder;
        }
    }

    public ConfigurationBuilderHolder parseFile(String filename) throws IOException {
        FileLookup fileLookup = FileLookupFactory.newInstance();
        URL url = fileLookup.lookupFileLocation(filename, (ClassLoader)this.cl.get());
        if (url == null) {
            throw new FileNotFoundException(filename);
        }
        try (InputStream is = url.openStream();){
            ConfigurationBuilderHolder configurationBuilderHolder = this.parse(is, new URLXMLResourceResolver(url));
            return configurationBuilderHolder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationBuilderHolder parseFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        if (is == null) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        try {
            ConfigurationBuilderHolder configurationBuilderHolder = this.parse(is, new URLXMLResourceResolver(file.toURI().toURL()));
            return configurationBuilderHolder;
        }
        finally {
            Util.close((AutoCloseable)is);
        }
    }

    public ConfigurationBuilderHolder parse(String s) {
        return this.parse(new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8)), null);
    }

    public ConfigurationBuilderHolder parse(InputStream is, XMLResourceResolver resourceResolver) {
        try {
            ConfigurationBuilderHolder holder = new ConfigurationBuilderHolder((ClassLoader)this.cl.get());
            this.parse(is, holder, resourceResolver);
            holder.validate();
            return holder;
        }
        catch (CacheConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheConfigurationException(e);
        }
    }

    private void setIfSupported(XMLInputFactory inputFactory, String property, Object value) {
        if (inputFactory.isPropertySupported(property)) {
            inputFactory.setProperty(property, value);
        }
    }

    public ConfigurationBuilderHolder parse(URL url, ConfigurationBuilderHolder holder) throws IOException, XMLStreamException {
        try (InputStream is = url.openStream();){
            ConfigurationBuilderHolder configurationBuilderHolder = this.parse(is, holder, new URLXMLResourceResolver(url));
            return configurationBuilderHolder;
        }
    }

    public ConfigurationBuilderHolder parse(InputStream is, ConfigurationBuilderHolder holder, XMLResourceResolver resourceResolver) throws XMLStreamException {
        BufferedInputStream input = new BufferedInputStream(is);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        this.setIfSupported(factory, "javax.xml.stream.isValidating", Boolean.FALSE);
        this.setIfSupported(factory, "javax.xml.stream.supportDTD", Boolean.FALSE);
        XMLStreamReader subReader = factory.createXMLStreamReader(input);
        XMLExtendedStreamReaderImpl reader = new XMLExtendedStreamReaderImpl(factory, resourceResolver, this, subReader, this.properties);
        this.parse(reader, holder);
        subReader.close();
        for (ParserContext parserContext : holder.getParserContexts().values()) {
            parserContext.fireParsingComplete();
        }
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationBuilderHolder parse(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        try {
            reader.require(7, null, null);
            reader.nextTag();
            reader.require(1, null, null);
            this.parseElement(reader, holder);
            while (reader.next() != 8) {
            }
            ConfigurationBuilderHolder configurationBuilderHolder = holder;
            return configurationBuilderHolder;
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void parseElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        int lastColon;
        String uri;
        String baseUri;
        QName name = reader.getName();
        NamespaceParserPair parser = (NamespaceParserPair)this.parserMappings.get(name);
        if (!(parser != null || (parser = (NamespaceParserPair)this.parserMappings.get(new QName(baseUri = (uri = name.getNamespaceURI()).substring(0, (lastColon = uri.lastIndexOf(58)) + 1) + "*", name.getLocalPart()))) != null && this.isSupportedNamespaceVersion(parser.namespace, uri.substring(lastColon + 1)))) {
            throw Log.CONFIG.unsupportedConfiguration(name.getLocalPart(), name.getNamespaceURI(), Version.getVersion());
        }
        Schema oldSchema = reader.getSchema();
        reader.setSchema(Schema.fromNamespaceURI(name.getNamespaceURI()));
        parser.parser.readElement(reader, holder);
        reader.setSchema(oldSchema);
    }

    private boolean isSupportedNamespaceVersion(Namespace namespace, String version) {
        short reqVersion = Version.getVersionShort((String)version);
        if (reqVersion < Version.getVersionShort((String)namespace.since())) {
            return false;
        }
        short untilVersion = namespace.until().length() > 0 ? Version.getVersionShort((String)namespace.until()) : Version.getVersionShort();
        return reqVersion <= untilVersion;
    }

    public void serialize(OutputStream os, GlobalConfiguration globalConfiguration, Map<String, Configuration> configurations) throws XMLStreamException {
        BufferedOutputStream output = new BufferedOutputStream(os);
        XMLStreamWriter subWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(output);
        XMLExtendedStreamWriterImpl writer = new XMLExtendedStreamWriterImpl(subWriter);
        this.serialize(writer, globalConfiguration, configurations);
        subWriter.close();
    }

    public void serialize(XMLExtendedStreamWriter writer, GlobalConfiguration globalConfiguration, Map<String, Configuration> configurations) throws XMLStreamException {
        writer.writeStartDocument();
        writer.writeStartElement("infinispan");
        writer.writeDefaultNamespace("urn:infinispan:config:" + Version.getMajorMinor());
        Serializer serializer = new Serializer();
        serializer.serialize(writer, new ConfigurationHolder(globalConfiguration, configurations));
        writer.writeEndElement();
        writer.writeEndDocument();
    }

    public void serialize(OutputStream os, String name, Configuration configuration) throws XMLStreamException {
        this.serialize(os, null, Collections.singletonMap(name, configuration));
    }

    public String serialize(String name, Configuration configuration) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.serialize((OutputStream)os, name, configuration);
            return os.toString("UTF-8");
        }
        catch (Exception e) {
            throw new CacheConfigurationException(e);
        }
    }

    public static class NamespaceParserPair {
        Namespace namespace;
        ConfigurationParser parser;

        NamespaceParserPair(Namespace namespace, ConfigurationParser parser) {
            this.namespace = namespace;
            this.parser = parser;
        }
    }
}

