/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning.irac;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.irac.IracUpdateVersionCommand;
import org.infinispan.commons.util.Version;
import org.infinispan.container.versioning.irac.IracEntryVersion;
import org.infinispan.container.versioning.irac.IracVersionGenerator;
import org.infinispan.container.versioning.irac.TopologyIracVersion;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.globalstate.GlobalStateManager;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.globalstate.impl.ScopedPersistentStateImpl;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.topology.CacheTopology;

@Scope(value=Scopes.NAMED_CACHE)
public class DefaultIracVersionGenerator
implements IracVersionGenerator {
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("(\\d+)_(.*)$");
    private static final AtomicIntegerFieldUpdater<DefaultIracVersionGenerator> TOPOLOGY_UPDATED = AtomicIntegerFieldUpdater.newUpdater(DefaultIracVersionGenerator.class, "topologyId");
    private final Map<Integer, Map<String, TopologyIracVersion>> segmentVersion;
    private final Map<Object, IracMetadata> tombstone;
    private final String cacheName;
    @Inject
    RpcManager rpcManager;
    @Inject
    GlobalStateManager globalStateManager;
    @Inject
    CommandsFactory commandsFactory;
    private String localSite;
    private volatile int topologyId = 1;

    public DefaultIracVersionGenerator(String cacheName) {
        this.cacheName = cacheName;
        this.segmentVersion = new ConcurrentHashMap<Integer, Map<String, TopologyIracVersion>>();
        this.tombstone = new ConcurrentHashMap<Object, IracMetadata>();
    }

    @Start
    public void start() {
        this.rpcManager.getTransport().checkCrossSiteAvailable();
        this.localSite = this.rpcManager.getTransport().localSiteName();
        this.globalStateManager.readScopedState(this.scope()).ifPresent(this::loadState);
    }

    @Stop
    public void stop() {
        this.globalStateManager.writeScopedState(this.writeState());
    }

    @Override
    public IracMetadata generateNewMetadata(int segment) {
        return new IracMetadata(this.localSite, new IracEntryVersion(this.increment(segment)));
    }

    @Override
    public IracMetadata generateMetadataWithCurrentVersion(int segment) {
        Map v = this.segmentVersion.compute(segment, this::getVectorFunction);
        return new IracMetadata(this.localSite, new IracEntryVersion(v));
    }

    @Override
    public IracMetadata generateNewMetadata(int segment, IracEntryVersion versionSeen) {
        this.updateVersion(segment, versionSeen);
        return this.generateNewMetadata(segment);
    }

    @Override
    public void updateVersion(int segment, IracEntryVersion remoteVersion) {
        if (remoteVersion == null) {
            return;
        }
        this.segmentVersion.merge(segment, remoteVersion.toMap(), DefaultIracVersionGenerator::mergeVectorsFunction);
        int currentTopology = this.topologyId;
        int newTopology = remoteVersion.getTopology(this.localSite);
        while (newTopology > currentTopology && !TOPOLOGY_UPDATED.compareAndSet(this, currentTopology, newTopology)) {
            currentTopology = this.topologyId;
        }
    }

    @Override
    public void onTopologyChange(CacheTopology newTopology) {
        TOPOLOGY_UPDATED.incrementAndGet(this);
        if (newTopology.getPhase().isRebalance()) {
            IracUpdateVersionCommand cmd = this.commandsFactory.buildIracUpdateVersionCommand(this.peek());
            this.rpcManager.sendToAll(cmd, DeliverOrder.NONE);
        }
    }

    @Override
    public void storeTombstone(Object key, IracMetadata metadata) {
        this.tombstone.put(key, metadata);
    }

    @Override
    public void storeTombstoneIfAbsent(Object key, IracMetadata metadata) {
        if (metadata == null) {
            return;
        }
        this.tombstone.putIfAbsent(key, metadata);
    }

    @Override
    public IracMetadata getTombstone(Object key) {
        return this.tombstone.get(key);
    }

    @Override
    public void removeTombstone(Object key, IracMetadata iracMetadata) {
        if (iracMetadata == null) {
            return;
        }
        this.tombstone.remove(key, iracMetadata);
    }

    @Override
    public void removeTombstone(Object key) {
        this.tombstone.remove(key);
    }

    public Map<Integer, IracEntryVersion> peek() {
        HashMap<Integer, IracEntryVersion> copy = new HashMap<Integer, IracEntryVersion>();
        this.segmentVersion.forEach((seg, vector) -> copy.put((Integer)seg, new IracEntryVersion((Map<String, TopologyIracVersion>)vector)));
        return copy;
    }

    private Map<String, TopologyIracVersion> generateNewVectorFunction(Integer s, Map<String, TopologyIracVersion> versions) {
        if (versions == null) {
            return Collections.singletonMap(this.localSite, TopologyIracVersion.newVersion(this.topologyId));
        }
        HashMap<String, TopologyIracVersion> copy = new HashMap<String, TopologyIracVersion>(versions);
        copy.compute(this.localSite, this::incrementVersionFunction);
        return copy;
    }

    private Map<String, TopologyIracVersion> getVectorFunction(Integer s, Map<String, TopologyIracVersion> versions) {
        if (versions == null) {
            return Collections.singletonMap(this.localSite, TopologyIracVersion.newVersion(this.topologyId));
        }
        return versions;
    }

    private TopologyIracVersion incrementVersionFunction(String site, TopologyIracVersion version) {
        return version == null ? TopologyIracVersion.newVersion(this.topologyId) : version.increment(this.topologyId);
    }

    private static Map<String, TopologyIracVersion> mergeVectorsFunction(Map<String, TopologyIracVersion> v1, Map<String, TopologyIracVersion> v2) {
        if (v1 == null) {
            return v2;
        }
        HashMap<String, TopologyIracVersion> copy = new HashMap<String, TopologyIracVersion>(v1);
        for (Map.Entry<String, TopologyIracVersion> entry : v2.entrySet()) {
            copy.merge(entry.getKey(), entry.getValue(), TopologyIracVersion::max);
        }
        return copy;
    }

    private Map<String, TopologyIracVersion> increment(int segment) {
        Map result = this.segmentVersion.compute(segment, this::generateNewVectorFunction);
        return new HashMap<String, TopologyIracVersion>(result);
    }

    private String scope() {
        return "___irac_version_" + this.cacheName;
    }

    private void loadState(ScopedPersistentState state) {
        assert (Version.getVersion().equals(state.getProperty("@version")));
        state.forEach((segmentAndSite, versionString) -> {
            Matcher result = PROPERTY_PATTERN.matcher((CharSequence)segmentAndSite);
            if (!result.find()) {
                return;
            }
            int segment = Integer.parseInt(result.group(1));
            String site = result.group(2);
            TopologyIracVersion v = TopologyIracVersion.fromString(versionString);
            if (v == null) {
                return;
            }
            this.segmentVersion.compute(segment, (seg, vectorClock) -> {
                if (vectorClock == null) {
                    return Collections.singletonMap(site, v);
                }
                HashMap<String, TopologyIracVersion> copy = new HashMap<String, TopologyIracVersion>((Map<String, TopologyIracVersion>)vectorClock);
                copy.merge(site, v, TopologyIracVersion::max);
                return copy;
            });
        });
    }

    private ScopedPersistentState writeState() {
        ScopedPersistentStateImpl state = new ScopedPersistentStateImpl(this.scope());
        state.setProperty("@version", Version.getVersion());
        this.segmentVersion.forEach((segment, vector) -> vector.forEach((site, version) -> state.setProperty(Integer.toString(segment) + '_' + site, version.toString())));
        return state;
    }
}

