/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.persistence.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Date;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.marshall.BufferSizePredictor;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.SerializationConfiguration;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.marshall.persistence.PersistenceMarshaller;
import org.infinispan.marshall.persistence.impl.PersistenceContextInitializer;
import org.infinispan.marshall.protostream.impl.MarshallableUserObject;
import org.infinispan.marshall.protostream.impl.SerializationContextRegistry;
import org.infinispan.protostream.BaseMarshaller;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.util.logging.Log;

@Scope(value=Scopes.GLOBAL)
public class PersistenceMarshallerImpl
implements PersistenceMarshaller {
    private static final int PROTOSTREAM_DEFAULT_BUFFER_SIZE = 4096;
    private static final BufferSizePredictor BUFFER_SIZE_PREDICTOR = new BufferSizePredictor(){

        public int nextSize(Object obj) {
            return 4096;
        }

        public void recordSize(int previousSize) {
        }
    };
    @Inject
    GlobalComponentRegistry gcr;
    @Inject
    SerializationContextRegistry ctxRegistry;
    private Marshaller userMarshaller;

    public ImmutableSerializationContext getSerializationContext() {
        return this.ctxRegistry.getPersistenceCtx();
    }

    @Start
    public void start() {
        this.userMarshaller = this.createUserMarshaller();
        if (this.userMarshaller != null) {
            Log.PERSISTENCE.startingUserMarshaller(this.userMarshaller.getClass().getName());
            this.userMarshaller.start();
        }
        String messageName = PersistenceContextInitializer.getFqTypeName(MarshallableUserObject.class);
        this.ctxRegistry.addMarshaller(SerializationContextRegistry.MarshallerType.PERSISTENCE, (BaseMarshaller)new MarshallableUserObject.Marshaller(messageName, this.getUserMarshaller()));
    }

    private Marshaller createUserMarshaller() {
        GlobalConfiguration globalConfig = this.gcr.getGlobalConfiguration();
        SerializationConfiguration serializationConfig = globalConfig.serialization();
        Marshaller marshaller = serializationConfig.marshaller();
        if (marshaller != null) {
            marshaller.initialize(this.gcr.getCacheManager().getClassAllowList());
            return marshaller;
        }
        return null;
    }

    @Override
    public Marshaller getUserMarshaller() {
        return this.userMarshaller == null ? this : this.userMarshaller;
    }

    @Override
    public void register(SerializationContextInitializer initializer) {
        this.ctxRegistry.addContextInitializer(SerializationContextRegistry.MarshallerType.PERSISTENCE, initializer);
    }

    public void stop() {
        if (this.userMarshaller != null) {
            this.userMarshaller.stop();
        }
    }

    public MediaType mediaType() {
        return MediaType.APPLICATION_PROTOSTREAM;
    }

    public ByteBuffer objectToBuffer(Object o) {
        return ByteBufferImpl.create((byte[])this.objectToByteBuffer(o, -1));
    }

    public byte[] objectToByteBuffer(Object obj, int estimatedSize) {
        if (obj == null) {
            return null;
        }
        try {
            if (this.requiresWrapping(obj)) {
                obj = new MarshallableUserObject<Object>(obj);
            }
            int size = estimatedSize < 0 ? 4096 : estimatedSize;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(size);
            ProtobufUtil.toWrappedStream((ImmutableSerializationContext)this.getSerializationContext(), (OutputStream)baos, obj, (int)size);
            return baos.toByteArray();
        }
        catch (Throwable t) {
            Log.PERSISTENCE.cannotMarshall(obj.getClass(), t);
            if (t instanceof MarshallingException) {
                throw (MarshallingException)t;
            }
            throw new MarshallingException(t.getMessage(), t.getCause());
        }
    }

    public byte[] objectToByteBuffer(Object obj) {
        return this.objectToByteBuffer(obj, this.sizeEstimate(obj));
    }

    public Object objectFromByteBuffer(byte[] buf) throws IOException {
        return this.objectFromByteBuffer(buf, 0, buf.length);
    }

    public Object objectFromByteBuffer(byte[] buf, int offset, int length) throws IOException {
        return this.unwrapAndInit(ProtobufUtil.fromWrappedByteArray((ImmutableSerializationContext)this.getSerializationContext(), (byte[])buf, (int)offset, (int)length));
    }

    public BufferSizePredictor getBufferSizePredictor(Object o) {
        return this.userMarshaller != null ? this.userMarshaller.getBufferSizePredictor(o) : BUFFER_SIZE_PREDICTOR;
    }

    public void writeObject(Object o, OutputStream out) throws IOException {
        if (this.requiresWrapping(o)) {
            o = new MarshallableUserObject<Object>(o);
        }
        ProtobufUtil.toWrappedStream((ImmutableSerializationContext)this.getSerializationContext(), (OutputStream)out, o, (int)4096);
    }

    public Object readObject(InputStream in) throws ClassNotFoundException, IOException {
        return this.unwrapAndInit(ProtobufUtil.fromWrappedStream((ImmutableSerializationContext)this.getSerializationContext(), (InputStream)in));
    }

    private Object unwrapAndInit(Object o) {
        if (o instanceof MarshallableUserObject) {
            MarshallableUserObject wrapper = (MarshallableUserObject)o;
            return wrapper.get();
        }
        return o;
    }

    public boolean isMarshallable(Object o) {
        return this.isMarshallableWithProtoStream(o) || this.isUserMarshallable(o);
    }

    public int sizeEstimate(Object o) {
        if (this.isMarshallableWithProtoStream(o)) {
            return 4096;
        }
        if (this.userMarshaller == null) {
            return 0;
        }
        int userBytesEstimate = this.userMarshaller.getBufferSizePredictor(o.getClass()).nextSize(o);
        return MarshallableUserObject.size(userBytesEstimate);
    }

    private boolean requiresWrapping(Object o) {
        return !this.isMarshallableWithProtoStream(o) && this.userMarshaller != null;
    }

    private boolean isMarshallableWithProtoStream(Object o) {
        if (this.userMarshaller == null) {
            return o instanceof String || o instanceof Long || o instanceof Integer || o instanceof Double || o instanceof Float || o instanceof Boolean || o instanceof byte[] || o instanceof Byte || o instanceof Short || o instanceof Character || o instanceof Date || o instanceof Instant || this.getSerializationContext().canMarshall(o.getClass());
        }
        return this.getSerializationContext().canMarshall(o.getClass());
    }

    private boolean isUserMarshallable(Object o) {
        try {
            return this.userMarshaller != null && this.userMarshaller.isMarshallable(o);
        }
        catch (Exception ignore) {
            return false;
        }
    }
}

