/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.commands;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.xsite.BackupReceiver;
import org.infinispan.xsite.XSiteReplicateCommand;
import org.infinispan.xsite.statetransfer.XSiteStateConsumer;
import org.infinispan.xsite.statetransfer.XSiteStateTransferManager;

public class XSiteStateTransferStartReceiveCommand
extends XSiteReplicateCommand<Void> {
    public static final byte COMMAND_ID = 106;
    private String siteName;

    public XSiteStateTransferStartReceiveCommand() {
        super((byte)106, null);
    }

    public XSiteStateTransferStartReceiveCommand(ByteString cacheName) {
        this(cacheName, null);
    }

    public XSiteStateTransferStartReceiveCommand(ByteString cacheName, String siteName) {
        super((byte)106, cacheName);
        this.siteName = siteName;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) {
        XSiteStateTransferManager stateTransferManager = registry.getXSiteStateTransferManager().running();
        XSiteStateConsumer consumer = stateTransferManager.getStateConsumer();
        consumer.startStateTransfer(this.siteName);
        return CompletableFutures.completedNull();
    }

    @Override
    public CompletionStage<Void> performInLocalSite(BackupReceiver receiver, boolean preserveOrder) {
        assert (!preserveOrder);
        return receiver.handleStartReceivingStateTransfer(this);
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallString((String)this.siteName, (ObjectOutput)output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.siteName = MarshallUtil.unmarshallString((ObjectInput)input);
    }

    public static XSiteStateTransferStartReceiveCommand copyForCache(XSiteStateTransferStartReceiveCommand command, ByteString cacheName) {
        if (!command.cacheName.equals(cacheName)) {
            return new XSiteStateTransferStartReceiveCommand(cacheName, command.originSite);
        }
        command.siteName = command.originSite;
        return command;
    }

    @Override
    public String toString() {
        return "XSiteStateTransferStartReceiveCommand{siteName='" + this.siteName + '\'' + ", cacheName=" + this.cacheName + '}';
    }
}

