/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.WhiteListConfiguration;

public class WhiteListConfigurationBuilder
implements Builder<WhiteListConfiguration> {
    private final AttributeSet attributes;
    private final Set<String> classes = new HashSet<String>();
    private final List<String> regexps = new ArrayList<String>();

    WhiteListConfigurationBuilder() {
        this.attributes = WhiteListConfiguration.attributeDefinitionSet();
    }

    public <T> WhiteListConfigurationBuilder addClass(String clazz) {
        this.classes.add(clazz);
        return this;
    }

    public <T> WhiteListConfigurationBuilder addClasses(Class ... classes) {
        List classNames = Arrays.stream(classes).map(Class::getName).collect(Collectors.toList());
        this.classes.addAll(classNames);
        return this;
    }

    public <T> WhiteListConfigurationBuilder addRegexp(String regex) {
        this.regexps.add(regex);
        return this;
    }

    public <T> WhiteListConfigurationBuilder addRegexps(String ... regexps) {
        this.regexps.addAll(Arrays.asList(regexps));
        return this;
    }

    public void validate() {
    }

    public WhiteListConfiguration create() {
        if (!this.classes.isEmpty()) {
            this.attributes.attribute(WhiteListConfiguration.CLASSES).set(this.classes);
        }
        if (!this.regexps.isEmpty()) {
            this.attributes.attribute(WhiteListConfiguration.REGEXPS).set(this.regexps);
        }
        return new WhiteListConfiguration(this.attributes.protect());
    }

    public Builder<?> read(WhiteListConfiguration template) {
        this.attributes.read(template.attributes());
        this.classes.addAll(template.getClasses());
        this.regexps.addAll(template.getRegexps());
        return this;
    }
}

