/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories.impl;

import java.lang.reflect.AccessibleObject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.infinispan.security.Security;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

final class SecurityActions {
    private static final Log log = LogFactory.getLog(SecurityActions.class);

    SecurityActions() {
    }

    static <T> void doPrivileged(PrivilegedAction<T> runnable) {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(() -> {
                runnable.run();
                return null;
            });
        } else {
            Security.doPrivileged(() -> {
                runnable.run();
                return null;
            });
        }
    }

    static void setAccessible(AccessibleObject member) {
        SecurityActions.doPrivileged(() -> {
            member.setAccessible(true);
            return null;
        });
    }
}

