/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.List;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.impl.AbstractIracRemoteSiteInterceptor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.irac.DiscardUpdateException;

public class OptimisticTxIracRemoteSiteInterceptor
extends AbstractIracRemoteSiteInterceptor {
    private static final Log log = LogFactory.getLog(OptimisticTxIracRemoteSiteInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();

    private static boolean isNormalTransaction(List<WriteCommand> mods) {
        return mods.size() != 1 || OptimisticTxIracRemoteSiteInterceptor.isNormalWriteCommand(mods.get(0));
    }

    private static boolean isNormalTransaction(WriteCommand[] mods) {
        return mods.length != 1 || OptimisticTxIracRemoteSiteInterceptor.isNormalWriteCommand(mods[0]);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) {
        if (OptimisticTxIracRemoteSiteInterceptor.isNormalTransaction(command.getModifications())) {
            return this.invokeNext(ctx, command);
        }
        DataWriteCommand cmd = (DataWriteCommand)command.getModifications()[0];
        if (this.getDistributionInfo(cmd.getKey()).isPrimary()) {
            this.validateOnPrimary(ctx, cmd, null);
            if (!cmd.isSuccessful()) {
                throw DiscardUpdateException.getInstance();
            }
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) {
        if (OptimisticTxIracRemoteSiteInterceptor.isNormalTransaction(ctx.getModifications())) {
            return this.invokeNext(ctx, command);
        }
        this.setIracMetadataForOwner(ctx, (DataWriteCommand)ctx.getModifications().get(0), null);
        return this.invokeNext(ctx, command);
    }

    @Override
    boolean isTraceEnabled() {
        return trace;
    }

    @Override
    Log getLog() {
        return log;
    }
}

