/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSerializer;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.Matchable;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.conflict.EntryMergePolicy;
import org.infinispan.conflict.MergePolicy;
import org.infinispan.partitionhandling.PartitionHandling;

public class PartitionHandlingConfiguration
implements Matchable<PartitionHandlingConfiguration>,
ConfigurationInfo {
    public static final AttributeDefinition<PartitionHandling> WHEN_SPLIT = AttributeDefinition.builder((String)"whenSplit", (Object)((Object)PartitionHandling.ALLOW_READ_WRITES)).immutable().build();
    public static final AttributeDefinition<EntryMergePolicy> MERGE_POLICY = AttributeDefinition.builder((String)"mergePolicy", (Object)MergePolicy.NONE, EntryMergePolicy.class).serializer((AttributeSerializer)new AttributeSerializer<EntryMergePolicy, ConfigurationInfo, ConfigurationBuilderInfo>(){

        public Object readAttributeValue(String enclosingElement, AttributeDefinition attributeDefinition, Object attrValue, ConfigurationBuilderInfo builderInfo) {
            String strValue = attrValue.toString();
            MergePolicy mp = MergePolicy.fromString(strValue);
            return mp == MergePolicy.CUSTOM ? Util.getInstance((String)strValue, (ClassLoader)builderInfo.getClass().getClassLoader()) : mp;
        }
    }).immutable().build();
    public static final ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.PARTITION_HANDLING.getLocalName());
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(PartitionHandlingConfiguration.class, new AttributeDefinition[]{WHEN_SPLIT, MERGE_POLICY});
    }

    public PartitionHandlingConfiguration(AttributeSet attributes) {
        this.attributes = attributes.checkProtection();
    }

    public PartitionHandling whenSplit() {
        return (PartitionHandling)((Object)this.attributes.attribute(WHEN_SPLIT).get());
    }

    public EntryMergePolicy mergePolicy() {
        return (EntryMergePolicy)this.attributes.attribute(MERGE_POLICY).get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public boolean resolveConflictsOnMerge() {
        EntryMergePolicy policy = this.mergePolicy();
        if (policy == MergePolicy.NONE) {
            return false;
        }
        return policy != null;
    }

    public String toString() {
        return "PartitionHandlingConfiguration [attributes=" + this.attributes + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PartitionHandlingConfiguration other = (PartitionHandlingConfiguration)obj;
        return !(this.attributes == null ? other.attributes != null : !this.attributes.equals((Object)other.attributes));
    }
}

