/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling.impl;

import java.util.HashSet;
import java.util.Map;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.IracPutKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.InvocationFinallyAction;
import org.infinispan.interceptors.InvocationSuccessAction;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.RpcException;
import org.infinispan.statetransfer.AllOwnersLostException;
import org.infinispan.util.logging.Log;

public class PartitionHandlingInterceptor
extends DDAsyncInterceptor {
    @Inject
    PartitionHandlingManager partitionHandlingManager;
    private final InvocationFinallyAction<DataCommand> handleDataReadReturn = this::handleDataReadReturn;
    private final InvocationFinallyAction<GetAllCommand> handleGetAllCommandReturn = this::handleGetAllCommandReturn;
    private final InvocationSuccessAction<VisitableCommand> postTxCommandCheck = this::postTxCommandCheck;

    private boolean performPartitionCheck(FlagAffectedCommand command) {
        return !command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL | FlagBitSets.SKIP_OWNERSHIP_CHECK | FlagBitSets.PUT_FOR_STATE_TRANSFER);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    @Override
    public Object visitIracPutKeyValueCommand(InvocationContext ctx, IracPutKeyValueCommand command) {
        return this.handleSingleWrite(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    @Override
    public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    @Override
    public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
        return this.handleSingleWrite(ctx, command);
    }

    protected Object handleSingleWrite(InvocationContext ctx, DataWriteCommand command) {
        if (this.performPartitionCheck(command)) {
            this.partitionHandlingManager.checkWrite(command.getKey());
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        if (this.performPartitionCheck(command)) {
            for (Object k : command.getAffectedKeys()) {
                this.partitionHandlingManager.checkWrite(k);
            }
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        if (this.performPartitionCheck(command)) {
            this.partitionHandlingManager.checkClear();
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public Object visitKeySetCommand(InvocationContext ctx, KeySetCommand command) throws Throwable {
        if (this.performPartitionCheck(command)) {
            this.partitionHandlingManager.checkBulkRead();
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public Object visitEntrySetCommand(InvocationContext ctx, EntrySetCommand command) throws Throwable {
        if (this.performPartitionCheck(command)) {
            this.partitionHandlingManager.checkBulkRead();
        }
        return this.handleDefault(ctx, command);
    }

    @Override
    public final Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.handleDataReadCommand(ctx, command);
    }

    @Override
    public final Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) {
        return this.handleDataReadCommand(ctx, command);
    }

    private Object handleDataReadCommand(InvocationContext ctx, DataCommand command) {
        return this.invokeNextAndFinally(ctx, command, this.handleDataReadReturn);
    }

    private void handleDataReadReturn(InvocationContext rCtx, DataCommand dataCommand, Object rv, Throwable t) {
        if (!this.performPartitionCheck(dataCommand)) {
            return;
        }
        if (t != null) {
            if (t instanceof RpcException) {
                throw Log.CONTAINER.degradedModeKeyUnavailable(dataCommand.getKey());
            }
            if (t instanceof AllOwnersLostException) assert (this.cacheConfiguration.clustering().cacheMode().isScattered());
        }
        this.partitionHandlingManager.checkRead(dataCommand.getKey(), dataCommand.getFlagsBitSet());
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!ctx.isOriginLocal()) {
            return this.invokeNext(ctx, command);
        }
        if (this.partitionHandlingManager.getAvailabilityMode() != AvailabilityMode.AVAILABLE && !command.isOnePhaseCommit() && ctx.hasModifications()) {
            for (Object key : ctx.getAffectedKeys()) {
                this.partitionHandlingManager.checkWrite(key);
            }
        }
        return this.invokeNextThenAccept(ctx, command, this.postTxCommandCheck);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (!ctx.isOriginLocal()) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextThenAccept(ctx, command, this.postTxCommandCheck);
    }

    protected void postTxCommandCheck(InvocationContext rCtx, VisitableCommand rCommand, Object rv) {
        TxInvocationContext ctx = (TxInvocationContext)rCtx;
        if (this.partitionHandlingManager.getAvailabilityMode() != AvailabilityMode.AVAILABLE && !this.partitionHandlingManager.isTransactionPartiallyCommitted(ctx.getGlobalTransaction()) && ctx.hasModifications()) {
            for (Object key : ctx.getAffectedKeys()) {
                this.partitionHandlingManager.checkWrite(key);
            }
        }
    }

    @Override
    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        return this.invokeNextAndFinally(ctx, command, this.handleGetAllCommandReturn);
    }

    private void handleGetAllCommandReturn(InvocationContext rCtx, GetAllCommand getAllCommand, Object rv, Throwable t) {
        Map result;
        if (t != null && t instanceof RpcException && this.performPartitionCheck(getAllCommand)) {
            throw Log.CONTAINER.degradedModeKeysUnavailable(getAllCommand.getKeys());
        }
        if (!this.performPartitionCheck(getAllCommand)) {
            return;
        }
        for (Object key : getAllCommand.getKeys()) {
            this.partitionHandlingManager.checkRead(key, getAllCommand.getFlagsBitSet());
        }
        if (t == null && rv instanceof Map && (result = (Map)rv).size() != getAllCommand.getKeys().size()) {
            HashSet missingKeys = new HashSet(getAllCommand.getKeys());
            missingKeys.removeAll(result.keySet());
            throw Log.CONTAINER.degradedModeKeysUnavailable(missingKeys);
        }
    }
}

