/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.commons.configuration.BasicConfiguration;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.configuration.attributes.Matchable;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.CustomInterceptorsConfiguration;
import org.infinispan.configuration.cache.EncodingConfiguration;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.configuration.cache.IndexingConfiguration;
import org.infinispan.configuration.cache.InvocationBatchingConfiguration;
import org.infinispan.configuration.cache.JMXStatisticsConfiguration;
import org.infinispan.configuration.cache.LockingConfiguration;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.SecurityConfiguration;
import org.infinispan.configuration.cache.SitesConfiguration;
import org.infinispan.configuration.cache.StatisticsConfiguration;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.configuration.cache.UnsafeConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.ParserRegistry;

public class Configuration
extends ConfigurationElement<Configuration>
implements BasicConfiguration {
    public static final AttributeDefinition<Boolean> SIMPLE_CACHE = AttributeDefinition.builder((Enum)Attribute.SIMPLE_CACHE, (Object)false).immutable().build();
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> simpleCache;
    private final ClusteringConfiguration clusteringConfiguration;
    private final CustomInterceptorsConfiguration customInterceptorsConfiguration;
    private final MemoryConfiguration memoryConfiguration;
    private final EncodingConfiguration encodingConfiguration;
    private final ExpirationConfiguration expirationConfiguration;
    private final IndexingConfiguration indexingConfiguration;
    private final InvocationBatchingConfiguration invocationBatchingConfiguration;
    private final StatisticsConfiguration statisticsConfiguration;
    private final PersistenceConfiguration persistenceConfiguration;
    private final LockingConfiguration lockingConfiguration;
    private final TransactionConfiguration transactionConfiguration;
    private final UnsafeConfiguration unsafeConfiguration;
    private final Map<Class<?>, ?> moduleConfiguration;
    private final SecurityConfiguration securityConfiguration;
    private final SitesConfiguration sitesConfiguration;
    private final boolean template;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(Configuration.class, new AttributeDefinition[]{SIMPLE_CACHE});
    }

    Configuration(boolean template, AttributeSet attributes, ClusteringConfiguration clusteringConfiguration, CustomInterceptorsConfiguration customInterceptorsConfiguration, ExpirationConfiguration expirationConfiguration, EncodingConfiguration encodingConfiguration, IndexingConfiguration indexingConfiguration, InvocationBatchingConfiguration invocationBatchingConfiguration, StatisticsConfiguration statisticsConfiguration, PersistenceConfiguration persistenceConfiguration, LockingConfiguration lockingConfiguration, SecurityConfiguration securityConfiguration, TransactionConfiguration transactionConfiguration, UnsafeConfiguration unsafeConfiguration, SitesConfiguration sitesConfiguration, MemoryConfiguration memoryConfiguration, List<?> modules) {
        super((Enum)clusteringConfiguration.cacheMode().toElement(template), attributes, new ConfigurationElement[]{clusteringConfiguration, expirationConfiguration, encodingConfiguration, statisticsConfiguration, lockingConfiguration, transactionConfiguration, unsafeConfiguration, sitesConfiguration, memoryConfiguration});
        this.template = template;
        this.simpleCache = attributes.attribute(SIMPLE_CACHE);
        this.clusteringConfiguration = clusteringConfiguration;
        this.customInterceptorsConfiguration = customInterceptorsConfiguration;
        this.encodingConfiguration = encodingConfiguration;
        this.expirationConfiguration = expirationConfiguration;
        this.indexingConfiguration = indexingConfiguration;
        this.invocationBatchingConfiguration = invocationBatchingConfiguration;
        this.statisticsConfiguration = statisticsConfiguration;
        this.persistenceConfiguration = persistenceConfiguration;
        this.lockingConfiguration = lockingConfiguration;
        this.transactionConfiguration = transactionConfiguration;
        this.unsafeConfiguration = unsafeConfiguration;
        this.securityConfiguration = securityConfiguration;
        this.sitesConfiguration = sitesConfiguration;
        this.memoryConfiguration = memoryConfiguration;
        HashMap modulesMap = new HashMap();
        for (Object module : modules) {
            modulesMap.put(module.getClass(), module);
        }
        this.moduleConfiguration = Collections.unmodifiableMap(modulesMap);
    }

    public boolean simpleCache() {
        return (Boolean)this.simpleCache.get();
    }

    public ClusteringConfiguration clustering() {
        return this.clusteringConfiguration;
    }

    @Deprecated
    public CustomInterceptorsConfiguration customInterceptors() {
        return this.customInterceptorsConfiguration;
    }

    public EncodingConfiguration encoding() {
        return this.encodingConfiguration;
    }

    public ExpirationConfiguration expiration() {
        return this.expirationConfiguration;
    }

    public IndexingConfiguration indexing() {
        return this.indexingConfiguration;
    }

    public InvocationBatchingConfiguration invocationBatching() {
        return this.invocationBatchingConfiguration;
    }

    public StatisticsConfiguration statistics() {
        return this.statisticsConfiguration;
    }

    @Deprecated
    public JMXStatisticsConfiguration jmxStatistics() {
        return this.statistics();
    }

    public PersistenceConfiguration persistence() {
        return this.persistenceConfiguration;
    }

    public LockingConfiguration locking() {
        return this.lockingConfiguration;
    }

    public MemoryConfiguration memory() {
        return this.memoryConfiguration;
    }

    public <T> T module(Class<T> moduleClass) {
        return (T)this.moduleConfiguration.get(moduleClass);
    }

    public Map<Class<?>, ?> modules() {
        return this.moduleConfiguration;
    }

    public TransactionConfiguration transaction() {
        return this.transactionConfiguration;
    }

    public UnsafeConfiguration unsafe() {
        return this.unsafeConfiguration;
    }

    public SecurityConfiguration security() {
        return this.securityConfiguration;
    }

    public SitesConfiguration sites() {
        return this.sitesConfiguration;
    }

    public boolean isTemplate() {
        return this.template;
    }

    public String toString() {
        return "Configuration{simpleCache=" + this.simpleCache + ", clustering=" + (Object)((Object)this.clusteringConfiguration) + ", customInterceptors=" + this.customInterceptorsConfiguration + ", encodingConfiguration= " + (Object)((Object)this.encodingConfiguration) + ", expiration=" + (Object)((Object)this.expirationConfiguration) + ", indexing=" + (Object)((Object)this.indexingConfiguration) + ", invocationBatching=" + this.invocationBatchingConfiguration + ", statistics=" + this.statisticsConfiguration + ", persistence=" + this.persistenceConfiguration + ", locking=" + (Object)((Object)this.lockingConfiguration) + ", modules=" + this.moduleConfiguration + ", security=" + this.securityConfiguration + ", transaction=" + (Object)((Object)this.transactionConfiguration) + ", unsafe=" + (Object)((Object)this.unsafeConfiguration) + ", sites=" + (Object)((Object)this.sitesConfiguration) + ", memory=" + (Object)((Object)this.memoryConfiguration) + '}';
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ((Boolean)this.simpleCache.get() != false ? 0 : 1);
        result = 31 * result + (this.template ? 1231 : 1237);
        result = 31 * result + (this.clusteringConfiguration == null ? 0 : this.clusteringConfiguration.hashCode());
        result = 31 * result + (this.customInterceptorsConfiguration == null ? 0 : this.customInterceptorsConfiguration.hashCode());
        result = 31 * result + (this.encodingConfiguration == null ? 0 : this.encodingConfiguration.hashCode());
        result = 31 * result + (this.expirationConfiguration == null ? 0 : this.expirationConfiguration.hashCode());
        result = 31 * result + (this.indexingConfiguration == null ? 0 : this.indexingConfiguration.hashCode());
        result = 31 * result + (this.invocationBatchingConfiguration == null ? 0 : this.invocationBatchingConfiguration.hashCode());
        result = 31 * result + (this.statisticsConfiguration == null ? 0 : this.statisticsConfiguration.hashCode());
        result = 31 * result + (this.lockingConfiguration == null ? 0 : this.lockingConfiguration.hashCode());
        result = 31 * result + (this.moduleConfiguration == null ? 0 : this.moduleConfiguration.hashCode());
        result = 31 * result + (this.persistenceConfiguration == null ? 0 : this.persistenceConfiguration.hashCode());
        result = 31 * result + (this.securityConfiguration == null ? 0 : this.securityConfiguration.hashCode());
        result = 31 * result + (this.sitesConfiguration == null ? 0 : this.sitesConfiguration.hashCode());
        result = 31 * result + (this.transactionConfiguration == null ? 0 : this.transactionConfiguration.hashCode());
        result = 31 * result + (this.unsafeConfiguration == null ? 0 : this.unsafeConfiguration.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Configuration other = (Configuration)((Object)obj);
        if (this.template != other.template) {
            return false;
        }
        if (!((Boolean)this.simpleCache.get()).equals(other.simpleCache.get())) {
            return false;
        }
        if (this.clusteringConfiguration == null ? other.clusteringConfiguration != null : !this.clusteringConfiguration.equals((Object)other.clusteringConfiguration)) {
            return false;
        }
        if (this.customInterceptorsConfiguration == null ? other.customInterceptorsConfiguration != null : !this.customInterceptorsConfiguration.equals(other.customInterceptorsConfiguration)) {
            return false;
        }
        if (this.expirationConfiguration == null ? other.expirationConfiguration != null : !this.expirationConfiguration.equals((Object)other.expirationConfiguration)) {
            return false;
        }
        if (this.indexingConfiguration == null ? other.indexingConfiguration != null : !this.indexingConfiguration.equals((Object)other.indexingConfiguration)) {
            return false;
        }
        if (this.invocationBatchingConfiguration == null ? other.invocationBatchingConfiguration != null : !this.invocationBatchingConfiguration.equals(other.invocationBatchingConfiguration)) {
            return false;
        }
        if (this.statisticsConfiguration == null ? other.statisticsConfiguration != null : !this.statisticsConfiguration.equals(other.statisticsConfiguration)) {
            return false;
        }
        if (this.lockingConfiguration == null ? other.lockingConfiguration != null : !this.lockingConfiguration.equals((Object)other.lockingConfiguration)) {
            return false;
        }
        if (this.memoryConfiguration == null ? other.memoryConfiguration != null : !this.memoryConfiguration.equals((Object)other.memoryConfiguration)) {
            return false;
        }
        if (this.moduleConfiguration == null ? other.moduleConfiguration != null : !this.moduleConfiguration.equals(other.moduleConfiguration)) {
            return false;
        }
        if (this.persistenceConfiguration == null ? other.persistenceConfiguration != null : !this.persistenceConfiguration.equals(other.persistenceConfiguration)) {
            return false;
        }
        if (this.securityConfiguration == null ? other.securityConfiguration != null : !this.securityConfiguration.equals(other.securityConfiguration)) {
            return false;
        }
        if (this.sitesConfiguration == null ? other.sitesConfiguration != null : !this.sitesConfiguration.equals((Object)other.sitesConfiguration)) {
            return false;
        }
        if (this.transactionConfiguration == null ? other.transactionConfiguration != null : !this.transactionConfiguration.equals((Object)other.transactionConfiguration)) {
            return false;
        }
        return !(this.unsafeConfiguration == null ? other.unsafeConfiguration != null : !this.unsafeConfiguration.equals((Object)other.unsafeConfiguration));
    }

    public boolean matches(Configuration other) {
        if (!((Boolean)this.simpleCache.get()).equals(other.simpleCache.get())) {
            return false;
        }
        if (!this.clusteringConfiguration.matches(other.clusteringConfiguration)) {
            return false;
        }
        if (!this.customInterceptorsConfiguration.matches(other.customInterceptorsConfiguration)) {
            return false;
        }
        if (!this.expirationConfiguration.matches(other.expirationConfiguration)) {
            return false;
        }
        if (!this.indexingConfiguration.matches((Object)other.indexingConfiguration)) {
            return false;
        }
        if (!this.invocationBatchingConfiguration.matches(other.invocationBatchingConfiguration)) {
            return false;
        }
        if (!this.statisticsConfiguration.matches(other.statisticsConfiguration)) {
            return false;
        }
        if (!this.lockingConfiguration.matches(other.lockingConfiguration)) {
            return false;
        }
        if (!this.memoryConfiguration.matches(other.memoryConfiguration)) {
            return false;
        }
        if (!this.persistenceConfiguration.matches(other.persistenceConfiguration)) {
            return false;
        }
        if (!this.securityConfiguration.matches(other.securityConfiguration)) {
            return false;
        }
        if (!this.sitesConfiguration.matches(other.sitesConfiguration)) {
            return false;
        }
        if (!this.transactionConfiguration.matches(other.transactionConfiguration)) {
            return false;
        }
        if (!this.unsafeConfiguration.matches(other.unsafeConfiguration)) {
            return false;
        }
        for (Map.Entry<Class<?>, ?> module : this.moduleConfiguration.entrySet()) {
            if (!other.moduleConfiguration.containsKey(module.getKey())) {
                return false;
            }
            Object thisModule = module.getValue();
            Object thatModule = other.moduleConfiguration.get(module.getKey());
            if (thisModule instanceof Matchable && !((Matchable)thisModule).matches(thatModule)) {
                return false;
            }
            if (thisModule.equals(thatModule)) continue;
            return false;
        }
        return this.attributes.matches(other.attributes);
    }

    public String toStringConfiguration(String name) {
        ParserRegistry reg = new ParserRegistry();
        return reg.serialize(name, this);
    }
}

