/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metrics.impl;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;

public class BaseMemoryAdditionalMetrics
implements MeterBinder {
    public void bindTo(MeterRegistry registry) {
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        Gauge.builder((String)"memory.committedHeap", (Object)memoryBean, mem -> mem.getHeapMemoryUsage().getCommitted()).baseUnit("bytes").description("Displays the amount of memory that is committed for the Java virtual machine to use.").register(registry);
        Gauge.builder((String)"memory.maxHeap", (Object)memoryBean, mem -> mem.getHeapMemoryUsage().getMax()).baseUnit("bytes").description("Displays the maximum amount of memory, in bytes, that can be used for memory management.").register(registry);
        Gauge.builder((String)"memory.usedHeap", (Object)memoryBean, mem -> mem.getHeapMemoryUsage().getUsed()).baseUnit("bytes").description("Displays the amount of used memory.").register(registry);
        Gauge.builder((String)"memory.initHeap", (Object)memoryBean, mem -> mem.getHeapMemoryUsage().getInit()).baseUnit("bytes").description("Displays the initial amount of allocated heap memory in bytes.").register(registry);
        Gauge.builder((String)"memory.committedNonHeap", (Object)memoryBean, mem -> mem.getNonHeapMemoryUsage().getCommitted()).baseUnit("bytes").description("Displays the amount of memory that is committed for the Java virtual machine to use.").register(registry);
        Gauge.builder((String)"memory.maxNonHeap", (Object)memoryBean, mem -> mem.getNonHeapMemoryUsage().getMax()).baseUnit("bytes").description("Displays the maximum amount of memory in bytes that can be used for memory management.").register(registry);
        Gauge.builder((String)"memory.usedNonHeap", (Object)memoryBean, mem -> mem.getNonHeapMemoryUsage().getUsed()).baseUnit("bytes").description("Displays the amount of used memory.").register(registry);
        Gauge.builder((String)"memory.initNonHeap", (Object)memoryBean, mem -> mem.getNonHeapMemoryUsage().getInit()).baseUnit("bytes").description("Displays the initial amount of allocated memory, in bytes, for off-heap storage.").register(registry);
    }
}

