/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.responses;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.marshall.core.Ids;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.transaction.impl.WriteSkewHelper;

public class PrepareResponse
extends ValidResponse {
    public static final Externalizer EXTERNALIZER = new Externalizer();
    private Map<Object, IncrementableEntryVersion> newWriteSkewVersions;
    private Map<Integer, IracMetadata> newIracMetadata;

    public static void writeTo(PrepareResponse response, ObjectOutput output) throws IOException {
        MarshallUtil.marshallMap(response.newWriteSkewVersions, (ObjectOutput)output);
        MarshallUtil.marshallMap(response.newIracMetadata, DataOutput::writeInt, IracMetadata::writeTo, (ObjectOutput)output);
    }

    public static PrepareResponse readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        PrepareResponse response = new PrepareResponse();
        response.newWriteSkewVersions = MarshallUtil.unmarshallMap((ObjectInput)input, HashMap::new);
        response.newIracMetadata = MarshallUtil.unmarshallMap((ObjectInput)input, DataInput::readInt, IracMetadata::readFrom, HashMap::new);
        return response;
    }

    public static PrepareResponse asPrepareResponse(Object rv) {
        assert (rv == null || rv instanceof PrepareResponse);
        return rv == null ? new PrepareResponse() : (PrepareResponse)rv;
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    @Override
    public Object getResponseValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return "PrepareResponse{WriteSkewVersions=" + this.newWriteSkewVersions + ", IracMetadataMap=" + this.newIracMetadata + '}';
    }

    public IracMetadata getIracMetadata(int segment) {
        return this.newIracMetadata != null ? this.newIracMetadata.get(segment) : null;
    }

    public void setNewIracMetadata(Map<Integer, IracMetadata> map) {
        this.newIracMetadata = map;
    }

    public void merge(PrepareResponse remote) {
        if (remote.newWriteSkewVersions != null) {
            this.mergeEntryVersions(remote.newWriteSkewVersions);
        }
        if (remote.newIracMetadata != null) {
            if (this.newIracMetadata == null) {
                this.newIracMetadata = new HashMap<Integer, IracMetadata>(remote.newIracMetadata);
            } else {
                this.newIracMetadata.putAll(remote.newIracMetadata);
            }
        }
    }

    public Map<Object, IncrementableEntryVersion> mergeEntryVersions(Map<Object, IncrementableEntryVersion> entryVersions) {
        if (this.newWriteSkewVersions == null) {
            this.newWriteSkewVersions = new HashMap<Object, IncrementableEntryVersion>();
        }
        this.newWriteSkewVersions = WriteSkewHelper.mergeEntryVersions(this.newWriteSkewVersions, entryVersions);
        return this.newWriteSkewVersions;
    }

    private static class Externalizer
    extends AbstractExternalizer<PrepareResponse> {
        private Externalizer() {
        }

        public Integer getId() {
            return Ids.PREPARE_RESPONSE;
        }

        public Set<Class<? extends PrepareResponse>> getTypeClasses() {
            return Collections.singleton(PrepareResponse.class);
        }

        public void writeObject(ObjectOutput output, PrepareResponse object) throws IOException {
            PrepareResponse.writeTo(object, output);
        }

        public PrepareResponse readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return PrepareResponse.readFrom(input);
        }
    }
}

