/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.xa.recovery;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.marshall.core.Ids;
import org.infinispan.remoting.transport.Address;

public class InDoubtTxInfo {
    public static final AbstractExternalizer<InDoubtTxInfo> EXTERNALIZER = new Externalizer();
    private final XidImpl xid;
    private final long internalId;
    private int status;
    private final transient Set<Address> owners = new HashSet<Address>();
    private transient boolean isLocal;

    public InDoubtTxInfo(XidImpl xid, long internalId, int status) {
        this.xid = xid;
        this.internalId = internalId;
        this.status = status;
    }

    public InDoubtTxInfo(XidImpl xid, long internalId) {
        this(xid, internalId, -1);
    }

    public XidImpl getXid() {
        return this.xid;
    }

    public long getInternalId() {
        return this.internalId;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public Set<Address> getOwners() {
        return this.owners;
    }

    public void addOwner(Address owner) {
        this.owners.add(owner);
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public void setLocal(boolean local) {
        this.isLocal = local;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InDoubtTxInfo that = (InDoubtTxInfo)o;
        return this.internalId == that.internalId && this.status == that.status && this.isLocal == that.isLocal && Objects.equals(this.xid, that.xid) && Objects.equals(this.owners, that.owners);
    }

    public int hashCode() {
        return Objects.hash(this.xid, this.internalId, this.status, this.owners, this.isLocal);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{xid=" + this.xid + ", internalId=" + this.internalId + ", status=" + this.status + ", owners=" + this.owners + ", isLocal=" + this.isLocal + '}';
    }

    private static class Externalizer
    extends AbstractExternalizer<InDoubtTxInfo> {
        private Externalizer() {
        }

        public void writeObject(ObjectOutput output, InDoubtTxInfo info) throws IOException {
            XidImpl.writeTo((ObjectOutput)output, (XidImpl)info.xid);
            output.writeLong(info.internalId);
            output.writeInt(info.status);
        }

        public InDoubtTxInfo readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new InDoubtTxInfo(XidImpl.readFrom((ObjectInput)input), input.readLong(), input.readInt());
        }

        public Integer getId() {
            return Ids.IN_DOUBT_TX_INFO;
        }

        public Set<Class<? extends InDoubtTxInfo>> getTypeClasses() {
            return Collections.singleton(InDoubtTxInfo.class);
        }
    }
}

