/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.local;

import java.util.LongSummaryStatistics;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import java.util.stream.LongStream;
import org.infinispan.BaseCacheStream;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.DoubleCacheStream;
import org.infinispan.LongCacheStream;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.stream.CacheAware;
import org.infinispan.stream.impl.intops.primitive.l.BoxedLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.DistinctLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.FilterLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.FlatMapLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.LimitLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.MapLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.MapToDoubleLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.MapToIntLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.MapToObjLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.PeekLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.SkipLongOperation;
import org.infinispan.stream.impl.intops.primitive.l.SortedLongOperation;
import org.infinispan.stream.impl.local.AbstractLocalCacheStream;
import org.infinispan.stream.impl.local.LocalCacheStream;
import org.infinispan.stream.impl.local.LocalDoubleCacheStream;
import org.infinispan.stream.impl.local.LocalIntCacheStream;

public class LocalLongCacheStream
extends AbstractLocalCacheStream<Long, LongStream, LongCacheStream>
implements LongCacheStream {
    public LocalLongCacheStream(AbstractLocalCacheStream.StreamSupplier<Long, LongStream> streamSupplier, boolean parallel, ComponentRegistry registry) {
        super(streamSupplier, parallel, registry);
    }

    LocalLongCacheStream(AbstractLocalCacheStream<?, ?, ?> original) {
        super(original);
    }

    @Override
    public LocalLongCacheStream filter(LongPredicate predicate) {
        this.registry.wireDependencies(predicate);
        this.intermediateOperations.add(new FilterLongOperation(predicate));
        return this;
    }

    @Override
    public LocalLongCacheStream map(LongUnaryOperator mapper) {
        this.registry.wireDependencies(mapper);
        this.intermediateOperations.add(new MapLongOperation(mapper));
        return this;
    }

    public <U> LocalCacheStream<U> mapToObj(LongFunction<? extends U> mapper) {
        this.registry.wireDependencies(mapper);
        this.intermediateOperations.add(new MapToObjLongOperation<U>(mapper));
        return new LocalCacheStream(this);
    }

    @Override
    public LocalIntCacheStream mapToInt(LongToIntFunction mapper) {
        this.intermediateOperations.add(new MapToIntLongOperation(mapper));
        return new LocalIntCacheStream(this);
    }

    @Override
    public LocalDoubleCacheStream mapToDouble(LongToDoubleFunction mapper) {
        this.intermediateOperations.add(new MapToDoubleLongOperation(mapper));
        return new LocalDoubleCacheStream(this);
    }

    @Override
    public LocalLongCacheStream flatMap(LongFunction<? extends LongStream> mapper) {
        this.intermediateOperations.add(new FlatMapLongOperation(mapper));
        return this;
    }

    @Override
    public LocalLongCacheStream distinct() {
        this.intermediateOperations.add(DistinctLongOperation.getInstance());
        return this;
    }

    @Override
    public LocalLongCacheStream sorted() {
        this.intermediateOperations.add(SortedLongOperation.getInstance());
        return this;
    }

    @Override
    public LocalLongCacheStream peek(LongConsumer action) {
        this.intermediateOperations.add(new PeekLongOperation(action));
        return this;
    }

    @Override
    public LocalLongCacheStream limit(long maxSize) {
        this.intermediateOperations.add(new LimitLongOperation(maxSize));
        return this;
    }

    @Override
    public LocalLongCacheStream skip(long n) {
        this.intermediateOperations.add(new SkipLongOperation(n));
        return this;
    }

    @Override
    public void forEach(LongConsumer action) {
        this.injectCache(action);
        try (LongStream stream = (LongStream)this.createStream();){
            stream.forEach(action);
        }
    }

    @Override
    public <K, V> void forEach(ObjLongConsumer<Cache<K, V>> action) {
        Cache cache = this.registry.getComponent(Cache.class);
        try (LongStream stream = (LongStream)this.createStream();){
            stream.forEach((long l) -> action.accept(cache, l));
        }
    }

    @Override
    public void forEachOrdered(LongConsumer action) {
        this.injectCache(action);
        try (LongStream stream = (LongStream)this.createStream();){
            stream.forEachOrdered(action);
        }
    }

    private void injectCache(LongConsumer cacheAware) {
        if (cacheAware instanceof CacheAware) {
            ((CacheAware)((Object)cacheAware)).injectCache(this.registry.getComponent(Cache.class));
        }
    }

    @Override
    public long[] toArray() {
        try (LongStream stream = (LongStream)this.createStream();){
            long[] lArray = stream.toArray();
            return lArray;
        }
    }

    @Override
    public long reduce(long identity, LongBinaryOperator op) {
        try (LongStream stream = (LongStream)this.createStream();){
            long l = stream.reduce(identity, op);
            return l;
        }
    }

    @Override
    public OptionalLong reduce(LongBinaryOperator op) {
        try (LongStream stream = (LongStream)this.createStream();){
            OptionalLong optionalLong = stream.reduce(op);
            return optionalLong;
        }
    }

    @Override
    public <R> R collect(Supplier<R> supplier, ObjLongConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        try (LongStream stream = (LongStream)this.createStream();){
            R r = stream.collect(supplier, accumulator, combiner);
            return r;
        }
    }

    @Override
    public long sum() {
        try (LongStream stream = (LongStream)this.createStream();){
            long l = stream.sum();
            return l;
        }
    }

    @Override
    public OptionalLong min() {
        try (LongStream stream = (LongStream)this.createStream();){
            OptionalLong optionalLong = stream.min();
            return optionalLong;
        }
    }

    @Override
    public OptionalLong max() {
        try (LongStream stream = (LongStream)this.createStream();){
            OptionalLong optionalLong = stream.max();
            return optionalLong;
        }
    }

    @Override
    public long count() {
        try (LongStream stream = (LongStream)this.createStream();){
            long l = stream.count();
            return l;
        }
    }

    @Override
    public OptionalDouble average() {
        try (LongStream stream = (LongStream)this.createStream();){
            OptionalDouble optionalDouble = stream.average();
            return optionalDouble;
        }
    }

    @Override
    public LongSummaryStatistics summaryStatistics() {
        try (LongStream stream = (LongStream)this.createStream();){
            LongSummaryStatistics longSummaryStatistics = stream.summaryStatistics();
            return longSummaryStatistics;
        }
    }

    @Override
    public boolean anyMatch(LongPredicate predicate) {
        try (LongStream stream = (LongStream)this.createStream();){
            boolean bl = stream.anyMatch(predicate);
            return bl;
        }
    }

    @Override
    public boolean allMatch(LongPredicate predicate) {
        try (LongStream stream = (LongStream)this.createStream();){
            boolean bl = stream.allMatch(predicate);
            return bl;
        }
    }

    @Override
    public boolean noneMatch(LongPredicate predicate) {
        try (LongStream stream = (LongStream)this.createStream();){
            boolean bl = stream.noneMatch(predicate);
            return bl;
        }
    }

    @Override
    public OptionalLong findFirst() {
        try (LongStream stream = (LongStream)this.createStream();){
            OptionalLong optionalLong = stream.findFirst();
            return optionalLong;
        }
    }

    @Override
    public OptionalLong findAny() {
        try (LongStream stream = (LongStream)this.createStream();){
            OptionalLong optionalLong = stream.findAny();
            return optionalLong;
        }
    }

    @Override
    public DoubleCacheStream asDoubleStream() {
        return this.mapToDouble(l -> l);
    }

    @Override
    public CacheStream<Long> boxed() {
        this.intermediateOperations.add(BoxedLongOperation.getInstance());
        return new LocalCacheStream<Long>(this);
    }

    @Override
    public PrimitiveIterator.OfLong iterator() {
        LongStream stream = (LongStream)this.createStream();
        this.onCloseRunnables.add(stream::close);
        return stream.iterator();
    }

    @Override
    public Spliterator.OfLong spliterator() {
        LongStream stream = (LongStream)this.createStream();
        this.onCloseRunnables.add(stream::close);
        return stream.spliterator();
    }

    @Override
    public LocalLongCacheStream sequentialDistribution() {
        return this;
    }

    @Override
    public LocalLongCacheStream parallelDistribution() {
        return this;
    }

    @Override
    public LocalLongCacheStream filterKeySegments(Set<Integer> segments) {
        return this.filterKeySegments(IntSets.from(segments));
    }

    @Override
    public LocalLongCacheStream filterKeySegments(IntSet segments) {
        this.segmentsToFilter = segments;
        return this;
    }

    @Override
    public LocalLongCacheStream filterKeys(Set<?> keys) {
        this.keysToFilter = keys;
        return this;
    }

    @Override
    public LocalLongCacheStream distributedBatchSize(int batchSize) {
        return this;
    }

    @Override
    public LocalLongCacheStream segmentCompletionListener(BaseCacheStream.SegmentCompletionListener listener) {
        return this;
    }

    @Override
    public LocalLongCacheStream disableRehashAware() {
        return this;
    }

    @Override
    public LocalLongCacheStream timeout(long timeout, TimeUnit unit) {
        return this;
    }
}

