package org.infinispan.distribution.util;

import java.util.Iterator;
import java.util.Map.Entry;

import org.infinispan.commons.util.IntSet;
import org.infinispan.distribution.LocalizedCacheTopology;

/**
 * Iterator implementation that shows a read only view of the provided iterator by only
 * allowing values that map to a given segment using the provided consistent hash.
 * <p>
 * This iterator is specifically used with the {@link ReadOnlySegmentAwareEntryCollection} so
 * that it will properly filter out entries by their key instead of by the entry instance
 *
 * @author wburns
 * @since 7.2
 */
public class ReadOnlySegmentAwareEntryIterator<K, V> extends ReadOnlySegmentAwareIterator<Entry<K, V>> {

   public ReadOnlySegmentAwareEntryIterator(Iterator<Entry<K, V>> iter, LocalizedCacheTopology topology, IntSet allowedSegments) {
      super(iter, topology, allowedSegments);
   }

   @Override
   protected boolean valueAllowed(Object obj) {
      if (obj instanceof Entry) {
         return super.valueAllowed(((Entry<?, ?>)obj).getKey());
      }
      return false;
   }
}
