/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.infinispan.Cache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.functional.ReadOnlyKeyCommand;
import org.infinispan.commands.functional.ReadOnlyManyCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.read.SizeCommand;
import org.infinispan.commands.tx.AbstractTransactionBoundaryCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.RemoveExpiredCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.RemoteTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.interceptors.DDAsyncInterceptor;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.jmx.JmxStatisticsExposer;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.concurrent.locks.LockReleasedException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="Transactions", description="Component that manages the cache's participation in JTA transactions.")
public class TxInterceptor<K, V>
extends DDAsyncInterceptor
implements JmxStatisticsExposer {
    private static final Log log = LogFactory.getLog(TxInterceptor.class);
    private final AtomicLong prepares = new AtomicLong(0L);
    private final AtomicLong commits = new AtomicLong(0L);
    private final AtomicLong rollbacks = new AtomicLong(0L);
    @Inject
    CommandsFactory commandsFactory;
    @Inject
    ComponentRef<Cache<K, V>> cache;
    @Inject
    RecoveryManager recoveryManager;
    @Inject
    TransactionTable txTable;
    @Inject
    KeyPartitioner keyPartitioner;
    private boolean useOnePhaseForAutoCommitTx;
    private boolean useVersioning;
    private boolean statisticsEnabled;

    private static void checkTransactionThrowable(CacheTransaction tx, Throwable throwable) {
        if (tx.isMarkedForRollback() && throwable instanceof LockReleasedException) {
            throw log.transactionAlreadyRolledBack(tx.getGlobalTransaction());
        }
    }

    @Start
    public void start() {
        this.statisticsEnabled = this.cacheConfiguration.statistics().enabled();
        this.useOnePhaseForAutoCommitTx = this.cacheConfiguration.transaction().use1PcForAutoCommitTransactions();
        this.useVersioning = Configurations.isTxVersioned(this.cacheConfiguration);
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        return this.handlePrepareCommand(ctx, command);
    }

    private Object handlePrepareCommand(TxInvocationContext<?> ctx, PrepareCommand command) {
        ((AbstractCacheTransaction)ctx.getCacheTransaction()).freezeModifications();
        if (this.statisticsEnabled) {
            this.prepares.incrementAndGet();
        }
        if (!ctx.isOriginLocal()) {
            ((RemoteTransaction)ctx.getCacheTransaction()).setLookedUpEntriesTopology(command.getTopologyId());
            Object verifyResult = this.invokeNextAndHandle(ctx, command, (rCtx, rCommand, rv, throwable) -> {
                if (!rCtx.isOriginLocal()) {
                    return this.verifyRemoteTransaction((RemoteTxInvocationContext)rCtx, (AbstractTransactionBoundaryCommand)rCommand, rv, throwable);
                }
                return TxInterceptor.valueOrException(rv, throwable);
            });
            return TxInterceptor.makeStage(verifyResult).thenAccept(ctx, command, (rCtx, prepareCommand, rv) -> {
                if (prepareCommand.isOnePhaseCommit()) {
                    this.txTable.remoteTransactionCommitted(prepareCommand.getGlobalTransaction(), true);
                } else {
                    this.txTable.remoteTransactionPrepared(prepareCommand.getGlobalTransaction());
                }
            });
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (!ctx.isOriginLocal()) {
            GlobalTransaction gtx = ctx.getGlobalTransaction();
            if (this.txTable.isTransactionCompleted(gtx)) {
                if (log.isTraceEnabled()) {
                    log.tracef("Transaction %s already completed, skipping commit", gtx);
                }
                return null;
            }
            InvocationStage replayStage = this.replayRemoteTransactionIfNeeded((RemoteTxInvocationContext)ctx, command.getTopologyId());
            if (replayStage != null) {
                return replayStage.andHandle(ctx, command, (rCtx, rCommand, rv, t) -> this.finishCommit((TxInvocationContext)rCtx, rCommand));
            }
            return this.finishCommit(ctx, command);
        }
        return this.finishCommit(ctx, command);
    }

    private Object finishCommit(TxInvocationContext<?> ctx, VisitableCommand command) {
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        if (this.statisticsEnabled) {
            this.commits.incrementAndGet();
        }
        return this.invokeNextThenAccept(ctx, command, (rCtx, rCommand, rv) -> {
            if (!rCtx.isOriginLocal()) {
                this.txTable.remoteTransactionCommitted(gtx, false);
            }
        });
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (this.statisticsEnabled) {
            this.rollbacks.incrementAndGet();
        }
        if (!ctx.isOriginLocal()) {
            this.txTable.remoteTransactionRollback(command.getGlobalTransaction());
        }
        return this.invokeNextAndFinally(ctx, command, (rCtx, rCommand, rv, t) -> {
            if (this.recoveryManager != null) {
                GlobalTransaction gtx = rCommand.getGlobalTransaction();
                this.recoveryManager.removeRecoveryInformation(gtx.getXid());
            }
        });
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        this.enlistIfNeeded(ctx);
        if (ctx.isOriginLocal()) {
            command.setGlobalTransaction(ctx.getGlobalTransaction());
        }
        return this.invokeNextAndHandle(ctx, command, (rCtx, rCommand, rv, throwable) -> {
            if (!rCtx.isOriginLocal()) {
                return this.verifyRemoteTransaction((RemoteTxInvocationContext)rCtx, (AbstractTransactionBoundaryCommand)rCommand, rv, throwable);
            }
            TxInterceptor.checkTransactionThrowable(((TxInvocationContext)rCtx).getCacheTransaction(), throwable);
            return TxInterceptor.valueOrException(rv, throwable);
        });
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitRemoveExpiredCommand(InvocationContext ctx, RemoveExpiredCommand command) {
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitSizeCommand(InvocationContext ctx, SizeCommand command) throws Throwable {
        if (!ctx.isOriginLocal() || !ctx.isInTxScope()) {
            return this.invokeNext(ctx, command);
        }
        this.enlistIfNeeded(ctx);
        if (ctx.isInTxScope() && ctx.lookedUpEntriesCount() > 0) {
            command.addFlags(FlagBitSets.SKIP_SIZE_OPTIMIZATION);
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitKeySetCommand(InvocationContext ctx, KeySetCommand command) throws Throwable {
        if (ctx.isOriginLocal() && ctx.isInTxScope()) {
            this.enlistIfNeeded(ctx);
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitEntrySetCommand(InvocationContext ctx, EntrySetCommand command) throws Throwable {
        if (ctx.isOriginLocal() && ctx.isInTxScope()) {
            this.enlistIfNeeded(ctx);
        }
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand invalidateCommand) throws Throwable {
        return this.handleWriteCommand(ctx, invalidateCommand);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        this.enlistIfNeeded(ctx);
        return this.invokeNext(ctx, command);
    }

    @Override
    public final Object visitGetCacheEntryCommand(InvocationContext ctx, GetCacheEntryCommand command) throws Throwable {
        this.enlistIfNeeded(ctx);
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitGetAllCommand(InvocationContext ctx, GetAllCommand command) throws Throwable {
        this.enlistIfNeeded(ctx);
        return this.invokeNext(ctx, command);
    }

    private void enlistIfNeeded(InvocationContext ctx) throws SystemException {
        if (TxInterceptor.shouldEnlist(ctx)) {
            assert (ctx instanceof LocalTxInvocationContext);
            this.enlist((LocalTxInvocationContext)ctx);
        }
    }

    @Override
    public Object visitReadOnlyKeyCommand(InvocationContext ctx, ReadOnlyKeyCommand command) throws Throwable {
        this.enlistIfNeeded(ctx);
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitReadOnlyManyCommand(InvocationContext ctx, ReadOnlyManyCommand command) throws Throwable {
        this.enlistIfNeeded(ctx);
        return this.invokeNext(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    private Object handleWriteCommand(InvocationContext ctx, WriteCommand command) throws Throwable {
        if (TxInterceptor.shouldEnlist(ctx)) {
            boolean implicitWith1Pc;
            assert (ctx instanceof LocalTxInvocationContext);
            LocalTransaction localTransaction = this.enlist((LocalTxInvocationContext)ctx);
            boolean bl = implicitWith1Pc = this.useOnePhaseForAutoCommitTx && localTransaction.isImplicitTransaction();
            if (implicitWith1Pc) {
                command.addFlags(FlagBitSets.SKIP_LOCKING);
            }
        }
        return this.invokeNextAndFinally(ctx, command, (rCtx, writeCommand, rv, t) -> {
            if (t != null && !(t instanceof OutdatedTopologyException) && rCtx.isOriginLocal() && rCtx.isInTxScope() && !writeCommand.hasAnyFlag(FlagBitSets.FAIL_SILENTLY)) {
                TxInvocationContext txCtx = (TxInvocationContext)rCtx;
                TxInterceptor.checkTransactionThrowable(txCtx.getCacheTransaction(), t);
                txCtx.getTransaction().setRollbackOnly();
            }
            if (t == null && TxInterceptor.shouldEnlist(rCtx) && writeCommand.isSuccessful()) {
                assert (rCtx instanceof LocalTxInvocationContext);
                ((LocalTransaction)((LocalTxInvocationContext)rCtx).getCacheTransaction()).addModification((WriteCommand)writeCommand);
            }
        });
    }

    private LocalTransaction enlist(LocalTxInvocationContext ctx) throws SystemException {
        Transaction transaction = ctx.getTransaction();
        if (transaction == null) {
            throw new IllegalStateException("This should only be called in an tx scope");
        }
        LocalTransaction localTransaction = (LocalTransaction)ctx.getCacheTransaction();
        if (localTransaction.isFromStateTransfer()) {
            return localTransaction;
        }
        int status = transaction.getStatus();
        if (this.isNotValid(status)) {
            if (!localTransaction.isEnlisted()) {
                this.txTable.removeLocalTransaction(localTransaction);
            }
            throw new IllegalStateException("Transaction " + String.valueOf(transaction) + " is not in a valid state to be invoking cache operations on.");
        }
        this.txTable.enlist(transaction, localTransaction);
        return localTransaction;
    }

    private boolean isNotValid(int status) {
        return status != 0 && status != 7 && status != 8;
    }

    private static boolean shouldEnlist(InvocationContext ctx) {
        return ctx.isInTxScope() && ctx.isOriginLocal();
    }

    @Override
    public boolean getStatisticsEnabled() {
        return this.isStatisticsEnabled();
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        this.statisticsEnabled = enabled;
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset Statistics")
    public void resetStatistics() {
        this.prepares.set(0L);
        this.commits.set(0L);
        this.rollbacks.set(0L);
    }

    @ManagedAttribute(displayName="Statistics enabled", dataType=DataType.TRAIT, writable=true)
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @ManagedAttribute(description="Number of transaction prepares performed since last reset", displayName="Prepares", measurementType=MeasurementType.TRENDSUP)
    public long getPrepares() {
        return this.prepares.get();
    }

    @ManagedAttribute(description="Number of transaction commits performed since last reset", displayName="Commits", measurementType=MeasurementType.TRENDSUP)
    public long getCommits() {
        return this.commits.get();
    }

    @ManagedAttribute(description="Number of transaction rollbacks performed since last reset", displayName="Rollbacks", measurementType=MeasurementType.TRENDSUP)
    public long getRollbacks() {
        return this.rollbacks.get();
    }

    private Object verifyRemoteTransaction(RemoteTxInvocationContext ctx, AbstractTransactionBoundaryCommand command, Object rv, Throwable throwable) throws Throwable {
        boolean alreadyCompleted;
        GlobalTransaction globalTransaction = command.getGlobalTransaction();
        boolean bl = alreadyCompleted = this.txTable.isTransactionCompleted(globalTransaction) || !this.txTable.containRemoteTx(globalTransaction);
        if (log.isTraceEnabled()) {
            log.tracef("Verifying transaction: alreadyCompleted=%s", alreadyCompleted);
        }
        if (alreadyCompleted) {
            if (log.isTraceEnabled()) {
                log.tracef("Rolling back remote transaction %s because it was already completed", globalTransaction);
            }
            this.txTable.markTransactionCompleted(globalTransaction, false);
            RollbackCommand rollback = this.commandsFactory.buildRollbackCommand(command.getGlobalTransaction());
            return this.invokeNextAndFinally(ctx, rollback, (rCtx, rCommand, rv1, throwable1) -> {
                RemoteTransaction remoteTx = (RemoteTransaction)((TxInvocationContext)rCtx).getCacheTransaction();
                remoteTx.markForRollback(true);
                this.txTable.removeRemoteTransaction(globalTransaction);
            });
        }
        return TxInterceptor.valueOrException(rv, throwable);
    }

    private InvocationStage replayRemoteTransactionIfNeeded(RemoteTxInvocationContext ctx, int topologyId) throws Throwable {
        RemoteTransaction remoteTx = (RemoteTransaction)ctx.getCacheTransaction();
        if (log.isTraceEnabled()) {
            log.tracef("Remote tx topology id %d and command topology is %d", remoteTx.lookedUpEntriesTopology(), topologyId);
        }
        if (remoteTx.lookedUpEntriesTopology() < topologyId) {
            PrepareCommand prepareCommand = this.useVersioning ? this.commandsFactory.buildVersionedPrepareCommand(ctx.getGlobalTransaction(), ctx.getModifications(), false) : this.commandsFactory.buildPrepareCommand(ctx.getGlobalTransaction(), ctx.getModifications(), false);
            prepareCommand.markTransactionAsRemote(true);
            prepareCommand.setOrigin(ctx.getOrigin());
            if (log.isTraceEnabled()) {
                log.tracef("Replaying the transactions received as a result of state transfer %s", prepareCommand);
            }
            return TxInterceptor.makeStage(this.handlePrepareCommand(ctx, prepareCommand));
        }
        return null;
    }
}

