/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import javax.transaction.Transaction;
import net.jcip.annotations.GuardedBy;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheTopology;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class LocalTransaction
extends AbstractCacheTransaction {
    private static final Log log = LogFactory.getLog(LocalTransaction.class);
    private Set<Address> remoteLockedNodes;
    private final Transaction transaction;
    private final boolean implicitTransaction;
    private volatile boolean isFromRemoteSite;
    private boolean prepareSent;
    @GuardedBy(value="this")
    private Map<Object, CompletionStage<IracMetadata>> iracMetadata;

    public LocalTransaction(Transaction transaction, GlobalTransaction tx, boolean implicitTransaction, int topologyId, long txCreationTime) {
        super(tx, topologyId, txCreationTime);
        this.transaction = transaction;
        this.implicitTransaction = implicitTransaction;
    }

    public final void addModification(WriteCommand mod) {
        if (log.isTraceEnabled()) {
            log.tracef("Adding modification %s. Mod list is %s", mod, this.modifications);
        }
        this.modifications.append(mod);
    }

    public void locksAcquired(Collection<Address> nodes) {
        if (log.isTraceEnabled()) {
            log.tracef("Adding remote locks on %s. Remote locks are %s", nodes, this.remoteLockedNodes);
        }
        if (this.remoteLockedNodes == null) {
            this.remoteLockedNodes = new HashSet<Address>(nodes);
        } else {
            this.remoteLockedNodes.addAll(nodes);
        }
    }

    public Collection<Address> getRemoteLocksAcquired() {
        if (this.remoteLockedNodes == null) {
            return Collections.emptySet();
        }
        return this.remoteLockedNodes;
    }

    public void clearRemoteLocksAcquired() {
        if (this.remoteLockedNodes != null) {
            this.remoteLockedNodes.clear();
        }
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    @Override
    public Map<Object, CacheEntry> getLookedUpEntries() {
        return this.lookedUpEntries == null ? Collections.emptyMap() : this.lookedUpEntries;
    }

    public boolean isImplicitTransaction() {
        return this.implicitTransaction;
    }

    @Override
    public void putLookedUpEntry(Object key, CacheEntry e) {
        this.checkIfRolledBack();
        if (this.lookedUpEntries == null) {
            this.lookedUpEntries = new HashMap(4);
        }
        this.lookedUpEntries.put(key, e);
    }

    @Override
    public void putLookedUpEntries(Map<Object, CacheEntry> entries) {
        this.checkIfRolledBack();
        if (this.lookedUpEntries == null) {
            this.lookedUpEntries = new HashMap<Object, CacheEntry>(entries);
        } else {
            this.lookedUpEntries.putAll(entries);
        }
    }

    public boolean isReadOnly() {
        return this.modifications.isEmpty();
    }

    public abstract boolean isEnlisted();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalTransaction that = (LocalTransaction)o;
        return this.tx.getId() == that.tx.getId();
    }

    public int hashCode() {
        long id = this.tx.getId();
        return (int)(id ^ id >>> 32);
    }

    public String toString() {
        return "LocalTransaction{remoteLockedNodes=" + String.valueOf(this.remoteLockedNodes) + ", isMarkedForRollback=" + this.isMarkedForRollback() + ", lockedKeys=" + String.valueOf(this.getLockedKeys()) + ", backupKeyLocks=" + String.valueOf(this.getBackupLockedKeys()) + ", topologyId=" + this.topologyId + ", stateTransferFlag=" + String.valueOf((Object)this.getStateTransferFlag()) + "} " + super.toString();
    }

    @Override
    public void setStateTransferFlag(Flag stateTransferFlag) {
        if (this.getStateTransferFlag() == null && (stateTransferFlag == Flag.PUT_FOR_STATE_TRANSFER || stateTransferFlag == Flag.PUT_FOR_X_SITE_STATE_TRANSFER)) {
            this.internalSetStateTransferFlag(stateTransferFlag);
        }
    }

    public boolean isFromRemoteSite() {
        return this.isFromRemoteSite;
    }

    public void setFromRemoteSite(boolean fromRemoteSite) {
        this.isFromRemoteSite = fromRemoteSite;
    }

    public Collection<Address> getCommitNodes(Collection<Address> recipients, CacheTopology cacheTopology) {
        int currentTopologyId = cacheTopology.getTopologyId();
        List<Address> members = cacheTopology.getMembers();
        if (log.isTraceEnabled()) {
            log.tracef("getCommitNodes recipients=%s, currentTopologyId=%s, members=%s, txTopologyId=%s", new Object[]{recipients, currentTopologyId, members, this.getTopologyId()});
        }
        if (recipients == null) {
            return null;
        }
        HashSet<Address> allRecipients = new HashSet<Address>(this.getRemoteLocksAcquired());
        allRecipients.addAll(recipients);
        if (log.isTraceEnabled()) {
            log.tracef("The merged list of nodes to send commit/rollback is %s", allRecipients);
        }
        return allRecipients;
    }

    public final void markPrepareSent() {
        this.prepareSent = true;
    }

    public final boolean isPrepareSent() {
        return this.prepareSent;
    }

    public synchronized boolean hasIracMetadata(Object key) {
        return this.iracMetadata != null && this.iracMetadata.containsKey(key);
    }

    public synchronized void storeIracMetadata(Object key, CompletionStage<IracMetadata> metadata) {
        if (this.iracMetadata == null) {
            this.iracMetadata = new HashMap<Object, CompletionStage<IracMetadata>>();
        }
        CompletionStage<IracMetadata> old = this.iracMetadata.put(key, metadata);
        assert (old == null) : "[IRAC] irac metadata replaced!";
    }

    public synchronized CompletionStage<IracMetadata> getIracMetadata(Object key) {
        return this.iracMetadata == null ? null : this.iracMetadata.get(key);
    }
}

