/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.AbstractDelegatingAdvancedCache;
import org.infinispan.cache.impl.CacheImpl;
import org.infinispan.cache.impl.EncoderCache;
import org.infinispan.cache.impl.SimpleCacheImpl;
import org.infinispan.cache.impl.StatsCollectingCache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.context.Flag;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.ImmutableContext;
import org.infinispan.distribution.Ownership;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.encoding.DataConversion;
import org.infinispan.eviction.impl.PassivationManager;
import org.infinispan.eviction.impl.PassivationManagerStub;
import org.infinispan.expiration.impl.InternalExpirationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.impl.CacheMgmtInterceptor;
import org.infinispan.jmx.CacheJmxRegistration;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.metrics.impl.CacheMetricsRegistration;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.cluster.ClusterEventManager;
import org.infinispan.notifications.cachelistener.cluster.impl.ClusterEventManagerStub;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.transaction.xa.recovery.RecoveryAdminOperations;
import org.infinispan.upgrade.RollingUpgradeManager;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.xsite.XSiteAdminOperations;

public class InternalCacheFactory<K, V> {
    private ComponentRegistry componentRegistry;
    private BasicComponentRegistry basicComponentRegistry;

    public Cache<K, V> createCache(Configuration configuration, GlobalComponentRegistry globalComponentRegistry, String cacheName) throws CacheConfigurationException {
        try {
            if (configuration.simpleCache()) {
                return this.createSimpleCache(configuration, globalComponentRegistry, cacheName);
            }
            return this.createAndWire(configuration, globalComponentRegistry, cacheName);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private AdvancedCache<K, V> createAndWire(Configuration configuration, GlobalComponentRegistry globalComponentRegistry, String cacheName) {
        StreamingMarshaller marshaller = globalComponentRegistry.getOrCreateComponent(StreamingMarshaller.class, "org.infinispan.marshaller.internal");
        AdvancedCache cache = new CacheImpl(cacheName);
        if (configuration.clustering().cacheMode().isReplicated() && !configuration.persistence().usingStores() && !configuration.transaction().transactionMode().isTransactional() && configuration.clustering().stateTransfer().awaitInitialTransfer() && configuration.clustering().hash().capacityFactor() != 0.0f && !globalComponentRegistry.getGlobalConfiguration().isZeroCapacityNode()) {
            cache = new GetReplCache(new CacheImpl(cacheName));
            if (configuration.statistics().available()) {
                cache = new StatsCache(cache);
            }
            if (configuration.clustering().partitionHandling().whenSplit() != PartitionHandling.ALLOW_READ_WRITES) {
                cache = new PartitionHandlingCache(cache);
            }
        }
        AdvancedCache encodedCache = this.buildEncodingCache(cache);
        this.bootstrap(cacheName, encodedCache, configuration, globalComponentRegistry, marshaller);
        if (marshaller != null) {
            this.componentRegistry.wireDependencies(marshaller, false);
        }
        return encodedCache;
    }

    private AdvancedCache<K, V> buildEncodingCache(AdvancedCache<K, V> wrappedCache) {
        DataConversion keyDataConversion = DataConversion.newKeyDataConversion();
        DataConversion valueDataConversion = DataConversion.newValueDataConversion();
        return new EncoderCache<K, V>(wrappedCache, null, null, keyDataConversion, valueDataConversion);
    }

    private AdvancedCache<K, V> createSimpleCache(Configuration configuration, GlobalComponentRegistry globalComponentRegistry, String cacheName) {
        AdvancedCache cache = configuration.statistics().available() ? this.buildEncodingCache(new StatsCollectingCache(cacheName)) : this.buildEncodingCache(new SimpleCacheImpl(cacheName));
        this.componentRegistry = new SimpleComponentRegistry(cacheName, configuration, cache, globalComponentRegistry);
        this.basicComponentRegistry = this.componentRegistry.getComponent(BasicComponentRegistry.class);
        this.basicComponentRegistry.registerAlias(Cache.class.getName(), AdvancedCache.class.getName(), AdvancedCache.class);
        this.basicComponentRegistry.registerComponent(AdvancedCache.class, cache, false);
        this.componentRegistry.registerComponent((Object)new CacheJmxRegistration(), CacheJmxRegistration.class);
        this.componentRegistry.registerComponent((Object)new CacheMetricsRegistration(), CacheMetricsRegistration.class);
        this.componentRegistry.registerComponent((Object)new RollingUpgradeManager(), RollingUpgradeManager.class);
        return cache;
    }

    private void bootstrap(String cacheName, AdvancedCache<?, ?> cache, Configuration configuration, GlobalComponentRegistry globalComponentRegistry, StreamingMarshaller globalMarshaller) {
        this.componentRegistry = new ComponentRegistry(cacheName, configuration, cache, globalComponentRegistry, globalComponentRegistry.getClassLoader());
        this.basicComponentRegistry = this.componentRegistry.getComponent(BasicComponentRegistry.class);
        this.basicComponentRegistry.registerAlias(Cache.class.getName(), AdvancedCache.class.getName(), AdvancedCache.class);
        this.basicComponentRegistry.registerComponent(AdvancedCache.class.getName(), cache, false);
        this.componentRegistry.registerComponent(new CacheJmxRegistration(), CacheJmxRegistration.class.getName(), true);
        this.componentRegistry.registerComponent(new CacheMetricsRegistration(), CacheMetricsRegistration.class.getName(), true);
        if (configuration.transaction().recovery().enabled()) {
            this.componentRegistry.registerComponent(new RecoveryAdminOperations(), RecoveryAdminOperations.class.getName(), true);
        }
        if (configuration.sites().hasBackups()) {
            this.componentRegistry.registerComponent(new XSiteAdminOperations(), XSiteAdminOperations.class.getName(), true);
        }
        this.componentRegistry.registerComponent(new RollingUpgradeManager(), RollingUpgradeManager.class.getName(), true);
    }

    private static void assertKeyNotNull(Object key) {
        Objects.requireNonNull(key, "Null keys are not supported!");
    }

    private static void checkCanRun(Cache<?, ?> cache, String cacheName) {
        ComponentStatus status = cache.getStatus();
        if (status == ComponentStatus.FAILED || status == ComponentStatus.TERMINATED) {
            throw Log.CONTAINER.cacheIsTerminated(cacheName, status.toString());
        }
    }

    static class GetReplCache<K, V>
    extends AbstractGetAdvancedCache<K, V, GetReplCache<K, V>> {
        @Inject
        CacheNotifier<K, V> cacheNotifier;

        private GetReplCache(AdvancedCache<K, V> cache) {
            super(cache);
        }

        @Override
        public AdvancedCache rewrap(AdvancedCache newDelegate) {
            GetReplCache<K, V> newCache = new GetReplCache<K, V>(newDelegate);
            newCache.internalWire(this);
            return newCache;
        }

        @Override
        protected void internalWire(GetReplCache<K, V> cache) {
            this.cacheNotifier = cache.cacheNotifier;
            super.internalWire(cache);
        }

        @Override
        public V get(Object key) {
            Object value = super.get(key);
            if (value != null) {
                CompletionStages.join(this.cacheNotifier.notifyCacheEntryVisited(key, value, true, ImmutableContext.INSTANCE, null));
                CompletionStages.join(this.cacheNotifier.notifyCacheEntryVisited(key, value, false, ImmutableContext.INSTANCE, null));
            }
            return value;
        }
    }

    static class StatsCache<K, V>
    extends AbstractGetAdvancedCache<K, V, StatsCache<K, V>> {
        @Inject
        TimeService timeService;
        private CacheMgmtInterceptor interceptor;

        public StatsCache(AdvancedCache<K, V> cache) {
            super(cache);
        }

        @Override
        public AdvancedCache rewrap(AdvancedCache newDelegate) {
            StatsCache<K, V> newCache = new StatsCache<K, V>(newDelegate);
            newCache.internalWire(this);
            newCache.interceptorStart();
            return newCache;
        }

        @Override
        protected void internalWire(StatsCache<K, V> cache) {
            this.timeService = cache.timeService;
            super.internalWire(cache);
        }

        private void interceptorStart() {
            this.interceptor = this.cache.getAsyncInterceptorChain().findInterceptorWithClass(CacheMgmtInterceptor.class);
        }

        @Override
        public V get(Object key) {
            Object value;
            if (this.interceptor == null) {
                this.interceptorStart();
            }
            if (this.interceptor.getStatisticsEnabled()) {
                long beginTime = this.timeService.time();
                value = this.cache.get(key);
                this.interceptor.addDataRead(value != null, beginTime, Ownership.PRIMARY);
            } else {
                value = this.cache.get(key);
            }
            return (V)value;
        }
    }

    static class PartitionHandlingCache<K, V>
    extends AbstractGetAdvancedCache<K, V, PartitionHandlingCache<K, V>> {
        @Inject
        PartitionHandlingManager manager;
        private final long bitFlags;

        public PartitionHandlingCache(AdvancedCache<K, V> cache) {
            this(cache, 0L);
        }

        private PartitionHandlingCache(AdvancedCache<K, V> cache, long bitFlags) {
            super(cache);
            this.bitFlags = bitFlags;
        }

        @Override
        public AdvancedCache rewrap(AdvancedCache newDelegate) {
            PartitionHandlingCache<K, V> newCache = new PartitionHandlingCache<K, V>(newDelegate, this.bitFlags);
            newCache.internalWire(this);
            return newCache;
        }

        @Override
        protected void internalWire(PartitionHandlingCache<K, V> cache) {
            this.manager = cache.manager;
            super.internalWire(cache);
        }

        @Override
        public V get(Object key) {
            Object value = this.cache.get(key);
            if (!EnumUtil.containsAny((long)this.bitFlags, (long)(FlagBitSets.CACHE_MODE_LOCAL | FlagBitSets.SKIP_OWNERSHIP_CHECK))) {
                this.manager.checkRead(key, this.bitFlags);
            }
            return (V)value;
        }

        @Override
        public AdvancedCache<K, V> withFlags(Flag ... flags) {
            long newFlags = EnumUtil.bitSetOf((Enum[])flags);
            long updatedFlags = EnumUtil.mergeBitSets((long)this.bitFlags, (long)newFlags);
            if (this.bitFlags != updatedFlags) {
                PartitionHandlingCache newCache = new PartitionHandlingCache(super.withFlags(flags), updatedFlags);
                newCache.internalWire(this);
                return newCache;
            }
            return this;
        }

        @Override
        public AdvancedCache<K, V> withFlags(Collection<Flag> flags) {
            long newFlags = EnumUtil.bitSetOf(flags);
            long updatedFlags = EnumUtil.mergeBitSets((long)this.bitFlags, (long)newFlags);
            if (this.bitFlags != updatedFlags) {
                PartitionHandlingCache newCache = new PartitionHandlingCache(super.withFlags(flags), updatedFlags);
                newCache.internalWire(this);
                return newCache;
            }
            return this;
        }

        @Override
        public AdvancedCache<K, V> noFlags() {
            if (this.bitFlags != 0L) {
                PartitionHandlingCache newCache = new PartitionHandlingCache(super.noFlags(), 0L);
                newCache.internalWire(this);
                return newCache;
            }
            return this;
        }
    }

    @SurvivesRestarts
    class SimpleComponentRegistry<K, V>
    extends ComponentRegistry {
        public SimpleComponentRegistry(String cacheName, Configuration configuration, AdvancedCache<K, V> cache, GlobalComponentRegistry globalComponentRegistry) {
            super(cacheName, configuration, cache, globalComponentRegistry, globalComponentRegistry.getClassLoader());
        }

        @Override
        protected void bootstrapComponents() {
            this.registerComponent(new ClusterEventManagerStub(), ClusterEventManager.class);
            this.registerComponent((Object)new PassivationManagerStub(), PassivationManager.class);
        }

        @Override
        public void cacheComponents() {
            this.getOrCreateComponent(InternalExpirationManager.class);
        }
    }

    @Scope(value=Scopes.NAMED_CACHE)
    static abstract class AbstractGetAdvancedCache<K, V, T extends AbstractGetAdvancedCache<K, V, T>>
    extends AbstractDelegatingAdvancedCache<K, V> {
        @Inject
        protected ComponentRegistry componentRegistry;
        @Inject
        InternalExpirationManager<K, V> expirationManager;
        @Inject
        KeyPartitioner keyPartitioner;

        public AbstractGetAdvancedCache(AdvancedCache<K, V> cache) {
            super(cache);
        }

        @Inject
        public void wireRealCache() {
            this.componentRegistry.wireDependencies(this.cache, false);
        }

        protected void internalWire(T cache) {
            this.componentRegistry = ((AbstractGetAdvancedCache)cache).componentRegistry;
            this.expirationManager = ((AbstractGetAdvancedCache)cache).expirationManager;
            this.keyPartitioner = ((AbstractGetAdvancedCache)cache).keyPartitioner;
            this.wireRealCache();
        }

        @Override
        public InternalDataContainer<K, V> getDataContainer() {
            return (InternalDataContainer)super.getDataContainer();
        }

        @Override
        public V get(Object key) {
            CacheEntry ice = this.getCacheEntry(key);
            if (ice != null) {
                return ice.getValue();
            }
            return null;
        }

        @Override
        public V getOrDefault(Object key, V defaultValue) {
            V value = this.get(key);
            return value != null ? value : defaultValue;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.get(key) != null;
        }

        @Override
        public InternalCacheEntry<K, V> getCacheEntry(Object key) {
            CompletionStage<Boolean> stage;
            InternalCacheFactory.assertKeyNotNull(key);
            InternalCacheFactory.checkCanRun(this.cache, this.cache.getName());
            int segment = this.keyPartitioner.getSegment(key);
            InternalCacheEntry ice = this.getDataContainer().peek(segment, key);
            if (ice != null && ice.canExpire() && CompletionStages.join(stage = this.expirationManager.handlePossibleExpiration(ice, segment, false)).booleanValue()) {
                ice = null;
            }
            return ice;
        }
    }
}

