/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.rpc;

import java.util.concurrent.TimeUnit;
import org.infinispan.remoting.inboundhandler.DeliverOrder;

public class RpcOptions {
    private final long timeout;
    private final TimeUnit unit;
    private final DeliverOrder deliverOrder;

    public RpcOptions(DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("TimeUnit cannot be null");
        }
        if (deliverOrder == null) {
            throw new IllegalArgumentException("DeliverMode cannot be null");
        }
        this.timeout = timeout;
        this.unit = unit;
        this.deliverOrder = deliverOrder;
    }

    public long timeout() {
        return this.timeout;
    }

    public TimeUnit timeUnit() {
        return this.unit;
    }

    public DeliverOrder deliverOrder() {
        return this.deliverOrder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RpcOptions options = (RpcOptions)o;
        return this.timeout == options.timeout && this.deliverOrder == options.deliverOrder && this.unit == options.unit;
    }

    public int hashCode() {
        int result = (int)(this.timeout ^ this.timeout >>> 32);
        result = 31 * result + this.unit.hashCode();
        result = 31 * result + this.deliverOrder.hashCode();
        return result;
    }

    public String toString() {
        return "RpcOptions{timeout=" + this.timeout + ", unit=" + this.unit + ", deliverOrder=" + this.deliverOrder + "}";
    }
}

