/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.infinispan.Cache;
import org.infinispan.CacheCollection;
import org.infinispan.CacheSet;
import org.infinispan.api.APINonTxTest;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.data.Key;
import org.infinispan.util.function.SerializableBiFunction;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.APINonTxOffHeapTest")
public class APINonTxOffHeapTest
extends APINonTxTest {
    private StorageType storageType;

    public APINonTxOffHeapTest storageType(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    @Override
    protected String parameters() {
        return "[" + String.valueOf(this.storageType) + "]";
    }

    @Factory
    public Object[] factory() {
        return new Object[]{new APINonTxOffHeapTest().storageType(StorageType.BINARY), new APINonTxOffHeapTest().storageType(StorageType.OFF_HEAP)};
    }

    @Override
    protected void configure(ConfigurationBuilder builder) {
        builder.memory().storageType(this.storageType);
    }

    @Override
    @Test
    public void testRemoveMethodOfKeyValueEntryCollections() {
        String key1 = "1";
        String value1 = "one";
        String key2 = "2";
        String value2 = "two";
        String key3 = "3";
        String value3 = "three";
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("1", "one");
        m.put("2", "two");
        m.put("3", "three");
        this.cache.putAll(m);
        CacheSet keys = this.cache.keySet();
        keys.remove("1");
        this.assertCacheSize(2);
        CacheCollection values = this.cache.values();
        values.remove("two");
        this.assertCacheSize(1);
        CacheSet entries = this.cache.entrySet();
        entries.remove(TestingUtil.createMapEntry("3", "three"));
        this.assertCacheIsEmpty();
    }

    @Override
    public void testGetOrDefault() {
        this.cache.put((Object)"A", (Object)"B");
        AssertJUnit.assertEquals((Object)"K", (Object)this.cache.getOrDefault((Object)"Not there", (Object)"K"));
    }

    @Override
    public void testMerge() {
        this.cache.put((Object)"A", (Object)"B");
        this.cache.merge((Object)"A", (Object)"C", (SerializableBiFunction & Serializable)(oldValue, newValue) -> String.valueOf(oldValue) + String.valueOf(newValue));
        AssertJUnit.assertEquals((Object)"BC", (Object)this.cache.get((Object)"A"));
        this.cache.merge((Object)"A", (Object)"C", (SerializableBiFunction & Serializable)(oldValue, newValue) -> null);
        AssertJUnit.assertEquals(null, (Object)this.cache.get((Object)"A"));
        this.cache.merge((Object)"F", (Object)"42", (SerializableBiFunction & Serializable)(oldValue, newValue) -> String.valueOf(oldValue) + String.valueOf(newValue));
        AssertJUnit.assertEquals((Object)"42", (Object)this.cache.get((Object)"F"));
        this.cache.put((Object)"A", (Object)"B");
        RuntimeException mergeRaisedException = new RuntimeException("hi there");
        Exceptions.expectException(RuntimeException.class, (String)"hi there", () -> this.cache.merge((Object)"A", (Object)"C", (SerializableBiFunction & Serializable)(k, v) -> {
            throw mergeRaisedException;
        }));
    }

    @Override
    @Test
    public void testForEach() {
        this.cache.put((Object)"A", (Object)"B");
        this.cache.put((Object)"C", (Object)"D");
        ArrayList values = new ArrayList();
        BiConsumer<Object, Object> collectKeyValues = (k, v) -> values.add("hello_" + k.toString() + v.toString());
        this.cache.forEach(collectKeyValues);
        AssertJUnit.assertEquals((int)2, (int)values.size());
        Assert.assertTrue((boolean)values.contains("hello_AB"));
        Assert.assertTrue((boolean)values.contains("hello_CD"));
    }

    @Override
    public void testCompute() {
        BiFunction<Object, Object, String> mappingFunction = (k, v) -> "hello_" + String.valueOf(k) + ":" + String.valueOf(v);
        this.cache.put((Object)"es", (Object)"hola");
        AssertJUnit.assertEquals((Object)"hello_es:hola", (Object)this.cache.compute((Object)"es", mappingFunction));
        AssertJUnit.assertEquals((Object)"hello_es:hola", (Object)this.cache.get((Object)"es"));
        BiFunction<Object, Object, String> mappingForNotPresentKey = (k, v) -> "absent_" + String.valueOf(k) + ":" + String.valueOf(v);
        AssertJUnit.assertEquals((Object)"absent_fr:null", (Object)this.cache.compute((Object)"fr", mappingForNotPresentKey));
        AssertJUnit.assertEquals((Object)"absent_fr:null", (Object)this.cache.get((Object)"fr"));
        BiFunction<Object, Object, String> mappingToNull = (k, v) -> null;
        Assert.assertNull((Object)this.cache.compute((Object)"es", mappingToNull), (String)"mapping to null returns null");
        Assert.assertNull((Object)this.cache.get((Object)"es"), (String)"the key is removed");
        int cacheSizeBeforeNullValueCompute = this.cache.size();
        Assert.assertNull((Object)this.cache.compute((Object)"eus", mappingToNull), (String)"mapping to null returns null");
        Assert.assertNull((Object)this.cache.get((Object)"eus"), (String)"the key does not exist");
        AssertJUnit.assertEquals((int)cacheSizeBeforeNullValueCompute, (int)this.cache.size());
        RuntimeException computeRaisedException = new RuntimeException("hi there");
        BiFunction<Object, Object, String> mappingToException = (k, v) -> {
            throw computeRaisedException;
        };
        Exceptions.expectException(RuntimeException.class, (String)"hi there", () -> this.cache.compute((Object)"es", mappingToException));
    }

    @Override
    @Test
    public void testReplaceAll() {
        BiFunction<Object, Object, Object> mappingFunction = (k, v) -> "hello_" + String.valueOf(k) + ":" + String.valueOf(v);
        this.cache.put((Object)"es", (Object)"hola");
        this.cache.put((Object)"cz", (Object)"ahoj");
        this.cache.replaceAll(mappingFunction);
        AssertJUnit.assertEquals((Object)"hello_es:hola", (Object)this.cache.get((Object)"es"));
        AssertJUnit.assertEquals((Object)"hello_cz:ahoj", (Object)this.cache.get((Object)"cz"));
        BiFunction<Object, Object, String> mappingToNull = (k, v) -> null;
        Exceptions.expectException(NullPointerException.class, () -> this.cache.replaceAll(mappingToNull));
        AssertJUnit.assertEquals((Object)"hello_es:hola", (Object)this.cache.get((Object)"es"));
        AssertJUnit.assertEquals((Object)"hello_cz:ahoj", (Object)this.cache.get((Object)"cz"));
    }

    public void testCustomObjectKey() {
        Key ck = new Key("a");
        Assert.assertNull((Object)this.cache.get((Object)ck));
        this.cache.put((Object)ck, (Object)"blah");
        AssertJUnit.assertEquals((Object)"blah", (Object)this.cache.get((Object)ck));
    }

    @Override
    @Test(enabled=false)
    public void testLockedStreamSetValue() {
        super.testLockedStreamSetValue();
    }

    @Override
    @Test(enabled=false)
    public void testLockedStreamWithinLockedStream() {
        super.testLockedStreamWithinLockedStream();
    }

    @Override
    @Test(enabled=false)
    public void testLockedStreamActuallyLocks(BiConsumer<Cache<Object, Object>, CacheEntry<Object, Object>> consumer, boolean forEachOrInvokeAll) throws Throwable {
        super.testLockedStreamActuallyLocks(consumer, forEachOrInvokeAll);
    }

    @Override
    @Test(enabled=false)
    public void testLockedStreamInvokeAllFilteredSet() {
        super.testLockedStreamInvokeAllFilteredSet();
    }

    @Override
    @Test(enabled=false)
    public void testLockedStreamInvokeAllPut() {
        super.testLockedStreamInvokeAllPut();
    }

    private void assertCacheSize(int expectedSize) {
        AssertJUnit.assertEquals((int)expectedSize, (int)this.cache.size());
        AssertJUnit.assertEquals((int)expectedSize, (int)this.cache.keySet().size());
        AssertJUnit.assertEquals((int)expectedSize, (int)this.cache.values().size());
        AssertJUnit.assertEquals((int)expectedSize, (int)this.cache.entrySet().size());
        boolean isEmpty = expectedSize == 0;
        AssertJUnit.assertEquals((boolean)isEmpty, (boolean)this.cache.isEmpty());
        AssertJUnit.assertEquals((boolean)isEmpty, (boolean)this.cache.keySet().isEmpty());
        AssertJUnit.assertEquals((boolean)isEmpty, (boolean)this.cache.values().isEmpty());
        AssertJUnit.assertEquals((boolean)isEmpty, (boolean)this.cache.entrySet().isEmpty());
    }

    private void assertCacheIsEmpty() {
        this.assertCacheSize(0);
    }
}

