/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.ConcurrentOperationsTest")
public class ConcurrentOperationsTest
extends MultipleCacheManagersTest {
    protected final int threads;
    protected final int nodes;
    protected final int operations;
    protected final CacheMode cacheMode;

    protected ConcurrentOperationsTest(CacheMode cacheMode, int threads, int nodes, int operations) {
        this.cacheMode = cacheMode;
        this.threads = threads;
        this.nodes = nodes;
        this.operations = operations;
    }

    public ConcurrentOperationsTest() {
        this(CacheMode.DIST_SYNC, 2, 2, 4);
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder dcc = ConcurrentOperationsTest.getDefaultClusteredCacheConfig(this.cacheMode, false);
        dcc.clustering().l1().disable();
        this.createClusteredCaches(this.nodes, dcc);
    }

    public void testNoTimeout() throws Throwable {
        this.runTest(false);
    }

    public void testNoTimeoutAndCorrectness() throws Throwable {
        this.runTest(true);
    }

    private void runTest(final boolean checkCorrectness) throws Throwable {
        final CyclicBarrier barrier = new CyclicBarrier(this.threads);
        final Random rnd = new Random();
        final AtomicBoolean correctness = new AtomicBoolean(Boolean.TRUE);
        ArrayList<Future<Boolean>> result = new ArrayList<Future<Boolean>>();
        int t = 0;
        while (t < this.threads) {
            final int n = t++;
            Future<Boolean> f = this.fork(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    try {
                        for (int i = 0; i < ConcurrentOperationsTest.this.operations; ++i) {
                            this.barrier();
                            this.executeOperation(i);
                            this.barrier();
                            this.checkCorrectness(i);
                            this.printProgress(i);
                            if (correctness.get()) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Throwable t) {
                        correctness.set(false);
                        throw new Exception(t);
                    }
                    return correctness.get();
                }

                private void printProgress(int i) {
                    if (i % 100 == 0) {
                        ConcurrentOperationsTest.this.print("Progressing  = " + i);
                    }
                }

                private void executeOperation(int iteration) {
                    int node = rnd.nextInt(ConcurrentOperationsTest.this.nodes - 1);
                    switch (rnd.nextInt(4)) {
                        case 0: {
                            ConcurrentOperationsTest.this.cache(node).put((Object)"k", (Object)("v_" + n + "_" + iteration));
                            break;
                        }
                        case 1: {
                            ConcurrentOperationsTest.this.cache(node).remove((Object)"k");
                            break;
                        }
                        case 2: {
                            ConcurrentOperationsTest.this.cache(node).putIfAbsent((Object)"k", (Object)("v" + n));
                            break;
                        }
                        case 3: {
                            ConcurrentOperationsTest.this.cache(node).replace((Object)"k", (Object)("v" + n));
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }

                private void checkCorrectness(int i) {
                    if (checkCorrectness) {
                        log.tracef("Checking correctness for iteration %s", i);
                        ConcurrentOperationsTest.this.print("Checking correctness");
                        List owners = ConcurrentOperationsTest.this.cacheTopology(0).getDistribution((Object)"k").writeOwners();
                        if (!ConcurrentOperationsTest.this.checkOwners(owners)) {
                            correctness.set(false);
                        }
                        for (int q = 0; q < ConcurrentOperationsTest.this.nodes; ++q) {
                            ConcurrentOperationsTest.this.print(q, ConcurrentOperationsTest.this.cache(0).get((Object)"k"));
                        }
                        Object expectedValue = ConcurrentOperationsTest.this.cache(0).get((Object)"k");
                        log.tracef("Original value read from cache 0 is %s", expectedValue);
                        for (int j = 0; j < ConcurrentOperationsTest.this.nodes; ++j) {
                            Object actualValue = ConcurrentOperationsTest.this.cache(j).get((Object)"k");
                            boolean areEquals = expectedValue == null ? actualValue == null : expectedValue.equals(actualValue);
                            ConcurrentOperationsTest.this.print("Are " + String.valueOf(actualValue) + " and " + String.valueOf(expectedValue) + " equals ? " + areEquals);
                            if (areEquals) continue;
                            correctness.set(false);
                            ConcurrentOperationsTest.this.print("Consistency error. On cache 0 we had " + String.valueOf(expectedValue) + " and on " + j + " we had " + String.valueOf(actualValue));
                            log.trace((Object)("Consistency error. On cache 0 we had " + String.valueOf(expectedValue) + " and on " + j + " we had " + String.valueOf(actualValue)));
                        }
                    }
                }

                private void barrier() throws BrokenBarrierException, TimeoutException, InterruptedException {
                    barrier.await(10000L, TimeUnit.MILLISECONDS);
                    log.tracef("Just passed barrier.", new Object[0]);
                }
            });
            result.add(f);
        }
        for (Future future : result) {
            Assert.assertTrue((boolean)((Boolean)future.get()));
        }
    }

    protected boolean checkOwners(List<Address> owners) {
        assert (owners.size() == 2);
        InternalCacheEntry entry0 = this.advancedCache(owners.get(0)).getDataContainer().get((Object)"k");
        InternalCacheEntry entry1 = this.advancedCache(owners.get(1)).getDataContainer().get((Object)"k");
        return this.checkOwnerEntries(entry0, entry1, owners.get(0), owners.get(1));
    }

    protected boolean checkOwnerEntries(InternalCacheEntry entry0, InternalCacheEntry entry1, Address mainOwner, Address backupOwner) {
        boolean equals;
        Object mainOwnerValue = entry0 == null ? null : entry0.getValue();
        Object otherOwnerValue = entry1 == null ? null : entry1.getValue();
        log.tracef("Main owner value is %s, other Owner Value is %s", mainOwnerValue, otherOwnerValue);
        boolean bl = mainOwnerValue == null ? otherOwnerValue == null : (equals = mainOwnerValue.equals(otherOwnerValue));
        if (!equals) {
            this.print("Consistency error. On main owner(" + String.valueOf(mainOwner) + ") we had " + String.valueOf(mainOwnerValue) + " and on backup owner(" + String.valueOf(backupOwner) + ") we had " + String.valueOf(otherOwnerValue));
            log.trace((Object)("Consistency error. On main owner(" + String.valueOf(mainOwner) + ") we had " + String.valueOf(mainOwnerValue) + " and on backup owner(" + String.valueOf(backupOwner) + ") we had " + String.valueOf(otherOwnerValue)));
            return false;
        }
        this.print("otherOwnerValue = " + String.valueOf(otherOwnerValue));
        this.print("mainOwnerValue = " + String.valueOf(mainOwnerValue));
        return true;
    }

    private AdvancedCache advancedCache(Address address) {
        for (Cache c : this.caches()) {
            if (!c.getAdvancedCache().getRpcManager().getAddress().equals((Object)address)) continue;
            return c.getAdvancedCache();
        }
        throw new IllegalStateException("Couldn't find cache for address : " + String.valueOf(address));
    }

    private void print(int index, Object value) {
        this.print("[" + Thread.currentThread().getName() + "] Cache " + index + " sees value " + String.valueOf(value));
    }

    private void print(Object value) {
        log.debug(value);
    }

    public void testReplace() {
        this.cache(0).put((Object)"k", (Object)"v1");
        for (int i = 0; i < this.nodes; ++i) {
            Assert.assertEquals((Object)"v1", (Object)this.cache(i).get((Object)"k"));
        }
        assert (this.cache(0).replace((Object)"k", (Object)"v2") != null);
        assert (this.cache(0).replace((Object)"k", (Object)"v2", (Object)"v3"));
        Assert.assertEquals((Object)this.cache(0).get((Object)"k"), (Object)"v3");
    }
}

