/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import jakarta.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.ForceWriteLockTest")
public class ForceWriteLockTest
extends SingleCacheManagerTest {
    private TransactionManager tm;
    private AdvancedCache<String, String> advancedCache;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cacheConfiguration = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        cacheConfiguration.transaction().lockingMode(LockingMode.PESSIMISTIC);
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager(cacheConfiguration);
        this.advancedCache = cacheManager.getCache().getAdvancedCache();
        this.tm = TestingUtil.getTransactionManager(this.advancedCache);
        return cacheManager;
    }

    public void testWriteLockIsAcquired() throws Exception {
        this.advancedCache.put((Object)"k", (Object)"v");
        this.assertEventuallyNotLocked((Cache<?, ?>)this.advancedCache, "k");
        this.tm.begin();
        this.advancedCache.withFlags(Flag.FORCE_WRITE_LOCK).get((Object)"k");
        TransactionTable txTable = (TransactionTable)ComponentRegistry.componentOf(this.advancedCache, TransactionTable.class);
        LocalTransaction tx = txTable.getLocalTransaction(this.tm.getTransaction());
        AssertJUnit.assertTrue((boolean)tx.ownsLock((Object)"k"));
        this.assertLocked((Cache<?, ?>)this.advancedCache, "k");
        this.tm.commit();
        this.assertEventuallyNotLocked((Cache<?, ?>)this.advancedCache, "k");
    }
}

