/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.IgnoreReturnValueForConditionalOperationsTest")
public class IgnoreReturnValueForConditionalOperationsTest
extends MultipleCacheManagersTest {
    @Override
    public Object[] factory() {
        return new Object[]{new IgnoreReturnValueForConditionalOperationsTest().cacheMode(CacheMode.DIST_SYNC).transactional(false), new IgnoreReturnValueForConditionalOperationsTest().cacheMode(CacheMode.DIST_SYNC).transactional(true)};
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder dcc = IgnoreReturnValueForConditionalOperationsTest.getDefaultClusteredCacheConfig(this.cacheMode, this.transactional);
        this.createCluster(TestDataSCI.INSTANCE, dcc, 2);
        this.waitForClusterToForm();
    }

    public void testConditionalReplace() {
        Object k = this.init();
        AdvancedCache cache = this.advancedCache(0).withFlags(Flag.IGNORE_RETURN_VALUES);
        Object put = cache.put((Object)"kx", (Object)"vx");
        put = cache.put((Object)"kx", (Object)"vx");
        Assert.assertTrue((boolean)this.advancedCache(0).withFlags(Flag.IGNORE_RETURN_VALUES).replace(k, (Object)"v0", (Object)"v1"));
        Assert.assertEquals((Object)this.cache(0).get(k), (Object)"v1");
        Assert.assertEquals((Object)this.cache(1).get(k), (Object)"v1");
    }

    public void testConditionalRemove() {
        Object k = this.init();
        Assert.assertTrue((boolean)this.advancedCache(0).withFlags(Flag.IGNORE_RETURN_VALUES).remove(k, (Object)"v0"));
        Assert.assertNull((Object)this.cache(0).get(k));
        Assert.assertNull((Object)this.cache(1).get(k));
    }

    private Object init() {
        Object k = this.getKeyForCache(1);
        this.cache(0).put(k, (Object)"v0");
        Assert.assertEquals((Object)this.cache(0).get(k), (Object)"v0");
        Assert.assertEquals((Object)this.cache(1).get(k), (Object)"v0");
        return k;
    }
}

