/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.distribution.MagicKey;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.MixedModeTest")
public class MixedModeTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder replSync = MixedModeTest.getDefaultClusteredCacheConfig(CacheMode.REPL_SYNC, false);
        ConfigurationBuilder replAsync = MixedModeTest.getDefaultClusteredCacheConfig(CacheMode.REPL_ASYNC, false);
        ConfigurationBuilder invalSync = MixedModeTest.getDefaultClusteredCacheConfig(CacheMode.INVALIDATION_SYNC, false);
        ConfigurationBuilder invalAsync = MixedModeTest.getDefaultClusteredCacheConfig(CacheMode.INVALIDATION_ASYNC, false);
        ConfigurationBuilder local = MixedModeTest.getDefaultClusteredCacheConfig(CacheMode.LOCAL, false);
        this.createClusteredCaches(2, "replSync", TestDataSCI.INSTANCE, replSync);
        this.defineConfigurationOnAllManagers("replAsync", replAsync);
        this.defineConfigurationOnAllManagers("invalSync", invalSync);
        this.defineConfigurationOnAllManagers("invalAsync", invalAsync);
        this.waitForClusterToForm("replAsync", "invalSync", "invalAsync");
        this.defineConfigurationOnAllManagers("local", local);
    }

    public void testMixedMode() {
        AdvancedCache replSyncCache1 = this.cache(0, "replSync").getAdvancedCache();
        AdvancedCache replSyncCache2 = this.cache(1, "replSync").getAdvancedCache();
        AdvancedCache replAsyncCache1 = this.cache(0, "replAsync").getAdvancedCache();
        AdvancedCache replAsyncCache2 = this.cache(1, "replAsync").getAdvancedCache();
        AdvancedCache invalSyncCache1 = this.cache(0, "invalSync").getAdvancedCache();
        AdvancedCache invalSyncCache2 = this.cache(1, "invalSync").getAdvancedCache();
        AdvancedCache invalAsyncCache1 = this.cache(0, "invalAsync").getAdvancedCache();
        AdvancedCache invalAsyncCache2 = this.cache(1, "invalAsync").getAdvancedCache();
        AdvancedCache localCache1 = this.cache(0, "local").getAdvancedCache();
        AdvancedCache localCache2 = this.cache(1, "local").getAdvancedCache();
        MagicKey key = new MagicKey("k", (Cache<?, ?>)replAsyncCache1);
        invalSyncCache2.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)key, (Object)"v");
        AssertJUnit.assertEquals((Object)"v", (Object)invalSyncCache2.get((Object)key));
        AssertJUnit.assertNull((Object)invalSyncCache1.get((Object)key));
        invalAsyncCache2.withFlags(Flag.CACHE_MODE_LOCAL).put((Object)key, (Object)"v");
        AssertJUnit.assertEquals((Object)"v", (Object)invalAsyncCache2.get((Object)key));
        AssertJUnit.assertNull((Object)invalAsyncCache1.get((Object)key));
        this.replListener((Cache<?, ?>)replAsyncCache2).expectAny();
        this.replListener((Cache<?, ?>)invalAsyncCache2).expectAny();
        replSyncCache1.put((Object)key, (Object)"replSync");
        replAsyncCache1.put((Object)key, (Object)"replAsync");
        invalSyncCache1.put((Object)key, (Object)"invalSync");
        invalAsyncCache1.put((Object)key, (Object)"invalAsync");
        localCache1.put((Object)key, (Object)"local");
        this.replListener((Cache<?, ?>)replAsyncCache2).waitForRpc();
        this.replListener((Cache<?, ?>)invalAsyncCache2).waitForRpc();
        AssertJUnit.assertEquals((Object)"replSync", (Object)replSyncCache1.get((Object)key));
        AssertJUnit.assertEquals((Object)"replSync", (Object)replSyncCache2.get((Object)key));
        AssertJUnit.assertEquals((Object)"replAsync", (Object)replAsyncCache1.get((Object)key));
        AssertJUnit.assertEquals((Object)"replAsync", (Object)replAsyncCache2.get((Object)key));
        AssertJUnit.assertEquals((Object)"invalSync", (Object)invalSyncCache1.get((Object)key));
        AssertJUnit.assertNull((Object)invalSyncCache2.get((Object)key));
        AssertJUnit.assertEquals((Object)"invalAsync", (Object)invalAsyncCache1.get((Object)key));
        AssertJUnit.assertNull((Object)invalAsyncCache2.get((Object)key));
        AssertJUnit.assertEquals((Object)"local", (Object)localCache1.get((Object)key));
        AssertJUnit.assertNull((Object)localCache2.get((Object)key));
    }
}

