/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import jakarta.transaction.TransactionManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.commons.util.IntSet;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.AbstractDelegatingInternalDataContainer;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.reactive.publisher.impl.ClusterPublisherManager;
import org.infinispan.reactive.publisher.impl.DeliveryGuarantee;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestException;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.mockito.AdditionalAnswers;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.reactivestreams.Publisher;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.SizeOptimizationTests")
public class SizeOptimizationTests
extends MultipleCacheManagersTest {
    private static final String CACHE_NAME = "SizeOptimizationsTest";
    private static final int ENTRIES_SIZE = 42;
    private Optimization optimization;

    public SizeOptimizationTests optimization(Optimization optimization) {
        this.optimization = optimization;
        return this;
    }

    @Override
    public Object[] factory() {
        return Arrays.stream(Optimization.values()).map(o -> new SizeOptimizationTests().optimization((Optimization)((Object)o))).toArray();
    }

    @Override
    protected Object[] parameterValues() {
        return new Object[]{this.optimization};
    }

    @Override
    protected String[] parameterNames() {
        return new String[]{"optimization"};
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = SizeOptimizationTests.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC);
        this.createClusteredCaches(3, CACHE_NAME, this.optimization.configure(builder));
    }

    public void testSizeReturnsCorrectly() throws Exception {
        Cache cache = this.cache(0, CACHE_NAME);
        for (int i = 0; i < 42; ++i) {
            if ((i & 1) == 1) {
                cache.put((Object)("key-" + i), (Object)("v" + i), 30L, TimeUnit.SECONDS);
                continue;
            }
            cache.put((Object)("key-" + i), (Object)("v" + i));
        }
        this.optimization.verify(cache, this);
    }

    private static void waitDefaultCalledMaxTo(Cache<?, ?> cache, CheckPoint checkPoint, int maxCalls) {
        AtomicInteger executionTimes = new AtomicInteger(maxCalls);
        SizeOptimizationTests.createMocking(cache, original -> invocation -> {
            if (executionTimes.getAndDecrement() == 0) {
                throw new TestException("Called more than " + maxCalls + " times to " + invocation.getMethod().getName());
            }
            CompletionStage result = (CompletionStage)original.answer(invocation);
            result.thenRun(() -> {
                checkPoint.trigger("default_invoked_done_" + String.valueOf(cache), 1);
                try {
                    checkPoint.awaitStrict("default_invoked_done_proceed_" + String.valueOf(cache), 10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException | TimeoutException e) {
                    throw new TestException(e);
                }
            });
            return result;
        });
    }

    private static void neverCallDefault(Cache<?, ?> cache) {
        SizeOptimizationTests.waitDefaultCalledMaxTo(cache, null, 0);
    }

    private static void createMocking(Cache<?, ?> cache, Function<Answer<Object>, Answer<?>> forward) {
        ClusterPublisherManager cpm = TestingUtil.extractComponent(cache, ClusterPublisherManager.class);
        Answer forwardedAnswer = AdditionalAnswers.delegatesTo((Object)cpm);
        ClusterPublisherManager mockCpm = (ClusterPublisherManager)Mockito.mock(ClusterPublisherManager.class, (MockSettings)Mockito.withSettings().defaultAnswer(forwardedAnswer));
        ((ClusterPublisherManager)Mockito.doAnswer(forward.apply((Answer<Object>)forwardedAnswer)).when((Object)mockCpm)).keyReduction(ArgumentMatchers.anyBoolean(), (IntSet)ArgumentMatchers.any(), (Set)ArgumentMatchers.any(), (InvocationContext)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (DeliveryGuarantee)ArgumentMatchers.any(), (Function)ArgumentMatchers.any(), (Function)ArgumentMatchers.any());
        TestingUtil.replaceComponent(cache, ClusterPublisherManager.class, mockCpm, true);
    }

    private static void brieflyReplaceDataContainerNotIterable(Cache<?, ?> cache, Callable<Void> callable) {
        IDCNotIterable controlled = new IDCNotIterable(cache);
        TestingUtil.replaceComponent(cache, InternalDataContainer.class, controlled, true);
        try {
            callable.call();
        }
        catch (Exception e) {
            throw new TestException("Failed on callable", e);
        }
        finally {
            TestingUtil.replaceComponent(cache, InternalDataContainer.class, controlled.current, true);
        }
    }

    private static void replaceDataContainerNotIterable(Cache<?, ?> cache) {
        IDCNotIterable controlled = new IDCNotIterable(cache);
        TestingUtil.replaceComponent(cache, InternalDataContainer.class, controlled, true);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Optimization {
        SHARED{

            @Override
            public ConfigurationBuilder configure(ConfigurationBuilder builder) {
                ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)builder.persistence().passivation(false).addStore(DummyInMemoryStoreConfigurationBuilder.class)).storeName(this.name()).shared(true)).async().disable();
                return builder;
            }

            @Override
            public void verify(Cache<Object, Object> cache, SizeOptimizationTests test) throws Exception {
                SizeOptimizationTests.neverCallDefault(cache);
                SizeOptimizationTests.replaceDataContainerNotIterable(cache);
                Assert.assertEquals((int)cache.size(), (int)42);
                int halfEntries = 21;
                for (int i = 0; i < halfEntries; ++i) {
                    cache.remove((Object)("key-" + i));
                }
                Assert.assertEquals((int)cache.size(), (int)halfEntries);
            }
        }
        ,
        SEGMENTED{

            @Override
            public ConfigurationBuilder configure(ConfigurationBuilder builder) {
                ((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)((DummyInMemoryStoreConfigurationBuilder)builder.persistence().passivation(false).addStore(DummyInMemoryStoreConfigurationBuilder.class)).storeName(this.name()).shared(false)).segmented(true)).async().disable().clustering().hash().numSegments(3);
                return builder;
            }

            @Override
            public void verify(Cache<Object, Object> cache, SizeOptimizationTests test) {
                SizeOptimizationTests.neverCallDefault(cache);
                AdvancedCache localCache = cache.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL);
                HashSet beforeEntries = new HashSet(42);
                beforeEntries.addAll(localCache.entrySet());
                SizeOptimizationTests.brieflyReplaceDataContainerNotIterable(localCache, () -> 2.lambda$verify$0((Cache)localCache, beforeEntries));
                int halfEntries = 21;
                for (int i = 0; i < halfEntries; ++i) {
                    cache.remove((Object)("key-" + i));
                }
                HashSet afterEntries = new HashSet(halfEntries);
                afterEntries.addAll(localCache.entrySet());
                SizeOptimizationTests.brieflyReplaceDataContainerNotIterable(localCache, () -> 2.lambda$verify$1((Cache)localCache, afterEntries));
            }

            private static /* synthetic */ Void lambda$verify$1(Cache localCache, Set afterEntries) throws Exception {
                Assert.assertEquals((int)localCache.size(), (int)afterEntries.size());
                return null;
            }

            private static /* synthetic */ Void lambda$verify$0(Cache localCache, Set beforeEntries) throws Exception {
                Assert.assertEquals((int)localCache.size(), (int)beforeEntries.size());
                return null;
            }
        }
        ,
        NO_STORE{

            @Override
            public ConfigurationBuilder configure(ConfigurationBuilder builder) {
                builder.persistence().passivation(false).clearStores();
                builder.transaction().lockingMode(LockingMode.OPTIMISTIC).transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup());
                return builder;
            }

            @Override
            public void verify(Cache<Object, Object> cache, SizeOptimizationTests test) throws Exception {
                CheckPoint checkPoint = new CheckPoint();
                AdvancedCache localCache = cache.getAdvancedCache().withFlags(Flag.CACHE_MODE_LOCAL);
                SizeOptimizationTests.waitDefaultCalledMaxTo(localCache, checkPoint, 1);
                Future verifySize = test.fork(() -> {
                    TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
                    tm.begin();
                    try {
                        cache.put((Object)"key-tx", (Object)"value-tx");
                        Assert.assertEquals((int)cache.size(), (int)43);
                        cache.remove((Object)"key-tx");
                    }
                    finally {
                        tm.rollback();
                    }
                });
                checkPoint.awaitStrict("default_invoked_done_" + String.valueOf(localCache), 10L, TimeUnit.SECONDS);
                checkPoint.trigger("default_invoked_done_proceed_" + String.valueOf(localCache), 1);
                verifySize.get(10L, TimeUnit.SECONDS);
                for (int i = 0; i < 42; ++i) {
                    if ((i & 1) != 1) continue;
                    localCache.remove((Object)("key-" + i));
                }
                HashSet entries = new HashSet(21);
                entries.addAll(localCache.entrySet());
                SizeOptimizationTests.replaceDataContainerNotIterable(cache);
                Assert.assertEquals((int)localCache.size(), (int)entries.size());
            }
        };


        public abstract ConfigurationBuilder configure(ConfigurationBuilder var1);

        public abstract void verify(Cache<Object, Object> var1, SizeOptimizationTests var2) throws Exception;
    }

    static class IDCNotIterable
    extends AbstractDelegatingInternalDataContainer {
        final InternalDataContainer<?, ?> current;

        IDCNotIterable(Cache<?, ?> cache) {
            this.current = TestingUtil.extractComponent(cache, InternalDataContainer.class);
        }

        protected InternalDataContainer<?, ?> delegate() {
            return this.current;
        }

        public Iterator<InternalCacheEntry<?, ?>> iterator() {
            throw new TestException("Should not call iterator");
        }

        public Iterator<InternalCacheEntry<?, ?>> iterator(IntSet segments) {
            throw new TestException("Should not call iterator");
        }

        public Iterator<InternalCacheEntry<?, ?>> iteratorIncludingExpired() {
            throw new TestException("Should not call iterator");
        }

        public Iterator<InternalCacheEntry<?, ?>> iteratorIncludingExpired(IntSet segments) {
            throw new TestException("Should not call iterator");
        }

        public Publisher<InternalCacheEntry> publisher(int segment) {
            throw new TestException("Should not call publisher");
        }

        public Publisher<InternalCacheEntry> publisher(IntSet segments) {
            throw new TestException("Should not call publisher");
        }
    }
}

