/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.flags;

import java.util.EnumSet;
import org.infinispan.AdvancedCache;
import org.infinispan.cache.impl.CacheImpl;
import org.infinispan.cache.impl.DecoratedCache;
import org.infinispan.commons.util.EnumUtil;
import org.infinispan.context.Flag;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.flags.DecoratedCacheTest")
public class DecoratedCacheTest {
    public void testDecoratedCacheFlagsSet() {
        CacheImpl impl = new CacheImpl("baseCache");
        DecoratedCache decoratedCache = new DecoratedCache(impl, 0L);
        DecoratedCache nofailCache = (DecoratedCache)decoratedCache.withFlags(Flag.FAIL_SILENTLY);
        EnumSet nofailCacheFlags = EnumUtil.enumSetOf((long)nofailCache.getFlagsBitSet(), Flag.class);
        assert (nofailCacheFlags.contains(Flag.FAIL_SILENTLY));
        assert (nofailCacheFlags.size() == 1);
        DecoratedCache asyncNoFailCache = (DecoratedCache)nofailCache.withFlags(Flag.FORCE_ASYNCHRONOUS);
        EnumSet asyncNofailCacheFlags = EnumUtil.enumSetOf((long)asyncNoFailCache.getFlagsBitSet(), Flag.class);
        assert (asyncNofailCacheFlags.size() == 2);
        assert (asyncNofailCacheFlags.contains(Flag.FAIL_SILENTLY));
        assert (asyncNofailCacheFlags.contains(Flag.FORCE_ASYNCHRONOUS));
        AdvancedCache again = asyncNoFailCache.withFlags(Flag.FAIL_SILENTLY);
        assert (again == asyncNoFailCache);
    }
}

