/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.Cache;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TransportFlags;

public abstract class StressTest
extends MultipleCacheManagersTest {
    protected final String CACHE_NAME = "testCache";
    final AtomicBoolean complete = new AtomicBoolean(false);
    final BlockingQueue<Throwable> exceptions = new LinkedBlockingDeque<Throwable>();
    protected ConfigurationBuilder builderUsed;

    protected Future<Void> forkRestartingThread(int cacheCount) {
        return this.fork(() -> {
            TestResourceTracker.testThreadStarted((String)this.getTestName());
            try {
                Cache cacheToKill = this.cache(cacheCount - 1);
                while (!this.complete.get()) {
                    Thread.sleep(1000L);
                    if (this.cacheManagers.remove(cacheToKill.getCacheManager())) {
                        log.trace((Object)"Killing cache to force rehash");
                        cacheToKill.getCacheManager().stop();
                        List caches = this.caches("testCache");
                        if (!caches.isEmpty()) {
                            TestingUtil.blockUntilViewsReceived(60000, false, caches);
                            TestingUtil.waitForNoRebalance(caches);
                        }
                    } else {
                        throw new IllegalStateException("Cache Manager " + String.valueOf(cacheToKill.getCacheManager()) + " wasn't found for some reason!");
                    }
                    log.trace((Object)"Adding new cache again to force rehash");
                    EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(new TransportFlags());
                    cacheToKill = cm.createCache("testCache", this.builderUsed.build());
                    log.trace((Object)"Added new cache again to force rehash");
                }
                return null;
            }
            catch (Exception e) {
                this.complete.set(true);
                this.exceptions.add(e);
                throw e;
            }
        });
    }

    public void waitAndFinish(List<Future<Void>> futures, int timeout, TimeUnit timeUnit) throws Throwable {
        Throwable e = this.exceptions.poll(timeout, timeUnit);
        if (e != null) {
            Throwable e2 = e;
            do {
                log.error((Object)"Exception in another thread", e2);
            } while ((e2 = (Throwable)this.exceptions.poll()) != null);
            throw e;
        }
        this.complete.set(true);
        for (Future<Void> future : futures) {
            future.get(1L, TimeUnit.MINUTES);
        }
    }

    public <T> List<Future<Void>> forkWorkerThreads(String cacheName, int threadMultiplier, int cacheCount, T[] args, WorkerLogic<T> logic) {
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(threadMultiplier * (cacheCount - 1) + 1);
        for (int j = 0; j < threadMultiplier; ++j) {
            for (int i = 0; i < cacheCount - 1; ++i) {
                int offset = j * (cacheCount - 1) + i;
                Cache cache = this.cache(i, cacheName);
                futures.add(this.fork(() -> {
                    try {
                        int iteration = 0;
                        while (!this.complete.get()) {
                            log.tracef("Starting operation %d", iteration);
                            logic.run((Cache<Integer, Integer>)cache, args[offset], iteration);
                            ++iteration;
                        }
                        System.out.println(String.valueOf(Thread.currentThread()) + " finished " + iteration + " iterations!");
                    }
                    catch (Throwable e) {
                        log.trace((Object)"Failed", e);
                        this.complete.set(true);
                        this.exceptions.add(e);
                        throw e;
                    }
                    return null;
                }));
            }
        }
        return futures;
    }

    protected static interface WorkerLogic<T> {
        public void run(Cache<Integer, Integer> var1, T var2, int var3) throws Exception;
    }
}

