/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.module;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.module.ModuleCommandExtensions;
import org.infinispan.commands.module.ModuleCommandFactory;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.remoting.rpc.CustomCacheRpcCommand;
import org.infinispan.remoting.rpc.CustomReplicableCommand;
import org.infinispan.remoting.rpc.SleepingCacheRpcCommand;
import org.infinispan.util.ByteString;

public final class TestModuleCommandExtensions
implements ModuleCommandExtensions {
    public ModuleCommandFactory getModuleCommandFactory() {
        return new ModuleCommandFactory(){

            public Map<Byte, Class<? extends ReplicableCommand>> getModuleCommands() {
                HashMap<Byte, Class<? extends ReplicableCommand>> map = new HashMap<Byte, Class<? extends ReplicableCommand>>(2);
                map.put((byte)127, CustomReplicableCommand.class);
                map.put((byte)126, CustomCacheRpcCommand.class);
                map.put((byte)125, SleepingCacheRpcCommand.class);
                return map;
            }

            public ReplicableCommand fromStream(byte commandId) {
                return switch (commandId) {
                    case 127 -> new CustomReplicableCommand();
                    default -> throw new IllegalArgumentException("Not registered to handle command id " + commandId);
                };
            }

            public CacheRpcCommand fromStream(byte commandId, ByteString cacheName) {
                return switch (commandId) {
                    case 126 -> new CustomCacheRpcCommand(cacheName);
                    case 125 -> new SleepingCacheRpcCommand(cacheName);
                    default -> throw new IllegalArgumentException("Not registered to handle command id " + commandId);
                };
            }
        };
    }
}

