/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.serializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.io.ConfigurationResourceResolvers;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexingConfiguration;
import org.infinispan.configuration.cache.QueryConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.cache.TracingConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class AbstractConfigurationSerializerTest
extends AbstractInfinispanTest {
    public static final List<MediaType> ALL = Arrays.asList(MediaType.APPLICATION_XML, MediaType.APPLICATION_YAML, MediaType.APPLICATION_JSON);
    public static final List<MediaType> XML = Collections.singletonList(MediaType.APPLICATION_XML);

    @DataProvider(name="configurationFiles")
    public Object[][] configurationFiles() throws Exception {
        Path configDir = Paths.get(System.getProperty("build.directory"), "test-classes", "configs", "all");
        Properties properties = new Properties();
        properties.put("jboss.server.temp.dir", System.getProperty("java.io.tmpdir"));
        ParserRegistry registry = new ParserRegistry(Thread.currentThread().getContextClassLoader(), false, properties);
        List<Path> paths = Files.list(configDir).toList();
        return (Object[][])paths.stream().flatMap(p -> AbstractConfigurationSerializerTest.typesFor(p).stream().map(t -> new Object[]{new Parameter((Path)p, (MediaType)t, registry)})).toArray(x$0 -> new Object[x$0][]);
    }

    public static List<MediaType> typesFor(Path p) {
        try {
            return Integer.parseInt(p.getFileName().toString().split("\\.")[0]) >= 12 ? ALL : XML;
        }
        catch (NumberFormatException e) {
            return ALL;
        }
    }

    @Test(dataProvider="configurationFiles")
    public void configurationSerializationTest(Parameter parameter) throws IOException {
        URL url = FileLookupFactory.newInstance().lookupFileLocation(parameter.config.toString(), Thread.currentThread().getContextClassLoader());
        ConfigurationBuilderHolder holderBefore = parameter.registry.parse(url);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        LinkedHashMap<String, Configuration> configurations = new LinkedHashMap<String, Configuration>();
        for (Map.Entry configuration : holderBefore.getNamedConfigurationBuilders().entrySet()) {
            configurations.put((String)configuration.getKey(), ((ConfigurationBuilder)configuration.getValue()).build());
        }
        try (ConfigurationWriter writer = ConfigurationWriter.to((OutputStream)baos).withType(parameter.mediaType).build();){
            parameter.registry.serialize(writer, holderBefore.getGlobalConfigurationBuilder().build(), configurations);
        }
        log.debug((Object)baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ConfigurationBuilderHolder holderAfter = parameter.registry.parse((InputStream)bais, ConfigurationResourceResolvers.DEFAULT, parameter.mediaType);
        GlobalConfiguration globalConfigurationBefore = holderBefore.getGlobalConfigurationBuilder().build();
        GlobalConfiguration globalConfigurationAfter = holderAfter.getGlobalConfigurationBuilder().build();
        AssertJUnit.assertEquals((long)globalConfigurationBefore.security().securityCacheTimeout(), (long)globalConfigurationAfter.security().securityCacheTimeout());
        AssertJUnit.assertEquals((long)globalConfigurationBefore.security().securityCacheSize(), (long)globalConfigurationAfter.security().securityCacheSize());
        AbstractConfigurationSerializerTest.compareAttributeSets("Global", globalConfigurationBefore.globalState().attributes(), globalConfigurationAfter.globalState().attributes(), "localConfigurationStorage");
        AbstractConfigurationSerializerTest.compareAttributeSets("Global", globalConfigurationBefore.jmx().attributes(), globalConfigurationAfter.jmx().attributes(), Attribute.MBEAN_SERVER_LOOKUP.toString());
        AbstractConfigurationSerializerTest.compareAttributeSets("Global", globalConfigurationBefore.security().authorization().attributes(), globalConfigurationAfter.security().authorization().attributes(), new String[0]);
        AbstractConfigurationSerializerTest.compareAttributeSets("Global", globalConfigurationBefore.serialization().attributes(), globalConfigurationAfter.serialization().attributes(), "marshaller", "classResolver", "advancedExternalizer", "contextInitializers");
        AbstractConfigurationSerializerTest.compareAttributeSets("Global", globalConfigurationBefore.transport().attributes(), globalConfigurationAfter.transport().attributes(), "transport", "properties");
        this.compareExtraGlobalConfiguration(globalConfigurationBefore, globalConfigurationAfter);
        for (String name : holderBefore.getNamedConfigurationBuilders().keySet()) {
            Configuration configurationBefore = ((ConfigurationBuilder)holderBefore.getNamedConfigurationBuilders().get(name)).build();
            AssertJUnit.assertTrue((String)name, (boolean)holderAfter.getNamedConfigurationBuilders().containsKey(name));
            Configuration configurationAfter = ((ConfigurationBuilder)holderAfter.getNamedConfigurationBuilders().get(name)).build();
            this.compareConfigurations(name, configurationBefore, configurationAfter);
        }
    }

    private void compareConfigurations(String name, Configuration configurationBefore, Configuration configurationAfter) {
        AbstractConfigurationSerializerTest.compareAttributeSets(name, configurationBefore.clustering().attributes(), configurationAfter.clustering().attributes(), new String[0]);
        AbstractConfigurationSerializerTest.compareAttributeSets(name, configurationBefore.clustering().hash().attributes(), configurationAfter.clustering().hash().attributes(), new String[0]);
        AbstractConfigurationSerializerTest.compareAttributeSets(name, configurationBefore.clustering().l1().attributes(), configurationAfter.clustering().l1().attributes(), new String[0]);
        AbstractConfigurationSerializerTest.compareAttributeSets(name, configurationBefore.clustering().partitionHandling().attributes(), configurationAfter.clustering().partitionHandling().attributes(), new String[0]);
        AssertJUnit.assertEquals((String)name, (Object)configurationBefore.memory(), (Object)configurationAfter.memory());
        AbstractConfigurationSerializerTest.compareAttributeSets(name, configurationBefore.expiration().attributes(), configurationAfter.expiration().attributes(), new String[0]);
        this.compareIndexing(name, configurationBefore.indexing(), configurationAfter.indexing());
        this.compareQuery(name, configurationBefore.query(), configurationAfter.query());
        this.compareTracing(name, configurationBefore.tracing(), configurationAfter.tracing());
        AbstractConfigurationSerializerTest.compareAttributeSets(name, configurationBefore.locking().attributes(), configurationAfter.locking().attributes(), new String[0]);
        AbstractConfigurationSerializerTest.compareAttributeSets(name, configurationBefore.statistics().attributes(), configurationAfter.statistics().attributes(), new String[0]);
        AbstractConfigurationSerializerTest.compareAttributeSets(name, configurationBefore.sites().attributes(), configurationAfter.sites().attributes(), new String[0]);
        this.compareSites(name, configurationBefore.sites().allBackups(), configurationAfter.sites().allBackups());
        AbstractConfigurationSerializerTest.compareAttributeSets(name, configurationBefore.invocationBatching().attributes(), configurationAfter.invocationBatching().attributes(), new String[0]);
        AbstractConfigurationSerializerTest.compareAttributeSets(name, configurationBefore.unsafe().attributes(), configurationAfter.unsafe().attributes(), new String[0]);
        AbstractConfigurationSerializerTest.compareAttributeSets(name, configurationBefore.persistence().attributes(), configurationAfter.persistence().attributes(), new String[0]);
        this.compareStores(name, configurationBefore.persistence().stores(), configurationAfter.persistence().stores());
        AbstractConfigurationSerializerTest.compareAttributeSets(name, configurationBefore.security().authorization().attributes(), configurationAfter.security().authorization().attributes(), new String[0]);
        AbstractConfigurationSerializerTest.compareAttributeSets(name, configurationBefore.transaction().attributes(), configurationAfter.transaction().attributes(), "transaction-manager-lookup");
        this.compareExtraConfiguration(name, configurationBefore, configurationAfter);
    }

    private void compareQuery(String name, QueryConfiguration before, QueryConfiguration after) {
        AssertJUnit.assertEquals((String)String.format("Query attributes for %s mismatch", name), (Object)before.attributes(), (Object)after.attributes());
    }

    private void compareIndexing(String name, IndexingConfiguration before, IndexingConfiguration after) {
        AssertJUnit.assertEquals((String)String.format("Indexing attributes for %s mismatch", name), (Object)before.attributes(), (Object)after.attributes());
        AssertJUnit.assertEquals((String)String.format("Indexing reader for %s mismatch", name), (Object)before.reader(), (Object)after.reader());
        AssertJUnit.assertEquals((String)String.format("Indexing writer for %s mismatch", name), (Object)before.writer(), (Object)after.writer());
    }

    private void compareTracing(String name, TracingConfiguration before, TracingConfiguration after) {
        AssertJUnit.assertEquals((String)String.format("Tracing attributes for %s mismatch", name), (Object)before.attributes(), (Object)after.attributes());
    }

    protected void compareExtraConfiguration(String name, Configuration configurationBefore, Configuration configurationAfter) {
    }

    protected void compareExtraGlobalConfiguration(GlobalConfiguration configurationBefore, GlobalConfiguration configurationAfter) {
    }

    private void compareStores(String name, List<StoreConfiguration> beforeStores, List<StoreConfiguration> afterStores) {
        AssertJUnit.assertEquals((String)("Configuration " + name + " stores count mismatch"), (int)beforeStores.size(), (int)afterStores.size());
        for (int i = 0; i < beforeStores.size(); ++i) {
            StoreConfiguration beforeStore = beforeStores.get(i);
            StoreConfiguration afterStore = afterStores.get(i);
            this.compareStoreConfiguration(name, beforeStore, afterStore);
        }
    }

    protected void compareStoreConfiguration(String name, StoreConfiguration beforeStore, StoreConfiguration afterStore) {
        if (!(beforeStore instanceof AbstractStoreConfiguration)) {
            throw new IllegalArgumentException("Cannot compare stores of type: " + beforeStore.getClass().getName());
        }
        AbstractStoreConfiguration beforeASC = (AbstractStoreConfiguration)beforeStore;
        AbstractStoreConfiguration afterASC = (AbstractStoreConfiguration)afterStore;
        AbstractConfigurationSerializerTest.compareAttributeSets(name, beforeASC.attributes(), afterASC.attributes(), new String[0]);
        AbstractConfigurationSerializerTest.compareAttributeSets(name, beforeASC.async().attributes(), afterASC.async().attributes(), new String[0]);
    }

    protected static void compareAttributeSets(String name, AttributeSet before, AttributeSet after, String ... exclude) {
        if (before != null && after != null) {
            List<Object> exclusions = exclude != null ? Arrays.asList(exclude) : Collections.emptyList();
            for (org.infinispan.commons.configuration.attributes.Attribute attribute : before.attributes()) {
                if (exclusions.contains(attribute.name())) continue;
                AssertJUnit.assertEquals((String)("Configuration " + name), (Object)attribute, (Object)after.attribute(attribute.name()));
            }
        }
    }

    private void compareSites(String name, List<BackupConfiguration> sitesBefore, List<BackupConfiguration> sitesAfter) {
        AssertJUnit.assertEquals((String)("Configuration " + name + " sites count mismatch"), (int)sitesBefore.size(), (int)sitesAfter.size());
        for (int i = 0; i < sitesBefore.size(); ++i) {
            BackupConfiguration before = sitesBefore.get(i);
            BackupConfiguration after = sitesAfter.get(i);
            AssertJUnit.assertEquals((String)("Configuration " + name + " stores class mismatch"), before.getClass(), after.getClass());
            AbstractConfigurationSerializerTest.compareAttributeSets(name, before.attributes(), after.attributes(), new String[0]);
            AbstractConfigurationSerializerTest.compareAttributeSets(name, before.takeOffline().attributes(), after.takeOffline().attributes(), new String[0]);
            AbstractConfigurationSerializerTest.compareAttributeSets(name, before.stateTransfer().attributes(), after.stateTransfer().attributes(), new String[0]);
        }
    }

    public static class Parameter {
        final Path config;
        final MediaType mediaType;
        final ParserRegistry registry;

        public Parameter(Path config, MediaType mediaType, ParserRegistry registry) {
            this.config = config;
            this.mediaType = mediaType;
            this.registry = registry;
        }

        public String toString() {
            return String.valueOf(this.config.subpath(this.config.getNameCount() - 3, this.config.getNameCount())) + " (" + this.mediaType.getSubType().toUpperCase() + ")";
        }
    }
}

