/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.conflict.impl;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.conflict.ConflictManager;
import org.infinispan.conflict.ConflictManagerFactory;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.distribution.MagicKey;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.BasePartitionHandlingTest;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.partitionhandling.impl.LostDataCheck;
import org.infinispan.partitionhandling.impl.PreferAvailabilityStrategy;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.TestingUtil;
import org.infinispan.topology.CacheStatusResponse;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.ClusterTopologyManagerImpl;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.topology.ManagerStatusResponse;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;

public abstract class BaseMergePolicyTest
extends BasePartitionHandlingTest {
    private static final Log log = LogFactory.getLog(BaseMergePolicyTest.class);
    protected MagicKey conflictKey;
    protected Object valueAfterMerge;
    protected BasePartitionHandlingTest.PartitionDescriptor p0;
    protected BasePartitionHandlingTest.PartitionDescriptor p1;
    protected String description;

    protected BaseMergePolicyTest() {
        this.partitionHandling = PartitionHandling.ALLOW_READ_WRITES;
        this.valueAfterMerge = "DURING SPLIT";
    }

    protected BaseMergePolicyTest(CacheMode cacheMode, String description, int[] partition1, int[] partition2) {
        this(cacheMode, 2, description, null, partition1, partition2);
    }

    protected BaseMergePolicyTest(CacheMode cacheMode, String description, AvailabilityMode availabilityMode, int[] partition1, int[] partition2) {
        this(cacheMode, 2, description, availabilityMode, partition1, partition2);
    }

    protected BaseMergePolicyTest(CacheMode cacheMode, int numOwners, String description, AvailabilityMode availabilityMode, int[] partition1, int[] partition2) {
        this();
        this.cacheMode = cacheMode;
        this.description = description;
        this.p0 = new BasePartitionHandlingTest.PartitionDescriptor(availabilityMode, partition1);
        this.p1 = new BasePartitionHandlingTest.PartitionDescriptor(availabilityMode, partition2);
        this.numMembersInCluster = this.p0.getNodes().length + this.p1.getNodes().length;
        this.numberOfOwners = cacheMode == CacheMode.REPL_SYNC ? this.numMembersInCluster : numOwners;
    }

    @Override
    protected String[] parameterNames() {
        return BaseMergePolicyTest.concat(super.parameterNames(), new String[]{null});
    }

    @Override
    protected Object[] parameterValues() {
        return BaseMergePolicyTest.concat(super.parameterValues(), this.description);
    }

    protected void beforeSplit() {
        this.conflictKey = this.numberOfOwners > 1 ? new MagicKey(this.cache(this.p0.node(0)), this.cache(this.p1.node(0))) : new MagicKey(this.cache(this.p0.node(0)));
        this.cache(this.p0.node(0)).put((Object)this.conflictKey, (Object)"BEFORE SPLIT");
    }

    protected void duringSplit(AdvancedCache preferredPartitionCache, AdvancedCache otherCache) throws Exception {
        preferredPartitionCache.put((Object)this.conflictKey, (Object)"DURING SPLIT");
    }

    protected void splitCluster() {
        this.splitCluster(this.p0.getNodes(), this.p1.getNodes());
        TestingUtil.waitForNoRebalance(this.getPartitionCaches(this.p0));
        TestingUtil.waitForNoRebalance(this.getPartitionCaches(this.p1));
    }

    protected void performMerge() throws Exception {
        this.partition(0).merge(this.partition(1));
    }

    protected void afterConflictResolutionAndMerge() {
        ConflictManager cm = this.conflictManager(0);
        assert (!cm.isConflictResolutionInProgress());
        Map versionMap = cm.getAllVersions((Object)this.conflictKey);
        AssertJUnit.assertNotNull((Object)versionMap);
        AssertJUnit.assertEquals((String)("Versions: " + String.valueOf(versionMap)), (int)this.numberOfOwners, (int)versionMap.size());
        String message = String.format("Key=%s. VersionMap: %s", this.conflictKey, versionMap);
        for (InternalCacheValue icv : versionMap.values()) {
            if (this.valueAfterMerge != null) {
                AssertJUnit.assertNotNull((String)message, (Object)icv);
                AssertJUnit.assertNotNull((String)message, (Object)icv.getValue());
                AssertJUnit.assertEquals((String)message, (Object)this.valueAfterMerge, (Object)icv.getValue());
                continue;
            }
            AssertJUnit.assertNull((String)message, (Object)icv);
        }
        AssertJUnit.assertEquals((long)0L, (long)cm.getConflicts().count());
    }

    public void testPartitionMergePolicy() throws Exception {
        log.tracef("beforeSplit()", new Object[0]);
        this.beforeSplit();
        log.tracef("splitCluster", new Object[0]);
        this.splitCluster();
        log.tracef("duringSplit()", new Object[0]);
        AdvancedCache preferredPartitionCache = this.getCacheFromPreferredPartition();
        this.duringSplit(preferredPartitionCache, this.getCacheFromNonPreferredPartition(preferredPartitionCache));
        log.tracef("performMerge()", new Object[0]);
        this.performMerge();
        log.tracef("afterConflictResolutionAndMerge()", new Object[0]);
        this.afterConflictResolutionAndMerge();
    }

    protected <K, V> AdvancedCache<K, V> getCacheFromNonPreferredPartition(AdvancedCache preferredCache) {
        for (Cache c : this.caches()) {
            AdvancedCache cache = (AdvancedCache)c;
            if (cache.getDistributionManager().getWriteConsistentHash().equals((Object)preferredCache.getDistributionManager().getWriteConsistentHash())) continue;
            return cache;
        }
        return null;
    }

    protected <K, V> AdvancedCache<K, V> getCacheFromPreferredPartition() {
        AdvancedCache[] caches = (AdvancedCache[])this.caches().stream().map(Cache::getAdvancedCache).toArray(AdvancedCache[]::new);
        return this.getCacheFromPreferredPartition(caches);
    }

    protected <K, V> AdvancedCache<K, V> getCacheFromPreferredPartition(AdvancedCache ... caches) {
        Map<Address, CacheStatusResponse> statusResponses = Arrays.stream(caches).collect(Collectors.toMap(x$0 -> this.address((Cache<?, ?>)x$0), this::getCacheStatus));
        LostDataCheck lostDataCheck = ClusterTopologyManagerImpl::distLostDataCheck;
        CacheTopology preferredTopology = new PreferAvailabilityStrategy(null, null, lostDataCheck).computePreferredTopology(statusResponses);
        log.tracef("getCacheFromPreferredPartition: partition=%s", (Object)preferredTopology.getMembers());
        return Arrays.stream(caches).filter(c -> this.address((Cache<?, ?>)c).equals(preferredTopology.getMembers().get(0))).findFirst().get();
    }

    private CacheStatusResponse getCacheStatus(AdvancedCache cache) {
        LocalTopologyManager localTopologyManager = (LocalTopologyManager)ComponentRegistry.componentOf((Cache)cache, LocalTopologyManager.class);
        int viewId = cache.getRpcManager().getTransport().getViewId();
        ManagerStatusResponse statusResponse = (ManagerStatusResponse)CompletionStages.join((CompletionStage)localTopologyManager.handleStatusRequest(viewId));
        return (CacheStatusResponse)statusResponse.getCaches().get(cache.getName());
    }

    protected void assertCacheGet(Object key, Object value, int ... caches) {
        for (int index : caches) {
            AdvancedCache cache = this.advancedCache(index);
            String message = String.format("Key=%s, Value=%s, Cache Index=%s, Topology=%s", key, value, index, cache.getDistributionManager().getCacheTopology());
            AssertJUnit.assertEquals((String)message, (Object)value, (Object)cache.get(key));
        }
    }

    protected ConflictManager conflictManager(int index) {
        return ConflictManagerFactory.get(this.advancedCache(index));
    }

    protected int[] cacheIndexes() {
        int[] indexes = new int[this.numMembersInCluster];
        int count = 0;
        for (int i : this.p0.getNodes()) {
            indexes[count++] = i;
        }
        return indexes;
    }
}

