/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.conflict.impl;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.statetransfer.ConflictResolutionStartCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.HashConfiguration;
import org.infinispan.conflict.ConflictManager;
import org.infinispan.conflict.EntryMergePolicy;
import org.infinispan.conflict.impl.BaseMergePolicyTest;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.HashFunctionPartitioner;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.inboundhandler.AbstractDelegatingHandler;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="org.infinispan.conflict.impl.CrashedNodeDuringConflictResolutionTest")
public class CrashedNodeDuringConflictResolutionTest
extends BaseMergePolicyTest {
    private static final Log log = LogFactory.getLog(CrashedNodeDuringConflictResolutionTest.class);
    private static final String PARTITION_0_VAL = "A";
    private static final String PARTITION_1_VAL = "B";
    private static final String BEFORE_CR_CRASH_KEY = "BEFORE_CR_CRASH";
    private static final String DURING_CR_CRASH_KEY = "DURING_CR_CRASH";
    private static final String AFTER_CR_RESTART_KEY = "AFTER_CR_CRASH";
    private static final String RESOLVED_VALUE = "RESOLVED";
    private static final String[] ALL_KEYS = new String[]{"BEFORE_CR_CRASH", "DURING_CR_CRASH", "AFTER_CR_CRASH"};
    private static final EntryMergePolicy POLICY = (preferredEntry, otherEntries) -> {
        Object key = preferredEntry != null ? preferredEntry.getKey() : ((CacheEntry)otherEntries.get(0)).getKey();
        return new ImmortalCacheEntry(key, (Object)RESOLVED_VALUE);
    };
    private static final KeyPartitioner PARTITIONER = new TestKeyPartioner();

    public CrashedNodeDuringConflictResolutionTest() {
        super(CacheMode.DIST_SYNC, null, new int[]{0, 1}, new int[]{2, 3});
        this.mergePolicy = POLICY;
        this.valueAfterMerge = RESOLVED_VALUE;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder dcc = this.cacheConfiguration();
        dcc.clustering().cacheMode(this.cacheMode).partitionHandling().whenSplit(this.partitionHandling).mergePolicy(this.mergePolicy).hash().keyPartitioner(PARTITIONER);
        this.createClusteredCaches(this.numMembersInCluster, dcc, new TransportFlags().withFD(true).withMerge(true));
        this.waitForClusterToForm();
    }

    @Override
    protected void beforeSplit() {
    }

    @Override
    protected void duringSplit(AdvancedCache preferredPartitionCache, AdvancedCache otherCache) {
        for (String key : ALL_KEYS) {
            this.cache(this.p0.node(0)).put((Object)key, (Object)PARTITION_0_VAL);
            this.cache(this.p1.node(0)).put((Object)key, (Object)PARTITION_1_VAL);
        }
        for (String key : ALL_KEYS) {
            this.assertCacheGet(key, PARTITION_0_VAL, this.p0.getNodes());
            this.assertCacheGet(key, PARTITION_1_VAL, this.p1.getNodes());
        }
    }

    @Override
    protected void performMerge() throws Exception {
        CompletableFuture<ConflictResolutionStartCommand> blockedStateRequest = this.createStateRequestFuture();
        for (String key : ALL_KEYS) {
            this.assertCacheGet(key, PARTITION_0_VAL, this.p0.getNodes());
            this.assertCacheGet(key, PARTITION_1_VAL, this.p1.getNodes());
        }
        this.partition(0).merge(this.partition(1), false);
        blockedStateRequest.get(60L, TimeUnit.SECONDS);
        if (log.isTraceEnabled()) {
            log.trace((Object)"crashCacheManager(2)");
        }
        TestingUtil.crashCacheManagers(this.manager(2));
        TestingUtil.waitForNoRebalance(this.cache(0), this.cache(1), this.cache(3));
    }

    @Override
    protected void afterConflictResolutionAndMerge() {
        ConflictManager cm = this.conflictManager(0);
        AssertJUnit.assertFalse((boolean)cm.isConflictResolutionInProgress());
        for (String key : ALL_KEYS) {
            Map versionMap = cm.getAllVersions((Object)key);
            AssertJUnit.assertNotNull((Object)versionMap);
            AssertJUnit.assertEquals((String)("Versions: " + String.valueOf(versionMap)), (int)this.numberOfOwners, (int)versionMap.size());
            String message = String.format("Key=%s. VersionMap: %s", key, versionMap);
            for (InternalCacheValue icv : versionMap.values()) {
                AssertJUnit.assertNotNull((String)message, (Object)icv);
                AssertJUnit.assertNotNull((String)message, (Object)icv.getValue());
                AssertJUnit.assertEquals((String)message, (Object)this.valueAfterMerge, (Object)icv.getValue());
            }
        }
        AssertJUnit.assertEquals((long)0L, (long)cm.getConflicts().peek(m -> log.errorf("Conflict: " + String.valueOf(m), new Object[0])).count());
    }

    private CompletableFuture<ConflictResolutionStartCommand> createStateRequestFuture() {
        int segment = PARTITIONER.getSegment((Object)DURING_CR_CRASH_KEY);
        CompletableFuture<ConflictResolutionStartCommand> future = new CompletableFuture<ConflictResolutionStartCommand>();
        TestingUtil.wrapInboundInvocationHandler(this.cache(2), handler -> new CompleteFutureOnStateRequestHandler((PerCacheInboundInvocationHandler)handler, segment, this.manager(2), future));
        return future;
    }

    private static class CompleteFutureOnStateRequestHandler
    extends AbstractDelegatingHandler {
        final int segment;
        final EmbeddedCacheManager manager;
        final CompletableFuture<ConflictResolutionStartCommand> future;

        CompleteFutureOnStateRequestHandler(PerCacheInboundInvocationHandler delegate, int segment, EmbeddedCacheManager manager, CompletableFuture<ConflictResolutionStartCommand> future) {
            super(delegate);
            this.segment = segment;
            this.manager = manager;
            this.future = future;
        }

        public void handle(CacheRpcCommand command, Reply reply, DeliverOrder order) {
            ConflictResolutionStartCommand src;
            if (command instanceof ConflictResolutionStartCommand && (src = (ConflictResolutionStartCommand)command).getSegments().contains(this.segment)) {
                log.debugf("Completing future and ignoring state request %s", (Object)command);
                this.future.complete(src);
                return;
            }
            this.delegate.handle(command, reply, order);
        }
    }

    public static class TestKeyPartioner
    implements KeyPartitioner {
        private final KeyPartitioner delegate = new HashFunctionPartitioner();

        public void init(HashConfiguration configuration) {
            this.delegate.init(configuration);
        }

        public int getSegment(Object key) {
            if (key instanceof String) {
                String keyString;
                switch (keyString = (String)key) {
                    case "BEFORE_CR_CRASH": {
                        return 10;
                    }
                    case "DURING_CR_CRASH": {
                        return 20;
                    }
                    case "AFTER_CR_CRASH": {
                        return 30;
                    }
                }
            }
            return this.delegate.getSegment(key);
        }
    }
}

