/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.conflict.impl;

import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.conflict.MergePolicy;
import org.infinispan.conflict.impl.BaseMergePolicyTest;
import org.infinispan.distribution.MagicKey;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="conflict.impl.TxConflictResolutionTest")
public class TxConflictResolutionTest
extends BaseMergePolicyTest {
    private static final String VAL = "A";
    private boolean autoCommit;

    @Override
    public Object[] factory() {
        return new Object[]{new TxConflictResolutionTest().autoCommit(true).lockingMode(LockingMode.PESSIMISTIC), new TxConflictResolutionTest().autoCommit(false).lockingMode(LockingMode.PESSIMISTIC), new TxConflictResolutionTest().autoCommit(true).lockingMode(LockingMode.OPTIMISTIC), new TxConflictResolutionTest().autoCommit(false).lockingMode(LockingMode.OPTIMISTIC)};
    }

    public TxConflictResolutionTest() {
        super(CacheMode.DIST_SYNC, null, new int[]{0, 1}, new int[]{2, 3});
        this.mergePolicy = MergePolicy.PREFERRED_NON_NULL;
        this.valueAfterMerge = VAL;
    }

    TxConflictResolutionTest autoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
        return this;
    }

    @Override
    protected String[] parameterNames() {
        return TxConflictResolutionTest.concat(super.parameterNames(), "autoCommit");
    }

    @Override
    protected Object[] parameterValues() {
        return TxConflictResolutionTest.concat(super.parameterValues(), this.autoCommit);
    }

    @Override
    protected void customizeCacheConfiguration(ConfigurationBuilder dcc) {
        dcc.transaction().transactionMode(TransactionMode.TRANSACTIONAL).lockingMode(this.lockingMode).autoCommit(this.autoCommit);
    }

    @Override
    protected void beforeSplit() {
        this.conflictKey = new MagicKey(this.cache(this.p0.node(0)), this.cache(this.p1.node(0)));
    }

    @Override
    protected void duringSplit(AdvancedCache preferredPartitionCache, AdvancedCache otherCache) throws Exception {
        try {
            this.tm(this.p0.node(0)).begin();
            this.cache(this.p0.node(0)).put((Object)this.conflictKey, (Object)VAL);
        }
        finally {
            this.tm(this.p0.node(0)).commit();
        }
        this.assertCacheGet(this.conflictKey, VAL, this.p0.getNodes());
        this.assertCacheGet(this.conflictKey, null, this.p1.getNodes());
    }

    @Override
    protected void performMerge() {
        this.assertCacheGet(this.conflictKey, VAL, this.p0.getNodes());
        this.assertCacheGet(this.conflictKey, null, this.p1.getNodes());
        this.partition(0).merge(this.partition(1), false);
        TestingUtil.waitForNoRebalance(this.caches());
        this.assertCacheGet(this.conflictKey, VAL, this.cacheIndexes());
    }
}

