/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.container.entries.TransientCacheEntry;
import org.infinispan.container.entries.TransientMortalCacheEntry;
import org.infinispan.container.impl.DefaultDataContainer;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.impl.InternalEntryFactoryImpl;
import org.infinispan.eviction.impl.ActivationManager;
import org.infinispan.expiration.impl.InternalExpirationManager;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.CoreImmutables;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="container.SimpleDataContainerTest")
public class SimpleDataContainerTest
extends AbstractInfinispanTest {
    private InternalDataContainer<String, String> dc;
    private ControlledTimeService timeService;

    @BeforeMethod
    public void setUp() {
        this.dc = this.createContainer();
    }

    @AfterMethod
    public void tearDown() {
        this.dc = null;
    }

    protected InternalDataContainer<String, String> createContainer() {
        DefaultDataContainer dc = new DefaultDataContainer(16);
        InternalEntryFactoryImpl internalEntryFactory = new InternalEntryFactoryImpl();
        this.timeService = new ControlledTimeService();
        TestingUtil.inject(internalEntryFactory, this.timeService);
        ActivationManager activationManager = (ActivationManager)Mockito.mock(ActivationManager.class);
        InternalExpirationManager expirationManager = (InternalExpirationManager)Mockito.mock(InternalExpirationManager.class);
        Mockito.when((Object)expirationManager.entryExpiredInMemory((InternalCacheEntry)Mockito.any(), Mockito.anyLong(), Mockito.anyBoolean())).thenReturn((Object)CompletableFutures.completedTrue());
        TestingUtil.inject(dc, internalEntryFactory, this.timeService, expirationManager);
        return dc;
    }

    public void testExpiredData() throws InterruptedException {
        this.dc.put((Object)"k", (Object)"v", new EmbeddedMetadata.Builder().maxIdle(100L, TimeUnit.MINUTES).build());
        this.timeService.advance(100L);
        InternalCacheEntry entry = this.dc.get((Object)"k");
        AssertJUnit.assertNotNull((Object)entry);
        AssertJUnit.assertEquals(this.transienttype(), (Object)entry.getClass());
        AssertJUnit.assertEquals((long)this.timeService.wallClockTime(), (long)entry.getLastUsed());
        long entryLastUsed = entry.getLastUsed();
        this.timeService.advance(100L);
        entry = this.dc.get((Object)"k");
        AssertJUnit.assertEquals((long)(entryLastUsed + 100L), (long)entry.getLastUsed());
        this.dc.put((Object)"k", (Object)"v", new EmbeddedMetadata.Builder().maxIdle(1L, TimeUnit.MILLISECONDS).build());
        long oldTime = this.timeService.wallClockTime();
        this.dc.put((Object)"k", (Object)"v", new EmbeddedMetadata.Builder().lifespan(100L, TimeUnit.MINUTES).build());
        this.timeService.advance(100L);
        AssertJUnit.assertEquals((int)1, (int)this.dc.size());
        entry = this.dc.get((Object)"k");
        AssertJUnit.assertNotNull((Object)entry);
        AssertJUnit.assertEquals(this.mortaltype(), (Object)entry.getClass());
        AssertJUnit.assertEquals((long)oldTime, (long)entry.getCreated());
        AssertJUnit.assertEquals((long)-1L, (long)entry.getMaxIdle());
        this.dc.put((Object)"k", (Object)"v", new EmbeddedMetadata.Builder().lifespan(1L, TimeUnit.MILLISECONDS).build());
        this.timeService.advance(10L);
        AssertJUnit.assertNull((Object)this.dc.get((Object)"k"));
        AssertJUnit.assertEquals((int)0, (int)this.dc.size());
        this.dc.put((Object)"k", (Object)"v", new EmbeddedMetadata.Builder().lifespan(1L, TimeUnit.MILLISECONDS).build());
        this.timeService.advance(100L);
        AssertJUnit.assertEquals((int)0, (int)this.dc.size());
    }

    public void testResetOfCreationTime() throws Exception {
        long now = this.timeService.wallClockTime();
        this.timeService.advance(1L);
        this.dc.put((Object)"k", (Object)"v", new EmbeddedMetadata.Builder().lifespan(1000L, TimeUnit.SECONDS).build());
        long created1 = this.dc.get((Object)"k").getCreated();
        AssertJUnit.assertEquals((long)(now + 1L), (long)created1);
        this.timeService.advance(100L);
        this.dc.put((Object)"k", (Object)"v", new EmbeddedMetadata.Builder().lifespan(1000L, TimeUnit.SECONDS).build());
        long created2 = this.dc.get((Object)"k").getCreated();
        AssertJUnit.assertEquals((long)(now + 101L), (long)created2);
    }

    public void testUpdatingLastUsed() throws Exception {
        long idle = 600000L;
        this.dc.put((Object)"k", (Object)"v", new EmbeddedMetadata.Builder().build());
        InternalCacheEntry ice = this.dc.get((Object)"k");
        AssertJUnit.assertEquals(this.immortaltype(), (Object)ice.getClass());
        AssertJUnit.assertEquals((long)-1L, (long)ice.toInternalCacheValue().getExpiryTime());
        AssertJUnit.assertEquals((long)-1L, (long)ice.getMaxIdle());
        AssertJUnit.assertEquals((long)-1L, (long)ice.getLifespan());
        AssertJUnit.assertFalse((boolean)this.dc.hasExpirable());
        this.dc.put((Object)"k", (Object)"v", new EmbeddedMetadata.Builder().maxIdle(idle, TimeUnit.MILLISECONDS).build());
        this.timeService.advance(100L);
        ice = this.dc.get((Object)"k");
        AssertJUnit.assertEquals(this.transienttype(), (Object)ice.getClass());
        AssertJUnit.assertEquals((long)(idle + this.timeService.wallClockTime()), (long)ice.toInternalCacheValue().getExpiryTime());
        AssertJUnit.assertEquals((long)this.timeService.wallClockTime(), (long)ice.getLastUsed());
        AssertJUnit.assertEquals((long)idle, (long)ice.getMaxIdle());
        AssertJUnit.assertEquals((long)-1L, (long)ice.getLifespan());
        AssertJUnit.assertTrue((boolean)this.dc.hasExpirable());
        this.timeService.advance(100L);
        AssertJUnit.assertNotNull((Object)this.dc.get((Object)"k"));
        long oldTime = this.timeService.wallClockTime();
        AssertJUnit.assertEquals((long)oldTime, (long)ice.getLastUsed());
        this.timeService.advance(100L);
        AssertJUnit.assertEquals((long)oldTime, (long)ice.getLastUsed());
    }

    protected Class<? extends InternalCacheEntry> mortaltype() {
        return MortalCacheEntry.class;
    }

    protected Class<? extends InternalCacheEntry> immortaltype() {
        return ImmortalCacheEntry.class;
    }

    protected Class<? extends InternalCacheEntry> transienttype() {
        return TransientCacheEntry.class;
    }

    protected Class<? extends InternalCacheEntry> transientmortaltype() {
        return TransientMortalCacheEntry.class;
    }

    public void testExpirableToImmortalAndBack() {
        String value = "v";
        this.dc.put((Object)"k", (Object)value, new EmbeddedMetadata.Builder().lifespan(100L, TimeUnit.MINUTES).build());
        this.assertContainerEntry(this.mortaltype(), value);
        AssertJUnit.assertTrue((boolean)this.dc.hasExpirable());
        value = "v2";
        this.dc.put((Object)"k", (Object)value, new EmbeddedMetadata.Builder().build());
        this.assertContainerEntry(this.immortaltype(), value);
        AssertJUnit.assertFalse((boolean)this.dc.hasExpirable());
        value = "v3";
        this.dc.put((Object)"k", (Object)value, new EmbeddedMetadata.Builder().maxIdle(100L, TimeUnit.MINUTES).build());
        this.assertContainerEntry(this.transienttype(), value);
        AssertJUnit.assertTrue((boolean)this.dc.hasExpirable());
        value = "v4";
        this.dc.put((Object)"k", (Object)value, new EmbeddedMetadata.Builder().lifespan(100L, TimeUnit.MINUTES).maxIdle(100L, TimeUnit.MINUTES).build());
        this.assertContainerEntry(this.transientmortaltype(), value);
        AssertJUnit.assertTrue((boolean)this.dc.hasExpirable());
        value = "v41";
        this.dc.put((Object)"k", (Object)value, new EmbeddedMetadata.Builder().lifespan(100L, TimeUnit.MINUTES).maxIdle(100L, TimeUnit.MINUTES).build());
        this.assertContainerEntry(this.transientmortaltype(), value);
        AssertJUnit.assertTrue((boolean)this.dc.hasExpirable());
        value = "v5";
        this.dc.put((Object)"k", (Object)value, new EmbeddedMetadata.Builder().lifespan(100L, TimeUnit.MINUTES).build());
        this.assertContainerEntry(this.mortaltype(), value);
        AssertJUnit.assertTrue((boolean)this.dc.hasExpirable());
    }

    private void assertContainerEntry(Class<? extends InternalCacheEntry> type, String expectedValue) {
        AssertJUnit.assertTrue((boolean)this.dc.containsKey((Object)"k"));
        InternalCacheEntry entry = this.dc.get((Object)"k");
        AssertJUnit.assertEquals(type, (Object)entry.getClass());
        AssertJUnit.assertEquals((Object)expectedValue, (Object)entry.getValue());
    }

    public void testKeySet() {
        this.dc.put((Object)"k1", (Object)"v", new EmbeddedMetadata.Builder().lifespan(100L, TimeUnit.MINUTES).build());
        this.dc.put((Object)"k2", (Object)"v", new EmbeddedMetadata.Builder().build());
        this.dc.put((Object)"k3", (Object)"v", new EmbeddedMetadata.Builder().maxIdle(100L, TimeUnit.MINUTES).build());
        this.dc.put((Object)"k4", (Object)"v", new EmbeddedMetadata.Builder().maxIdle(100L, TimeUnit.MINUTES).lifespan(100L, TimeUnit.MINUTES).build());
        HashSet<String> expected = new HashSet<String>();
        expected.add("k1");
        expected.add("k2");
        expected.add("k3");
        expected.add("k4");
        for (InternalCacheEntry entry : this.dc) {
            String o = (String)entry.getKey();
            AssertJUnit.assertTrue((boolean)expected.remove(o));
        }
        AssertJUnit.assertTrue((String)("Did not see keys " + String.valueOf(expected) + " in iterator!"), (boolean)expected.isEmpty());
    }

    public void testContainerIteration() {
        this.dc.put((Object)"k1", (Object)"v", new EmbeddedMetadata.Builder().lifespan(100L, TimeUnit.MINUTES).build());
        this.dc.put((Object)"k2", (Object)"v", new EmbeddedMetadata.Builder().build());
        this.dc.put((Object)"k3", (Object)"v", new EmbeddedMetadata.Builder().maxIdle(100L, TimeUnit.MINUTES).build());
        this.dc.put((Object)"k4", (Object)"v", new EmbeddedMetadata.Builder().maxIdle(100L, TimeUnit.MINUTES).lifespan(100L, TimeUnit.MINUTES).build());
        HashSet<String> expected = new HashSet<String>();
        expected.add("k1");
        expected.add("k2");
        expected.add("k3");
        expected.add("k4");
        for (InternalCacheEntry ice : this.dc) {
            AssertJUnit.assertTrue((boolean)expected.remove(ice.getKey()));
        }
        AssertJUnit.assertTrue((String)("Did not see keys " + String.valueOf(expected) + " in iterator!"), (boolean)expected.isEmpty());
    }

    public void testKeys() {
        this.dc.put((Object)"k1", (Object)"v1", new EmbeddedMetadata.Builder().lifespan(100L, TimeUnit.MINUTES).build());
        this.dc.put((Object)"k2", (Object)"v2", new EmbeddedMetadata.Builder().build());
        this.dc.put((Object)"k3", (Object)"v3", new EmbeddedMetadata.Builder().maxIdle(100L, TimeUnit.MINUTES).build());
        this.dc.put((Object)"k4", (Object)"v4", new EmbeddedMetadata.Builder().maxIdle(100L, TimeUnit.MINUTES).lifespan(100L, TimeUnit.MINUTES).build());
        HashSet<String> expected = new HashSet<String>();
        expected.add("k1");
        expected.add("k2");
        expected.add("k3");
        expected.add("k4");
        for (InternalCacheEntry entry : this.dc) {
            String o = (String)entry.getKey();
            AssertJUnit.assertTrue((boolean)expected.remove(o));
        }
        AssertJUnit.assertTrue((String)("Did not see keys " + String.valueOf(expected) + " in iterator!"), (boolean)expected.isEmpty());
    }

    public void testValues() {
        this.dc.put((Object)"k1", (Object)"v1", new EmbeddedMetadata.Builder().lifespan(100L, TimeUnit.MINUTES).build());
        this.dc.put((Object)"k2", (Object)"v2", new EmbeddedMetadata.Builder().build());
        this.dc.put((Object)"k3", (Object)"v3", new EmbeddedMetadata.Builder().maxIdle(100L, TimeUnit.MINUTES).build());
        this.dc.put((Object)"k4", (Object)"v4", new EmbeddedMetadata.Builder().maxIdle(100L, TimeUnit.MINUTES).lifespan(100L, TimeUnit.MINUTES).build());
        HashSet<String> expected = new HashSet<String>();
        expected.add("v1");
        expected.add("v2");
        expected.add("v3");
        expected.add("v4");
        for (InternalCacheEntry entry : this.dc) {
            String o = (String)entry.getValue();
            AssertJUnit.assertTrue((boolean)expected.remove(o));
        }
        AssertJUnit.assertTrue((String)("Did not see keys " + String.valueOf(expected) + " in iterator!"), (boolean)expected.isEmpty());
    }

    public void testEntrySet() {
        this.dc.put((Object)"k1", (Object)"v1", new EmbeddedMetadata.Builder().lifespan(100L, TimeUnit.MINUTES).build());
        this.dc.put((Object)"k2", (Object)"v2", new EmbeddedMetadata.Builder().build());
        this.dc.put((Object)"k3", (Object)"v3", new EmbeddedMetadata.Builder().maxIdle(100L, TimeUnit.MINUTES).build());
        this.dc.put((Object)"k4", (Object)"v4", new EmbeddedMetadata.Builder().maxIdle(100L, TimeUnit.MINUTES).lifespan(100L, TimeUnit.MINUTES).build());
        HashSet<InternalCacheEntry> expected = new HashSet<InternalCacheEntry>();
        expected.add(CoreImmutables.immutableInternalCacheEntry((InternalCacheEntry)this.dc.get((Object)"k1")));
        expected.add(CoreImmutables.immutableInternalCacheEntry((InternalCacheEntry)this.dc.get((Object)"k2")));
        expected.add(CoreImmutables.immutableInternalCacheEntry((InternalCacheEntry)this.dc.get((Object)"k3")));
        expected.add(CoreImmutables.immutableInternalCacheEntry((InternalCacheEntry)this.dc.get((Object)"k4")));
        HashSet<Map.Entry> actual = new HashSet<Map.Entry>();
        for (Map.Entry o : this.dc) {
            AssertJUnit.assertTrue((boolean)actual.add(o));
        }
        AssertJUnit.assertEquals((String)("Expected to see keys " + String.valueOf(expected) + " but only saw " + String.valueOf(actual)), expected, actual);
    }

    public void testGetDuringKeySetLoop() {
        int i;
        for (i = 0; i < 10; ++i) {
            this.dc.put((Object)String.valueOf(i), (Object)"value", new EmbeddedMetadata.Builder().build());
        }
        i = 0;
        for (InternalCacheEntry entry : this.dc) {
            Object key = entry.getKey();
            this.dc.peek(key);
            ++i;
        }
        AssertJUnit.assertEquals((int)10, (int)i);
    }

    public void testEntrySetStreamWithExpiredEntries() {
        this.dc.put((Object)"k1", (Object)"v1", new EmbeddedMetadata.Builder().lifespan(100L, TimeUnit.MILLISECONDS).build());
        this.dc.put((Object)"k2", (Object)"v2", new EmbeddedMetadata.Builder().build());
        this.dc.put((Object)"k3", (Object)"v3", new EmbeddedMetadata.Builder().maxIdle(200L, TimeUnit.MILLISECONDS).build());
        HashSet<InternalCacheEntry> expected = new HashSet<InternalCacheEntry>();
        InternalCacheEntry k1 = CoreImmutables.immutableInternalCacheEntry((InternalCacheEntry)this.dc.get((Object)"k1"));
        expected.add(k1);
        expected.add(CoreImmutables.immutableInternalCacheEntry((InternalCacheEntry)this.dc.get((Object)"k2")));
        InternalCacheEntry k3 = CoreImmutables.immutableInternalCacheEntry((InternalCacheEntry)this.dc.get((Object)"k3"));
        expected.add(k3);
        List results = StreamSupport.stream(this.dc.spliterator(), false).collect(Collectors.toList());
        AssertJUnit.assertEquals((int)3, (int)results.size());
        this.assertArrayAndSetContainSame(expected, results);
        this.timeService.advance(101L);
        results = StreamSupport.stream(this.dc.spliterator(), false).collect(Collectors.toList());
        AssertJUnit.assertEquals((int)2, (int)results.size());
        expected.remove(k1);
        this.assertArrayAndSetContainSame(expected, results);
        this.timeService.advance(100L);
        results = StreamSupport.stream(this.dc.spliterator(), false).collect(Collectors.toList());
        AssertJUnit.assertEquals((int)1, (int)results.size());
        expected.remove(k3);
        this.assertArrayAndSetContainSame(expected, results);
    }

    private <E> void assertArrayAndSetContainSame(Set<E> expected, List<E> results) {
        for (E result : results) {
            AssertJUnit.assertTrue((String)("Set didn't contain " + String.valueOf(result)), (boolean)expected.contains(result));
        }
    }
}

