/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.util.ByteQuantity;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.DataContainer;
import org.infinispan.container.offheap.BoundedOffHeapDataContainer;
import org.infinispan.container.offheap.OffHeapMemoryAllocator;
import org.infinispan.container.offheap.UnpooledOffHeapMemoryAllocator;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.eviction.EvictionType;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="container.offheap.OffHeapBoundedMemoryTest")
public class OffHeapBoundedMemoryTest
extends AbstractInfinispanTest {
    public void testTooSmallToInsert() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.memory().size(UnpooledOffHeapMemoryAllocator.estimateSizeOverhead((long)2048L) + 1L).evictionType(EvictionType.MEMORY).storageType(StorageType.OFF_HEAP);
        EmbeddedCacheManager manager = TestCacheManagerFactory.createCacheManager(builder);
        Cache smallHeapCache = manager.getCache();
        AssertJUnit.assertEquals((int)0, (int)smallHeapCache.size());
        AssertJUnit.assertNull((Object)smallHeapCache.put((Object)1, (Object)3));
        AssertJUnit.assertEquals((int)0, (int)smallHeapCache.size());
    }

    private static DataContainer getContainer(AdvancedCache cache) {
        return cache.getDataContainer();
    }

    public void testAllocatedAmountEqual() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.memory().size(ByteQuantity.Unit.MB.toBytes(20L)).evictionType(EvictionType.MEMORY).storageType(StorageType.OFF_HEAP);
        EmbeddedCacheManager manager = TestCacheManagerFactory.createCacheManager(builder);
        AdvancedCache cache = manager.getCache().getAdvancedCache();
        OffHeapMemoryAllocator allocator = (OffHeapMemoryAllocator)ComponentRegistry.componentOf((Cache)cache, OffHeapMemoryAllocator.class);
        BoundedOffHeapDataContainer container = (BoundedOffHeapDataContainer)OffHeapBoundedMemoryTest.getContainer(cache);
        AssertJUnit.assertEquals((long)allocator.getAllocatedAmount(), (long)container.currentSize);
        cache.put((Object)1, (Object)2);
        AssertJUnit.assertEquals((long)allocator.getAllocatedAmount(), (long)container.currentSize);
        cache.clear();
        AssertJUnit.assertEquals((long)allocator.getAllocatedAmount(), (long)container.currentSize);
    }

    public void testAllocatedAmountEqualWithVersion() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.memory().size(ByteQuantity.Unit.MB.toBytes(20L)).evictionType(EvictionType.MEMORY).storageType(StorageType.OFF_HEAP);
        EmbeddedCacheManager manager = TestCacheManagerFactory.createCacheManager(builder);
        AdvancedCache cache = manager.getCache().getAdvancedCache();
        cache.put((Object)1, (Object)2, new EmbeddedMetadata.Builder().version((EntryVersion)new NumericVersion(23L)).build());
        OffHeapMemoryAllocator allocator = (OffHeapMemoryAllocator)ComponentRegistry.componentOf((Cache)cache, OffHeapMemoryAllocator.class);
        BoundedOffHeapDataContainer container = (BoundedOffHeapDataContainer)OffHeapBoundedMemoryTest.getContainer(cache);
        AssertJUnit.assertEquals((long)allocator.getAllocatedAmount(), (long)container.currentSize);
        cache.clear();
        AssertJUnit.assertEquals((long)allocator.getAllocatedAmount(), (long)container.currentSize);
    }

    public void testAllocatedAmountEqualWithExpiration() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.memory().size(ByteQuantity.Unit.MB.toBytes(20L)).evictionType(EvictionType.MEMORY).storageType(StorageType.OFF_HEAP);
        EmbeddedCacheManager manager = TestCacheManagerFactory.createCacheManager(builder);
        AdvancedCache cache = manager.getCache().getAdvancedCache();
        cache.put((Object)"lifespan", (Object)"value", 1L, TimeUnit.MINUTES);
        cache.put((Object)"both", (Object)"value", 1L, TimeUnit.MINUTES, 1L, TimeUnit.MINUTES);
        cache.put((Object)"maxidle", (Object)"value", -1L, TimeUnit.MINUTES, 1L, TimeUnit.MINUTES);
        OffHeapMemoryAllocator allocator = (OffHeapMemoryAllocator)ComponentRegistry.componentOf((Cache)cache, OffHeapMemoryAllocator.class);
        BoundedOffHeapDataContainer container = (BoundedOffHeapDataContainer)OffHeapBoundedMemoryTest.getContainer(cache);
        AssertJUnit.assertEquals((long)allocator.getAllocatedAmount(), (long)container.currentSize);
        cache.clear();
        AssertJUnit.assertEquals((long)allocator.getAllocatedAmount(), (long)container.currentSize);
    }

    public void testAllocatedAmountEqualWithVersionAndExpiration() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.memory().size(ByteQuantity.Unit.MB.toBytes(20L)).evictionType(EvictionType.MEMORY).storageType(StorageType.OFF_HEAP);
        EmbeddedCacheManager manager = TestCacheManagerFactory.createCacheManager(builder);
        AdvancedCache cache = manager.getCache().getAdvancedCache();
        cache.put((Object)"lifespan", (Object)2, new EmbeddedMetadata.Builder().lifespan(1L, TimeUnit.MINUTES).version((EntryVersion)new NumericVersion(23L)).build());
        cache.put((Object)"both", (Object)2, new EmbeddedMetadata.Builder().lifespan(1L, TimeUnit.MINUTES).maxIdle(1L, TimeUnit.MINUTES).version((EntryVersion)new NumericVersion(23L)).build());
        cache.put((Object)"maxidle", (Object)2, new EmbeddedMetadata.Builder().maxIdle(1L, TimeUnit.MINUTES).version((EntryVersion)new NumericVersion(23L)).build());
        OffHeapMemoryAllocator allocator = (OffHeapMemoryAllocator)ComponentRegistry.componentOf((Cache)cache, OffHeapMemoryAllocator.class);
        BoundedOffHeapDataContainer container = (BoundedOffHeapDataContainer)OffHeapBoundedMemoryTest.getContainer(cache);
        AssertJUnit.assertEquals((long)allocator.getAllocatedAmount(), (long)container.currentSize);
        cache.clear();
        AssertJUnit.assertEquals((long)allocator.getAllocatedAmount(), (long)container.currentSize);
    }
}

