/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.HashMap;
import org.infinispan.Cache;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.BaseDistStoreTest;
import org.infinispan.distribution.MagicKey;
import org.infinispan.marshall.persistence.impl.MarshalledEntryUtil;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.DistSyncStoreSharedTest")
public class DistSyncStoreSharedTest<D extends DistSyncStoreSharedTest<D>>
extends BaseDistStoreTest<Object, String, D> {
    public DistSyncStoreSharedTest() {
        this.testRetVals = true;
        this.shared = true;
    }

    @Override
    protected ConfigurationBuilder buildConfiguration() {
        ConfigurationBuilder configurationBuilder = super.buildConfiguration();
        configurationBuilder.statistics().enable();
        return configurationBuilder;
    }

    @Override
    @AfterMethod
    protected void clearContent() throws Throwable {
        super.clearContent();
        for (Cache c : this.caches) {
            log.trace((Object)("Clearing stats for cache store on cache " + String.valueOf(c)));
            this.clearStats(c);
        }
    }

    @Override
    public Object[] factory() {
        return new Object[]{new DistSyncStoreSharedTest<D>().segmented(true), new DistSyncStoreSharedTest<D>().segmented(false)};
    }

    public void testPutFromNonOwner() throws Exception {
        String key = "k4";
        String value = "value4";
        for (Cache c : this.caches) {
            assert (c.isEmpty());
        }
        Cache nonOwner = this.getFirstNonOwner(key);
        DummyInMemoryStore nonOwnerStore = (DummyInMemoryStore)TestingUtil.getFirstStore(nonOwner);
        assert (!nonOwnerStore.contains(key));
        Object retval = nonOwner.put((Object)key, (Object)value);
        this.asyncWait((Object)key, PutKeyValueCommand.class);
        Cache<K, V>[] owners = this.getOwners(key);
        DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(owners[0]);
        this.assertIsInContainerImmortal(owners[0], key);
        assert (store.contains(key));
        for (int i = 1; i < owners.length; ++i) {
            store = (DummyInMemoryStore)TestingUtil.getFirstStore(owners[i]);
            this.assertIsInContainerImmortal(owners[i], key);
            assert (store.contains(key));
        }
        for (Cache c : this.caches) {
            store = (DummyInMemoryStore)TestingUtil.getFirstStore(c);
            assert (store.contains(key));
            this.assertNumberOfInvocations(store, "write", 1);
        }
        if (this.testRetVals) assert (retval == null);
        this.assertOnAllCachesAndOwnership(key, value);
    }

    public void testPutFromOwner() throws Exception {
        String key = "k5";
        String value = "value5";
        for (Cache c : this.caches) {
            assert (c.isEmpty());
        }
        Cache<K, V>[] owners = this.getOwners(key);
        Object retval = owners[0].put((Object)key, (Object)value);
        this.asyncWait((Object)key, PutKeyValueCommand.class);
        DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(owners[0]);
        this.assertIsInContainerImmortal(owners[0], key);
        assert (store.contains(key));
        for (int i = 1; i < owners.length; ++i) {
            store = (DummyInMemoryStore)TestingUtil.getFirstStore(owners[i]);
            this.assertIsInContainerImmortal(owners[i], key);
            assert (store.contains(key));
        }
        for (Cache c : this.caches) {
            store = (DummyInMemoryStore)TestingUtil.getFirstStore(c);
            if (this.isOwner(c, key)) {
                this.assertIsInContainerImmortal(c, key);
            }
            assert (store.contains(key));
            this.assertNumberOfInvocations(store, "write", 1);
        }
        if (this.testRetVals) assert (retval == null);
        this.assertOnAllCachesAndOwnership(key, value);
    }

    public void testPutAll() throws Exception {
        log.trace((Object)"Here it begins");
        String k1 = "1";
        String v1 = "one";
        String k2 = "2";
        String v2 = "two";
        String k3 = "3";
        String v3 = "three";
        String k4 = "4";
        String v4 = "four";
        String[] keys = new String[]{k1, k2, k3, k4};
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(k1, v1);
        data.put(k2, v2);
        data.put(k3, v3);
        data.put(k4, v4);
        this.c1.putAll(data);
        for (String key : keys) {
            for (Cache c : this.caches) {
                DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(c);
                if (this.isFirstOwner(c, key)) {
                    this.assertIsInContainerImmortal(c, key);
                }
                log.debug((Object)("Testing " + String.valueOf(c)));
                this.assertNumberOfInvocations(store, "write", 4);
                AssertJUnit.assertTrue((boolean)store.contains(key));
            }
        }
        long persistenceManagerInserts = 0L;
        for (Cache c : this.caches) {
            persistenceManagerInserts += this.getCacheWriterInterceptor(c).getWritesToTheStores();
        }
        AssertJUnit.assertEquals((long)this.expectedWriteCount(), (long)persistenceManagerInserts);
    }

    protected int expectedWriteCount() {
        return 4;
    }

    public void testRemoveFromNonOwner() throws Exception {
        String key = "k1";
        String value = "value";
        this.initAndTest();
        for (Cache c : this.caches) {
            DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(c);
            if (!this.isFirstOwner(c, key)) continue;
            this.assertIsInContainerImmortal(c, key);
            assert (store.loadEntry(key).getValue().equals(value));
        }
        Object retval = this.getFirstNonOwner(key).remove((Object)key);
        this.asyncWait((Object)"k1", RemoveCommand.class);
        if (this.testRetVals) assert (value.equals(retval));
        for (Cache c : this.caches) {
            DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(c);
            MarshallableEntry me = store.loadEntry(key);
            if (me == null) {
                this.assertNumberOfInvocations(store, "delete", 1);
                this.assertNumberOfInvocations(store, "write", 1);
                continue;
            }
            this.assertNumberOfInvocations(store, "write", 2);
        }
    }

    public void testReplaceFromNonOwner() throws Exception {
        String key = "k1";
        String value = "value";
        String value2 = "v2";
        this.initAndTest();
        for (Cache c : this.caches) {
            DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(c);
            if (!this.isFirstOwner(c, key)) continue;
            this.assertIsInContainerImmortal(c, key);
            assert (store.loadEntry(key).getValue().equals(value));
        }
        Object retval = this.getFirstNonOwner(key).replace((Object)key, (Object)value2);
        this.asyncWait((Object)key, ReplaceCommand.class);
        if (this.testRetVals) assert (value.equals(retval));
        for (Cache c : this.caches) {
            DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(c);
            if (this.isFirstOwner(c, key)) {
                this.assertIsInContainerImmortal(c, key);
            }
            assert (store.loadEntry(key).getValue().equals(value2));
            this.assertNumberOfInvocations(store, "write", 2);
        }
    }

    public void testClear() throws Exception {
        int i;
        for (Cache c : this.caches) {
            assert (c.isEmpty());
        }
        for (i = 0; i < 5; ++i) {
            this.getOwners("k" + i)[0].put((Object)("k" + i), (Object)("value" + i));
            this.asyncWait((Object)("k" + i), PutKeyValueCommand.class);
        }
        for (i = 0; i < 5; ++i) {
            this.assertOnAllCachesAndOwnership("k" + i, "value" + i);
        }
        for (Cache c : this.caches) {
            assert (!c.isEmpty());
        }
        this.c1.clear();
        this.asyncWait(null, ClearCommand.class);
        for (Cache c : this.caches) {
            assert (c.isEmpty());
        }
        DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(this.c1);
        this.assertNumberOfInvocations(store, "clear", 1);
        for (int i2 = 0; i2 < 5; ++i2) {
            String key = "k" + i2;
            assert (!store.contains(key));
        }
    }

    public void testGetOnlyQueriesCacheOnOwners() throws PersistenceException {
        MagicKey k = this.getMagicKey();
        String v1 = "real-data";
        String v2 = "stale-data";
        DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(this.c3);
        store.write(MarshalledEntryUtil.create(k, "stale-data", this.c3));
        this.c1.put((Object)k, (Object)"real-data");
        AssertJUnit.assertEquals((String)"real-data", (String)((String)this.c3.get((Object)k)));
    }
}

