/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DistributionTestHelper {
    public static String safeType(Object o) {
        if (o == null) {
            return "null";
        }
        return o.getClass().getSimpleName();
    }

    public static void assertIsInL1(Cache<?, ?> cache, Object key) {
        DataContainer dc = cache.getAdvancedCache().getDataContainer();
        InternalCacheEntry ice = dc.peek(key);
        assert (ice != null) : "Entry for key [" + String.valueOf(key) + "] should be in L1 on cache at [" + String.valueOf(DistributionTestHelper.addressOf(cache)) + "]!";
        assert (!(ice instanceof ImmortalCacheEntry)) : "Entry for key [" + String.valueOf(key) + "] should have a lifespan on cache at [" + String.valueOf(DistributionTestHelper.addressOf(cache)) + "]!";
    }

    public static void assertIsNotInL1(Cache<?, ?> cache, Object key) {
        DataContainer dc = cache.getAdvancedCache().getDataContainer();
        InternalCacheEntry ice = dc.peek(key);
        assert (ice == null) : "Entry for key [" + String.valueOf(key) + "] should not be in data container at all on cache at [" + String.valueOf(DistributionTestHelper.addressOf(cache)) + "]!";
    }

    public static void assertIsInContainerImmortal(Cache<?, ?> cache, Object key) {
        String msg;
        Log log = LogFactory.getLog(BaseDistFunctionalTest.class);
        DataContainer dc = cache.getAdvancedCache().getDataContainer();
        InternalCacheEntry ice = dc.peek(key);
        if (ice == null) {
            msg = "Entry for key [" + String.valueOf(key) + "] should be in data container on cache at [" + String.valueOf(DistributionTestHelper.addressOf(cache)) + "]!";
            log.fatal((Object)msg);
            assert (false) : msg;
        }
        if (!(ice instanceof ImmortalCacheEntry)) {
            msg = "Entry for key [" + String.valueOf(key) + "] on cache at [" + String.valueOf(DistributionTestHelper.addressOf(cache)) + "] should be immortal but was [" + String.valueOf(ice) + "]!";
            log.fatal((Object)msg);
            assert (false) : msg;
        }
    }

    public static void assertIsInL1OrNull(Cache<?, ?> cache, Object key) {
        Log log = LogFactory.getLog(BaseDistFunctionalTest.class);
        DataContainer dc = cache.getAdvancedCache().getDataContainer();
        InternalCacheEntry ice = dc.peek(key);
        if (ice instanceof ImmortalCacheEntry) {
            String msg = "Entry for key [" + String.valueOf(key) + "] on cache at [" + String.valueOf(DistributionTestHelper.addressOf(cache)) + "] should be mortal or null but was [" + String.valueOf(ice) + "]!";
            log.fatal((Object)msg);
            assert (false) : msg;
        }
    }

    public static boolean isOwner(Cache<?, ?> c, Object key) {
        DistributionManager dm = c.getAdvancedCache().getDistributionManager();
        return dm.getCacheTopology().isWriteOwner(key);
    }

    public static boolean isFirstOwner(Cache<?, ?> c, Object key) {
        DistributionManager dm = c.getAdvancedCache().getDistributionManager();
        return dm.getCacheTopology().getDistribution(key).isPrimary();
    }

    public static boolean hasOwners(Object key, Cache<?, ?> primaryOwner, Cache<?, ?> ... backupOwners) {
        DistributionManager dm = primaryOwner.getAdvancedCache().getDistributionManager();
        List ownerAddresses = dm.getCacheTopology().getDistribution(key).writeOwners();
        if (!DistributionTestHelper.addressOf(primaryOwner).equals(ownerAddresses.get(0))) {
            return false;
        }
        for (Cache<?, ?> backupOwner : backupOwners) {
            if (ownerAddresses.contains(DistributionTestHelper.addressOf(backupOwner))) continue;
            return false;
        }
        return true;
    }

    public static <K, V> Collection<Cache<K, V>> getOwners(Object key, List<Cache<K, V>> caches) {
        ArrayList<Cache<K, V>> owners = new ArrayList<Cache<K, V>>();
        for (Cache<K, V> c : caches) {
            if (!DistributionTestHelper.isFirstOwner(c, key)) continue;
            owners.add(c);
            break;
        }
        for (Cache<K, V> c : caches) {
            if (!DistributionTestHelper.isOwner(c, key) || DistributionTestHelper.isFirstOwner(c, key)) continue;
            owners.add(c);
        }
        return owners;
    }

    public static <K, V> Cache<K, V> getFirstOwner(Object key, List<Cache<K, V>> caches) {
        return DistributionTestHelper.getOwners(key, caches).iterator().next();
    }

    public static <K, V> Cache<K, V> getFirstBackupOwner(Object key, List<Cache<K, V>> caches) {
        for (Cache<K, V> c : caches) {
            if (!DistributionTestHelper.isOwner(c, key) || DistributionTestHelper.isFirstOwner(c, key)) continue;
            return c;
        }
        return null;
    }

    public static <K, V> Collection<Cache<K, V>> getNonOwners(Object key, List<Cache<K, V>> caches) {
        ArrayList<Cache<K, V>> nonOwners = new ArrayList<Cache<K, V>>();
        for (Cache<K, V> c : caches) {
            if (DistributionTestHelper.isOwner(c, key)) continue;
            nonOwners.add(c);
        }
        return nonOwners;
    }

    public static <K, V> Cache<K, V> getFirstNonOwner(Object key, List<Cache<K, V>> caches) {
        return DistributionTestHelper.getNonOwners(key, caches).iterator().next();
    }

    public static Address addressOf(Cache<?, ?> cache) {
        EmbeddedCacheManager cacheManager = cache.getCacheManager();
        return cacheManager.getAddress();
    }
}

